/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PolicyException;

@JsonParsableException(errorCode="policies:id.invalid")
@Immutable
public final class PolicyIdInvalidException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:id.invalid";
    private static final String MESSAGE_TEMPLATE = "Policy ID ''{0}'' is not valid!";
    private static final String DEFAULT_DESCRIPTION = "It must conform to the namespaced entity ID notation (see Ditto documentation)";
    private static final URI DEFAULT_HREF = URI.create("https://www.eclipse.org/ditto/basic-namespaces-and-names.html#namespaced-id");
    private static final long serialVersionUID = 8154256308793903738L;

    public PolicyIdInvalidException(@Nullable String policyId) {
        this(DittoHeaders.empty(), MessageFormat.format(MESSAGE_TEMPLATE, policyId), DEFAULT_DESCRIPTION, null, DEFAULT_HREF);
    }

    private PolicyIdInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(@Nullable CharSequence policyId) {
        return new Builder(policyId);
    }

    public static PolicyIdInvalidException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (PolicyIdInvalidException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static PolicyIdInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (PolicyIdInvalidException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public JsonSchemaVersion[] getSupportedSchemaVersions() {
        return new JsonSchemaVersion[]{JsonSchemaVersion.V_2};
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<PolicyIdInvalidException> {
        private Builder() {
            this.description(PolicyIdInvalidException.DEFAULT_DESCRIPTION);
            this.href(DEFAULT_HREF);
        }

        private Builder(@Nullable CharSequence policyId) {
            this();
            this.message(MessageFormat.format(PolicyIdInvalidException.MESSAGE_TEMPLATE, policyId));
        }

        protected PolicyIdInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new PolicyIdInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

