/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.policies.PolicyException;

@JsonParsableException(errorCode="policies:policy.toolarge")
@Immutable
public final class PolicyTooLargeException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:policy.toolarge";
    private static final String MESSAGE_TEMPLATE = "The size of ''{0}'' kB exceeds the maximal allowed Policy size of ''{1}'' kB.";
    private static final String DEFAULT_DESCRIPTION = "Reduce the Policy size in the bounds of the specified limit";
    private static final long serialVersionUID = 2434234324327234489L;

    private PolicyTooLargeException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.REQUEST_ENTITY_TOO_LARGE, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(long actualBytes, long maxBytes) {
        return new Builder(actualBytes, maxBytes);
    }

    public static PolicyTooLargeException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (PolicyTooLargeException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<PolicyTooLargeException> {
        private Builder() {
            this.description(PolicyTooLargeException.DEFAULT_DESCRIPTION);
        }

        private Builder(long actualBytes, long maxBytes) {
            this();
            this.message(MessageFormat.format(PolicyTooLargeException.MESSAGE_TEMPLATE, (double)actualBytes / 1024.0, (double)maxBytes / 1024.0));
        }

        protected PolicyTooLargeException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new PolicyTooLargeException(dittoHeaders, message, description, cause, href);
        }
    }
}

