/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;
import org.eclipse.ditto.model.policies.EffectedPermissions;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.ResourceKey;

public interface Resource
extends Jsonifiable.WithFieldSelectorAndPredicate<JsonField> {
    public static Resource newInstance(ResourceKey resourceKey, EffectedPermissions effectedPermissions) {
        return PoliciesModelFactory.newResource(resourceKey, effectedPermissions);
    }

    public static Resource newInstance(ResourceKey resourceKey, JsonValue effectedPermissions) {
        return PoliciesModelFactory.newResource(resourceKey, effectedPermissions);
    }

    public static Resource newInstance(CharSequence resourceType, CharSequence resourcePath, EffectedPermissions effectedPermissions) {
        return PoliciesModelFactory.newResource(resourceType, resourcePath, effectedPermissions);
    }

    default public JsonSchemaVersion[] getSupportedSchemaVersions() {
        return new JsonSchemaVersion[]{JsonSchemaVersion.V_2};
    }

    public ResourceKey getResourceKey();

    public String getType();

    public JsonPointer getPath();

    public String getFullQualifiedPath();

    public EffectedPermissions getEffectedPermissions();

    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return ((JsonObject)this.toJson(schemaVersion, FieldType.regularOrSpecial())).get(fieldSelector);
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<Integer> SCHEMA_VERSION = JsonFactory.newIntFieldDefinition((CharSequence)JsonSchemaVersion.getJsonKey(), (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

