/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.Resource;
import org.eclipse.ditto.model.policies.ResourceKey;

public interface Resources
extends Iterable<Resource>,
Jsonifiable.WithFieldSelectorAndPredicate<JsonField> {
    public static Resources newInstance(Iterable<Resource> resources) {
        return PoliciesModelFactory.newResources(resources);
    }

    public static Resources newInstance(Resource resource, Resource ... furtherResources) {
        return PoliciesModelFactory.newResources(resource, furtherResources);
    }

    default public JsonSchemaVersion[] getSupportedSchemaVersions() {
        return new JsonSchemaVersion[]{JsonSchemaVersion.V_2};
    }

    default public Optional<Resource> getResource(String resourceType, CharSequence resourcePath) {
        return this.getResource(ResourceKey.newInstance(resourceType, resourcePath));
    }

    public Optional<Resource> getResource(ResourceKey var1);

    public Resources setResource(Resource var1);

    default public Resources removeResource(String resourceType, CharSequence resourcePath) {
        return this.removeResource(ResourceKey.newInstance(resourceType, resourcePath));
    }

    public Resources removeResource(ResourceKey var1);

    public int getSize();

    public boolean isEmpty();

    public Stream<Resource> stream();

    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return ((JsonObject)this.toJson(schemaVersion, FieldType.regularOrSpecial())).get(fieldSelector);
    }
}

