/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;
import org.eclipse.ditto.model.policies.ImmutableSubject;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.SubjectAnnouncement;
import org.eclipse.ditto.model.policies.SubjectExpiry;
import org.eclipse.ditto.model.policies.SubjectId;
import org.eclipse.ditto.model.policies.SubjectIssuer;
import org.eclipse.ditto.model.policies.SubjectType;

public interface Subject
extends Jsonifiable.WithFieldSelectorAndPredicate<JsonField> {
    public static Subject newInstance(SubjectIssuer issuer, CharSequence subject) {
        return PoliciesModelFactory.newSubject(SubjectId.newInstance(issuer, subject));
    }

    public static Subject newInstance(SubjectIssuer issuer, CharSequence subject, SubjectType subjectType) {
        return PoliciesModelFactory.newSubject(SubjectId.newInstance(issuer, subject), subjectType);
    }

    public static Subject newInstance(CharSequence subjectIssuerWithId, SubjectType subjectType) {
        return PoliciesModelFactory.newSubject(SubjectId.newInstance(subjectIssuerWithId), subjectType);
    }

    public static Subject newInstance(SubjectId subjectId) {
        return PoliciesModelFactory.newSubject(subjectId);
    }

    public static Subject newInstance(SubjectId subjectId, SubjectType subjectType) {
        return PoliciesModelFactory.newSubject(subjectId, subjectType);
    }

    public static Subject newInstance(SubjectId subjectId, SubjectType subjectType, @Nullable SubjectExpiry subjectExpiry) {
        return PoliciesModelFactory.newSubject(subjectId, subjectType, subjectExpiry);
    }

    public static Subject newInstance(SubjectId subjectId, SubjectType subjectType, @Nullable SubjectExpiry subjectExpiry, @Nullable SubjectAnnouncement subjectAnnouncement) {
        return ImmutableSubject.of(subjectId, subjectType, subjectExpiry, subjectAnnouncement);
    }

    default public JsonSchemaVersion[] getSupportedSchemaVersions() {
        return new JsonSchemaVersion[]{JsonSchemaVersion.V_2};
    }

    public SubjectId getId();

    public SubjectType getType();

    public Optional<SubjectExpiry> getExpiry();

    public Optional<SubjectAnnouncement> getAnnouncement();

    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return ((JsonObject)this.toJson(schemaVersion, FieldType.regularOrSpecial())).get(fieldSelector);
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<Integer> SCHEMA_VERSION = JsonFactory.newIntFieldDefinition((CharSequence)JsonSchemaVersion.getJsonKey(), (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> TYPE = JsonFactory.newStringFieldDefinition((CharSequence)"type", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> ANNOUNCEMENT = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"announcement", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> EXPIRY = JsonFactory.newStringFieldDefinition((CharSequence)"expiry", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

