/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PolicyException;

@JsonParsableException(errorCode="policies:subjectannouncement.invalid")
@Immutable
public final class SubjectAnnouncementInvalidException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:subjectannouncement.invalid";
    private static final String MESSAGE_TEMPLATE = "The 'beforeExpiry' duration ''{0}'' is not valid.";
    private static final String DESCRIPTION = "It must be a positive integer followed by 'h' (hours), 'm' (minutes) or 's' (seconds).";

    private SubjectAnnouncementInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(CharSequence beforeExpiry) {
        return new Builder(beforeExpiry, DESCRIPTION);
    }

    public static SubjectAnnouncementInvalidException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (SubjectAnnouncementInvalidException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static SubjectAnnouncementInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (SubjectAnnouncementInvalidException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public JsonSchemaVersion[] getSupportedSchemaVersions() {
        return new JsonSchemaVersion[]{JsonSchemaVersion.V_2};
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<SubjectAnnouncementInvalidException> {
        private Builder() {
            this.description(SubjectAnnouncementInvalidException.DESCRIPTION);
        }

        private Builder(CharSequence expiry, String description) {
            this();
            this.message(MessageFormat.format(SubjectAnnouncementInvalidException.MESSAGE_TEMPLATE, expiry));
            this.description(description);
        }

        protected SubjectAnnouncementInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new SubjectAnnouncementInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

