/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PolicyException;

@JsonParsableException(errorCode="policies:subjectexpiry.invalid")
@Immutable
public final class SubjectExpiryInvalidException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:subjectexpiry.invalid";
    private static final String MESSAGE_TEMPLATE = "Subject expiry timestamp ''{0}'' is not valid.";
    private static final String NOT_PARSABLE_AS_ISO_DESCRIPTION = "It must be provided as ISO-8601 formatted char sequence.";
    private static final String MUST_NOT_BE_PAST_DESCRIPTION = "It must not be in the past, please adjust to a timestamp in the future.";
    private static final long serialVersionUID = 980234789562098342L;

    private SubjectExpiryInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(CharSequence expiry) {
        return new Builder(expiry, NOT_PARSABLE_AS_ISO_DESCRIPTION);
    }

    public static Builder newBuilderTimestampInThePast(CharSequence expiry) {
        return new Builder(expiry, MUST_NOT_BE_PAST_DESCRIPTION);
    }

    public static SubjectExpiryInvalidException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (SubjectExpiryInvalidException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static SubjectExpiryInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (SubjectExpiryInvalidException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public JsonSchemaVersion[] getSupportedSchemaVersions() {
        return new JsonSchemaVersion[]{JsonSchemaVersion.V_2};
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<SubjectExpiryInvalidException> {
        private Builder() {
            this.description(SubjectExpiryInvalidException.NOT_PARSABLE_AS_ISO_DESCRIPTION);
        }

        private Builder(CharSequence expiry, String description) {
            this();
            this.message(MessageFormat.format(SubjectExpiryInvalidException.MESSAGE_TEMPLATE, expiry));
            this.description(description);
        }

        protected SubjectExpiryInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new SubjectExpiryInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

