/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import javax.annotation.Nonnull;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.SubjectIssuer;

public interface SubjectId
extends CharSequence {
    public static final String ISSUER_DELIMITER = ":";

    public static SubjectId newInstance(SubjectIssuer issuer, CharSequence subject) {
        return PoliciesModelFactory.newSubjectId(issuer, subject);
    }

    public static SubjectId newInstance(CharSequence issuerWithSubject) {
        return PoliciesModelFactory.newSubjectId(issuerWithSubject);
    }

    default public JsonFieldDefinition getJsonFieldDefinition() {
        return JsonFactory.newStringFieldDefinition((CharSequence)this, (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    }

    public SubjectIssuer getIssuer();

    public String getSubject();

    @Override
    @Nonnull
    public String toString();
}

