/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PolicyException;

@JsonParsableException(errorCode="policies:subjectid.invalid")
@Immutable
public final class SubjectIdInvalidException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:subjectid.invalid";
    private static final String MESSAGE_TEMPLATE = "Subject ID ''{0}'' is not valid!";
    private static final String DEFAULT_DESCRIPTION = "It must contain an issuer as prefix separated by a colon ':' from the actual subject";
    private static final long serialVersionUID = -2833735892375663681L;

    public SubjectIdInvalidException(CharSequence subjectId) {
        this(DittoHeaders.empty(), MessageFormat.format(MESSAGE_TEMPLATE, subjectId), DEFAULT_DESCRIPTION, null, null);
    }

    private SubjectIdInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(@Nullable CharSequence subjectId) {
        return new Builder(subjectId);
    }

    public static SubjectIdInvalidException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (SubjectIdInvalidException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static SubjectIdInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (SubjectIdInvalidException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public JsonSchemaVersion[] getSupportedSchemaVersions() {
        return new JsonSchemaVersion[]{JsonSchemaVersion.V_2};
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<SubjectIdInvalidException> {
        private Builder() {
            this.description(SubjectIdInvalidException.DEFAULT_DESCRIPTION);
        }

        private Builder(@Nullable CharSequence subjectId) {
            this();
            this.message(MessageFormat.format(SubjectIdInvalidException.MESSAGE_TEMPLATE, subjectId));
        }

        protected SubjectIdInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new SubjectIdInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

