/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.Subject;
import org.eclipse.ditto.model.policies.SubjectId;
import org.eclipse.ditto.model.policies.SubjectIssuer;

public interface Subjects
extends Iterable<Subject>,
Jsonifiable.WithFieldSelectorAndPredicate<JsonField> {
    public static Subjects newInstance(Iterable<Subject> subjects) {
        return PoliciesModelFactory.newSubjects(subjects);
    }

    public static Subjects newInstance(Subject subject, Subject ... furtherSubjects) {
        return PoliciesModelFactory.newSubjects(subject, furtherSubjects);
    }

    default public JsonSchemaVersion[] getSupportedSchemaVersions() {
        return new JsonSchemaVersion[]{JsonSchemaVersion.V_2};
    }

    default public Optional<Subject> getSubject(CharSequence subjectIssuerWithId) {
        return this.getSubject(SubjectId.newInstance(subjectIssuerWithId));
    }

    default public Optional<Subject> getSubject(SubjectIssuer issuer, CharSequence subject) {
        return this.getSubject(SubjectId.newInstance(issuer, subject));
    }

    public Optional<Subject> getSubject(SubjectId var1);

    public Subjects setSubject(Subject var1);

    default public Subjects removeSubject(CharSequence subjectIssuerWithId) {
        return this.removeSubject(SubjectId.newInstance(subjectIssuerWithId));
    }

    default public Subjects removeSubject(SubjectIssuer issuer, CharSequence subject) {
        return this.removeSubject(SubjectId.newInstance(issuer, subject));
    }

    public Subjects removeSubject(SubjectId var1);

    public int getSize();

    public boolean isEmpty();

    public Stream<Subject> stream();

    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return ((JsonObject)this.toJson(schemaVersion, FieldType.regularOrSpecial())).get(fieldSelector);
    }
}

