/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.exceptions.DittoJsonException;
import org.eclipse.ditto.model.things.AccessControlList;
import org.eclipse.ditto.model.things.AccessControlListBuilder;
import org.eclipse.ditto.model.things.AclEntry;
import org.eclipse.ditto.model.things.ImmutableAccessControlList;
import org.eclipse.ditto.model.things.ImmutableAccessControlListBuilder;
import org.eclipse.ditto.model.things.ImmutableAclEntry;
import org.eclipse.ditto.model.things.MutablePermissions;
import org.eclipse.ditto.model.things.Permission;
import org.eclipse.ditto.model.things.Permissions;

@Deprecated
@Immutable
public final class AccessControlListModelFactory {
    private AccessControlListModelFactory() {
        throw new AssertionError();
    }

    public static Permissions noPermissions() {
        return MutablePermissions.none();
    }

    public static Permissions allPermissions() {
        return MutablePermissions.all();
    }

    public static Permissions newPermissions(Collection<Permission> permissions) {
        return new MutablePermissions(permissions);
    }

    public static Permissions newPermissions(Permission permission, Permission ... furtherPermissions) {
        return MutablePermissions.of(permission, furtherPermissions);
    }

    public static Permissions newUnmodifiablePermissions(Permission permission, Permission ... furtherPermissions) {
        return new MutablePermissions(Collections.unmodifiableSet(EnumSet.of(permission, furtherPermissions)));
    }

    public static AclEntry newAclEntry(AuthorizationSubject authorizationSubject, Permission permission, Permission ... furtherPermissions) {
        return ImmutableAclEntry.of(authorizationSubject, permission, furtherPermissions);
    }

    public static AclEntry newAclEntry(AuthorizationSubject authorizationSubject, Iterable<Permission> permissions) {
        return ImmutableAclEntry.of(authorizationSubject, permissions);
    }

    public static AclEntry newAclEntry(JsonObject jsonObject) {
        return ImmutableAclEntry.fromJson(jsonObject);
    }

    public static AclEntry newAclEntry(CharSequence authorizationSubjectId, JsonValue permissionsValue) {
        return ImmutableAclEntry.of(authorizationSubjectId, permissionsValue);
    }

    public static AccessControlListBuilder newAclBuilder() {
        return ImmutableAccessControlListBuilder.newInstance();
    }

    public static AccessControlListBuilder newAclBuilder(Iterable<AclEntry> aclEntries) {
        return ImmutableAccessControlListBuilder.of(aclEntries);
    }

    public static AccessControlListBuilder newAclBuilder(Optional<? extends Iterable<AclEntry>> aclEntries) {
        ConditionChecker.checkNotNull(aclEntries, (String)"optional ACL entries");
        return aclEntries.map(AccessControlListModelFactory::newAclBuilder).orElseGet(AccessControlListModelFactory::newAclBuilder);
    }

    public static AccessControlList emptyAcl() {
        return ImmutableAccessControlList.empty();
    }

    public static AccessControlList newAcl(AclEntry entry, AclEntry ... furtherEntries) {
        return ImmutableAccessControlList.of(entry, furtherEntries);
    }

    public static AccessControlList newAcl(Iterable<AclEntry> entries) {
        return ImmutableAccessControlList.of(entries);
    }

    public static AccessControlList newAcl(JsonObject jsonObject) {
        return ImmutableAccessControlList.fromJson(jsonObject);
    }

    public static AccessControlList newAcl(String jsonString) {
        JsonObject jsonObject = (JsonObject)DittoJsonException.wrapJsonRuntimeException(() -> JsonFactory.newObject((String)jsonString));
        return ImmutableAccessControlList.fromJson(jsonObject);
    }
}

