/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.things.Permission;
import org.eclipse.ditto.model.things.ThingException;
import org.eclipse.ditto.model.things.ThingId;

@Deprecated
@JsonParsableException(errorCode="things:acl.invalid")
@Immutable
public final class AclInvalidException
extends DittoRuntimeException
implements ThingException {
    public static final String ERROR_CODE = "things:acl.invalid";
    private static final String MESSAGE_TEMPLATE = "The Access Control List of the Thing with ID ''{0}'' is invalid.";
    private static final String DEFAULT_DESCRIPTION = "There always has to be at least one ACL Entry with " + Permission.allToString() + " permissions.";
    private static final long serialVersionUID = -6048986750382302079L;

    private AclInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(@Nullable ThingId thingId) {
        return new Builder(thingId);
    }

    public static AclInvalidException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (AclInvalidException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static AclInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (AclInvalidException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public JsonSchemaVersion[] getSupportedSchemaVersions() {
        return new JsonSchemaVersion[]{JsonSchemaVersion.V_1};
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<AclInvalidException> {
        private Builder() {
            this.description(DEFAULT_DESCRIPTION);
        }

        private Builder(@Nullable ThingId thingId) {
            this();
            this.message(MessageFormat.format(AclInvalidException.MESSAGE_TEMPLATE, String.valueOf((Object)thingId)));
        }

        protected AclInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new AclInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

