/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.things.ThingException;
import org.eclipse.ditto.model.things.ThingId;

@Deprecated
@JsonParsableException(errorCode="things:acl.not.allowed")
@Immutable
public final class AclNotAllowedException
extends DittoRuntimeException
implements ThingException {
    public static final String ERROR_CODE = "things:acl.not.allowed";
    private static final String MESSAGE_TEMPLATE = "The schema version of the Thing with ID ''{0}'' does not allow Access Control List.";
    private static final String DEFAULT_DESCRIPTION = "Things in schema version 2 and higher use policies for permission management.";
    private static final long serialVersionUID = -2640894758584381867L;

    private AclNotAllowedException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(ThingId thingId) {
        return new Builder(thingId);
    }

    public static AclNotAllowedException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (AclNotAllowedException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static AclNotAllowedException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (AclNotAllowedException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public JsonSchemaVersion[] getSupportedSchemaVersions() {
        return new JsonSchemaVersion[]{JsonSchemaVersion.V_1};
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<AclNotAllowedException> {
        private Builder() {
            this.description(AclNotAllowedException.DEFAULT_DESCRIPTION);
        }

        private Builder(ThingId thingId) {
            this();
            this.message(MessageFormat.format(AclNotAllowedException.MESSAGE_TEMPLATE, String.valueOf((Object)thingId)));
        }

        protected AclNotAllowedException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new AclNotAllowedException(dittoHeaders, message, description, cause, href);
        }
    }
}

