/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.things.ThingException;

@JsonParsableException(errorCode="things:definition.identifier.invalid")
public final class DefinitionIdentifierInvalidException
extends DittoRuntimeException
implements ThingException {
    public static final String ERROR_CODE = "things:definition.identifier.invalid";
    private static final String MESSAGE_TEMPLATE = "Definition identifier <{0}> is invalid!";
    private static final String DEFAULT_DESCRIPTION = "An identifier string is expected to have the structure 'namespace:name:version'. Each segment must contain at least one char of [_a-zA-Z0-9\\-.]";
    private static final long serialVersionUID = -5652551484675928573L;

    public DefinitionIdentifierInvalidException(CharSequence identifierAsCharSequence) {
        this(DittoHeaders.empty(), MessageFormat.format(MESSAGE_TEMPLATE, identifierAsCharSequence), DEFAULT_DESCRIPTION, null, null);
    }

    private DefinitionIdentifierInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(CharSequence identifierAsCharSequence) {
        return new Builder(identifierAsCharSequence);
    }

    public static DefinitionIdentifierInvalidException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (DefinitionIdentifierInvalidException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static DefinitionIdentifierInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (DefinitionIdentifierInvalidException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<DefinitionIdentifierInvalidException> {
        private Builder() {
            this.description(DefinitionIdentifierInvalidException.DEFAULT_DESCRIPTION);
        }

        private Builder(CharSequence identifierAsCharSequence) {
            this();
            this.message(MessageFormat.format(DefinitionIdentifierInvalidException.MESSAGE_TEMPLATE, identifierAsCharSequence));
        }

        protected DefinitionIdentifierInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new DefinitionIdentifierInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

