/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.things.Feature;
import org.eclipse.ditto.model.things.FeatureDefinition;
import org.eclipse.ditto.model.things.FeatureProperties;

public interface FeatureBuilder {

    @NotThreadSafe
    public static interface FromCopyBuildable {
        public FromCopyBuildable definition(@Nullable FeatureDefinition var1);

        public FromCopyBuildable properties(@Nullable FeatureProperties var1);

        public FromCopyBuildable properties(@Nullable JsonObject var1);

        public FromCopyBuildable properties(Function<FeatureProperties, FeatureProperties> var1);

        public FromCopyBuildable desiredProperties(@Nullable FeatureProperties var1);

        public FromCopyBuildable desiredProperties(@Nullable JsonObject var1);

        public FromCopyBuildable desiredProperties(UnaryOperator<FeatureProperties> var1);

        default public FromCopyBuildable setId(String featureId) {
            return this.setId(existingId -> true, featureId);
        }

        public FromCopyBuildable setId(Predicate<String> var1, String var2);

        public Feature build();
    }

    public static interface FromScratchBuildable {
        public FromScratchBuildable definition(@Nullable FeatureDefinition var1);

        public FromScratchBuildable properties(@Nullable FeatureProperties var1);

        public FromScratchBuildable properties(@Nullable JsonObject var1);

        public FromScratchBuildable desiredProperties(@Nullable FeatureProperties var1);

        public FromScratchBuildable desiredProperties(@Nullable JsonObject var1);

        public FeatureBuildable withId(String var1);
    }

    public static interface FromJsonBuildable {
        public FeatureBuildable useId(String var1);
    }

    public static interface FeatureBuildable {
        public Feature build();
    }
}

