/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.Jsonifiable;
import org.eclipse.ditto.model.things.DefinitionIdentifier;
import org.eclipse.ditto.model.things.FeatureDefinitionBuilder;
import org.eclipse.ditto.model.things.ThingsModelFactory;

@Immutable
public interface FeatureDefinition
extends Iterable<DefinitionIdentifier>,
Jsonifiable<JsonArray> {
    public static FeatureDefinition fromIdentifier(CharSequence identifier, CharSequence ... furtherIdentifiers) {
        FeatureDefinitionBuilder builder = ThingsModelFactory.newFeatureDefinitionBuilder(identifier);
        for (CharSequence furtherIdentifier : (CharSequence[])ConditionChecker.checkNotNull((Object)furtherIdentifiers, (String)"further identifiers")) {
            builder.add(furtherIdentifier);
        }
        return builder.build();
    }

    public static FeatureDefinition fromJson(String jsonArrayAsString) {
        return ThingsModelFactory.newFeatureDefinition(jsonArrayAsString);
    }

    public static FeatureDefinition fromJson(JsonArray jsonArray) {
        return ThingsModelFactory.newFeatureDefinition(jsonArray);
    }

    public DefinitionIdentifier getFirstIdentifier();

    public int getSize();

    public Stream<DefinitionIdentifier> stream();
}

