/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;
import org.eclipse.ditto.model.things.Feature;
import org.eclipse.ditto.model.things.FeatureDefinition;
import org.eclipse.ditto.model.things.FeatureProperties;
import org.eclipse.ditto.model.things.FeaturesBuilder;
import org.eclipse.ditto.model.things.ThingsModelFactory;

@Immutable
public interface Features
extends Iterable<Feature>,
Jsonifiable.WithFieldSelectorAndPredicate<JsonField> {
    public static FeaturesBuilder newBuilder() {
        return ThingsModelFactory.newFeaturesBuilder();
    }

    default public FeaturesBuilder toBuilder() {
        return ThingsModelFactory.newFeaturesBuilder(this);
    }

    public Optional<Feature> getFeature(String var1);

    public Features setFeature(Feature var1);

    public Features removeFeature(String var1);

    public Features setDefinition(String var1, FeatureDefinition var2);

    public Features removeDefinition(String var1);

    public Features setProperties(String var1, FeatureProperties var2);

    public Features removeProperties(String var1);

    public Features setProperty(String var1, JsonPointer var2, JsonValue var3);

    public Features removeProperty(String var1, JsonPointer var2);

    public Features setDesiredProperties(CharSequence var1, FeatureProperties var2);

    public Features removeDesiredProperties(CharSequence var1);

    public Features setDesiredProperty(CharSequence var1, JsonPointer var2, JsonValue var3);

    public Features removeDesiredProperty(CharSequence var1, JsonPointer var2);

    default public boolean isNull() {
        return false;
    }

    public int getSize();

    public boolean isEmpty();

    public Stream<Feature> stream();

    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return ((JsonObject)this.toJson(schemaVersion, FieldType.regularOrSpecial())).get(fieldSelector);
    }
}

