/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.things.AccessControlList;
import org.eclipse.ditto.model.things.AccessControlListModelFactory;
import org.eclipse.ditto.model.things.AclEntry;
import org.eclipse.ditto.model.things.Permission;
import org.eclipse.ditto.model.things.Permissions;

@Deprecated
@Immutable
final class ImmutableAccessControlList
implements AccessControlList {
    private static final JsonFieldDefinition<Integer> JSON_SCHEMA_VERSION = JsonFactory.newIntFieldDefinition((CharSequence)JsonSchemaVersion.getJsonKey(), (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1});
    private final Map<AuthorizationSubject, AclEntry> entries;

    private ImmutableAccessControlList(Map<AuthorizationSubject, AclEntry> theEntries) {
        this.entries = theEntries;
    }

    private ImmutableAccessControlList(Collection<AclEntry> theEntries) {
        ConditionChecker.checkNotNull(theEntries, (String)"ACL entries");
        this.entries = new HashMap<AuthorizationSubject, AclEntry>();
        theEntries.forEach(e -> this.entries.put(e.getAuthorizationSubject(), (AclEntry)e));
    }

    public static AccessControlList empty() {
        return new ImmutableAccessControlList(Collections.emptySet());
    }

    public static AccessControlList of(AclEntry entry, AclEntry ... furtherEntries) {
        ConditionChecker.checkNotNull((Object)entry, (String)"mandatory ACL entry");
        ConditionChecker.checkNotNull((Object)furtherEntries, (String)"additional ACL entries");
        HashSet<AclEntry> theEntries = new HashSet<AclEntry>(1 + furtherEntries.length);
        theEntries.add(entry);
        Collections.addAll(theEntries, furtherEntries);
        return new ImmutableAccessControlList(theEntries);
    }

    public static AccessControlList of(Iterable<AclEntry> entries) {
        ConditionChecker.checkNotNull(entries, (String)"ACL entries");
        HashSet<AclEntry> theEntries = new HashSet<AclEntry>();
        entries.forEach(theEntries::add);
        return new ImmutableAccessControlList(theEntries);
    }

    public static AccessControlList fromJson(JsonObject jsonObject) {
        ConditionChecker.checkNotNull((Object)jsonObject, (String)"JSON object");
        HashSet<AclEntry> aclEntries = new HashSet<AclEntry>();
        for (JsonField jsonField : jsonObject) {
            JsonKey jsonKey = jsonField.getKey();
            if (jsonKey.equals(JsonSchemaVersion.getJsonKey())) continue;
            aclEntries.add(AccessControlListModelFactory.newAclEntry((CharSequence)jsonKey, jsonField.getValue()));
        }
        return new ImmutableAccessControlList(aclEntries);
    }

    @Override
    public AccessControlList merge(AclEntry entry) {
        ConditionChecker.checkNotNull((Object)entry, (String)"ACL entry to be added");
        AuthorizationSubject authSubject = entry.getAuthorizationSubject();
        Permissions permissions = this.getPermissionsOf(authSubject);
        permissions.addAll(entry.getPermissions());
        Map<AuthorizationSubject, AclEntry> entriesCopy = this.copyEntries();
        entriesCopy.put(authSubject, AccessControlListModelFactory.newAclEntry(authSubject, permissions));
        return new ImmutableAccessControlList(entriesCopy);
    }

    @Override
    public AccessControlList merge(AuthorizationSubject authorizationSubject, Permission permission, Permission ... furtherPermissions) {
        ConditionChecker.checkNotNull((Object)authorizationSubject, (String)"authorization subject to be added");
        ConditionChecker.checkNotNull((Object)((Object)permission), (String)"permission of the authorization subject to be added");
        ConditionChecker.checkNotNull((Object)furtherPermissions, (String)"additional permissions to be added");
        Permissions permissions = this.getPermissionsOf(authorizationSubject);
        permissions.add(permission);
        Collections.addAll(permissions, furtherPermissions);
        Map<AuthorizationSubject, AclEntry> entriesCopy = this.copyEntries();
        entriesCopy.put(authorizationSubject, AccessControlListModelFactory.newAclEntry(authorizationSubject, permissions));
        return new ImmutableAccessControlList(entriesCopy);
    }

    @Override
    public AccessControlList merge(Permission permission, AuthorizationSubject authorizationSubject, AuthorizationSubject ... furtherAuthorizationSubjects) {
        ConditionChecker.checkNotNull((Object)((Object)permission), (String)"permission to be added");
        ConditionChecker.checkNotNull((Object)authorizationSubject, (String)"authorization subject to be added");
        ConditionChecker.checkNotNull((Object)furtherAuthorizationSubjects, (String)"additional authorization subjects to be added");
        HashSet<AuthorizationSubject> allAuthSubjects = new HashSet<AuthorizationSubject>(1 + furtherAuthorizationSubjects.length);
        allAuthSubjects.add(authorizationSubject);
        Collections.addAll(allAuthSubjects, furtherAuthorizationSubjects);
        Map<AuthorizationSubject, AclEntry> entriesCopy = this.copyEntries();
        allAuthSubjects.forEach(authSubject -> {
            Permissions permissions = this.getPermissionsOf((AuthorizationSubject)authSubject);
            permissions.add(permission);
            entriesCopy.put((AuthorizationSubject)authSubject, AccessControlListModelFactory.newAclEntry(authSubject, permissions));
        });
        return new ImmutableAccessControlList(entriesCopy);
    }

    @Override
    public AccessControlList setEntry(AclEntry aclEntry) {
        ImmutableAccessControlList result;
        ConditionChecker.checkNotNull((Object)aclEntry, (String)"entry to be set to this ACL");
        AclEntry existingAclEntry = this.entries.get(aclEntry.getAuthorizationSubject());
        if (null != existingAclEntry) {
            if (existingAclEntry.equals(aclEntry)) {
                result = this;
            } else {
                Map<AuthorizationSubject, AclEntry> entriesCopy = this.copyEntries();
                entriesCopy.put(aclEntry.getAuthorizationSubject(), aclEntry);
                result = new ImmutableAccessControlList(entriesCopy);
            }
        } else {
            Map<AuthorizationSubject, AclEntry> entriesCopy = this.copyEntries();
            entriesCopy.put(aclEntry.getAuthorizationSubject(), aclEntry);
            result = new ImmutableAccessControlList(entriesCopy);
        }
        return result;
    }

    @Override
    public AccessControlList setForAllAuthorizationSubjects(Permissions permissions) {
        AccessControlList result;
        ConditionChecker.checkNotNull((Object)permissions, (String)"set with the permissions to set");
        if (this.entries.isEmpty()) {
            result = this;
        } else if (permissions.isEmpty()) {
            result = ImmutableAccessControlList.empty();
        } else {
            Set<AclEntry> newAclEntries = this.stream().map(AclEntry::getAuthorizationSubject).map(authSubject -> AccessControlListModelFactory.newAclEntry(authSubject, permissions)).collect(Collectors.toSet());
            result = ImmutableAccessControlList.of(newAclEntries);
        }
        return result;
    }

    @Override
    public Set<AuthorizationSubject> getAuthorizedSubjectsFor(Permission permission, Permission ... furtherPermissions) {
        ConditionChecker.checkNotNull((Object)((Object)permission), (String)"permission to get the Authorized Subjects for");
        ConditionChecker.checkNotNull((Object)furtherPermissions, (String)"further permissions to get the authorization subjects for");
        return this.getAuthorizedSubjectsFor(AccessControlListModelFactory.newPermissions(permission, furtherPermissions));
    }

    @Override
    public boolean hasPermission(AuthorizationContext authorizationContext, Permission permission, Permission ... furtherPermissions) {
        ConditionChecker.checkNotNull((Object)authorizationContext, (String)"authorization context in which to check for the permissions");
        ConditionChecker.checkNotNull((Object)((Object)permission), (String)"permission to check for in the authorization context");
        ConditionChecker.checkNotNull((Object)furtherPermissions, (String)"further permissions to check for in the authorization context");
        Set<AuthorizationSubject> authSubjectsHavingPermissions = this.getAuthorizedSubjectsFor(permission, furtherPermissions);
        return authorizationContext.getAuthorizationSubjects().stream().anyMatch(authSubjectsHavingPermissions::contains);
    }

    @Override
    public boolean hasPermission(AuthorizationSubject authorizationSubject, Permission permission, Permission ... furtherPermissions) {
        ConditionChecker.checkNotNull((Object)authorizationSubject, (String)"authorization subject of which the permissions are checked");
        ConditionChecker.checkNotNull((Object)((Object)permission), (String)"permission to check for in the authorization subject");
        ConditionChecker.checkNotNull((Object)furtherPermissions, (String)"further permissions to check for in the authorization subject");
        return this.getPermissionsOf(authorizationSubject).contains(permission, furtherPermissions);
    }

    @Override
    public Set<AuthorizationSubject> getAuthorizedSubjectsFor(Permissions expectedPermissions) {
        ConditionChecker.checkNotNull((Object)expectedPermissions, (String)"expected permissions");
        return this.stream().filter(aclEntry -> aclEntry.containsAll(expectedPermissions)).map(AclEntry::getAuthorizationSubject).collect(Collectors.toSet());
    }

    @Override
    public boolean contains(AuthorizationSubject authorizationSubject) {
        return this.entries.containsKey(authorizationSubject);
    }

    @Override
    public Optional<AclEntry> getEntryFor(AuthorizationSubject authorizationSubject) {
        ConditionChecker.checkNotNull((Object)authorizationSubject, (String)"authorization subject to get as ACL entry");
        return Optional.ofNullable(this.entries.get(authorizationSubject));
    }

    @Override
    public Permissions getPermissionsOf(AuthorizationSubject authorizationSubject) {
        ConditionChecker.checkNotNull((Object)authorizationSubject, (String)"authorization subject to get the permissions for");
        return this.getEntryFor(authorizationSubject).map(AclEntry::getPermissions).orElseGet(AccessControlListModelFactory::noPermissions);
    }

    @Override
    public AccessControlList removeEntry(AclEntry entry) {
        ConditionChecker.checkNotNull((Object)entry, (String)"ACL entry to be removed");
        if (!this.entries.containsKey(entry.getAuthorizationSubject())) {
            return this;
        }
        Map<AuthorizationSubject, AclEntry> entriesCopy = this.copyEntries();
        entriesCopy.remove(entry.getAuthorizationSubject());
        return new ImmutableAccessControlList(entriesCopy);
    }

    @Override
    public AccessControlList removePermission(AuthorizationSubject authorizationSubject, Permission permission, Permission ... furtherPermissions) {
        ConditionChecker.checkNotNull((Object)authorizationSubject, (String)"authorization subject");
        ConditionChecker.checkNotNull((Object)((Object)permission), (String)"permission");
        ConditionChecker.checkNotNull((Object)furtherPermissions, (String)"further permissions");
        AclEntry existingEntry = this.entries.get(authorizationSubject);
        if (null != existingEntry) {
            Permissions permissions = existingEntry.getPermissions();
            permissions.remove((Object)permission);
            Stream.of(furtherPermissions).forEach(permissions::remove);
            Map<AuthorizationSubject, AclEntry> entriesCopy = this.copyEntries();
            if (permissions.isEmpty()) {
                entriesCopy.remove(authorizationSubject);
            } else {
                entriesCopy.put(authorizationSubject, AccessControlListModelFactory.newAclEntry(authorizationSubject, permissions));
            }
            return new ImmutableAccessControlList(entriesCopy);
        }
        return this;
    }

    @Override
    public AccessControlList removeAllPermissionsOf(AuthorizationSubject authorizationSubject) {
        ConditionChecker.checkNotNull((Object)authorizationSubject, (String)"authorization subject to remove all permissions of");
        if (!this.entries.containsKey(authorizationSubject)) {
            return this;
        }
        Map<AuthorizationSubject, AclEntry> entriesCopy = this.copyEntries();
        entriesCopy.remove(authorizationSubject);
        return new ImmutableAccessControlList(entriesCopy.values());
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.getSize();
    }

    @Override
    public int getSize() {
        return this.entries.size();
    }

    @Override
    public Set<AclEntry> getEntriesSet() {
        return this.stream().collect(Collectors.toSet());
    }

    @Override
    public Stream<AclEntry> stream() {
        return this.entries.values().stream();
    }

    @Override
    public Iterator<AclEntry> iterator() {
        Set<AclEntry> aclEntries = this.getEntriesSet();
        return aclEntries.iterator();
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        return JsonFactory.newObjectBuilder().set(JSON_SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate).setAll((Iterable)this.stream().map(aclEntry -> (JsonObject)aclEntry.toJson(schemaVersion, thePredicate)).collect(JsonCollectors.objectsToObject()), predicate).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAccessControlList that = (ImmutableAccessControlList)o;
        return Objects.equals(this.entries, that.entries);
    }

    public int hashCode() {
        return Objects.hash(this.entries);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [entries=" + this.entries + "]";
    }

    private Map<AuthorizationSubject, AclEntry> copyEntries() {
        return new HashMap<AuthorizationSubject, AclEntry>(this.entries);
    }
}

