/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.auth.AuthorizationModelFactory;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.exceptions.DittoJsonException;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.things.AccessControlListModelFactory;
import org.eclipse.ditto.model.things.AclEntry;
import org.eclipse.ditto.model.things.AclEntryInvalidException;
import org.eclipse.ditto.model.things.Permission;
import org.eclipse.ditto.model.things.Permissions;

@Deprecated
@Immutable
final class ImmutableAclEntry
implements AclEntry {
    private static final JsonFieldDefinition<Integer> JSON_SCHEMA_VERSION = JsonFactory.newIntFieldDefinition((CharSequence)JsonSchemaVersion.getJsonKey(), (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1});
    private final AuthorizationSubject authSubject;
    private final Permissions permissions;

    private ImmutableAclEntry(AuthorizationSubject theAuthSubject, Set<Permission> thePermissions) {
        this.authSubject = (AuthorizationSubject)ConditionChecker.checkNotNull((Object)theAuthSubject, (String)"authorization subject");
        ConditionChecker.checkNotNull(thePermissions, (String)"permissions");
        this.permissions = thePermissions.isEmpty() ? AccessControlListModelFactory.noPermissions() : AccessControlListModelFactory.newPermissions(thePermissions);
    }

    public static AclEntry of(AuthorizationSubject authSubject, Permission permission, Permission ... furtherPermissions) {
        ConditionChecker.checkNotNull((Object)((Object)permission), (String)"permission of this entry");
        ConditionChecker.checkNotNull((Object)furtherPermissions, (String)"further permissions of this entry");
        EnumSet<Permission> permissions = EnumSet.of(permission);
        Collections.addAll(permissions, furtherPermissions);
        return ImmutableAclEntry.of(authSubject, permissions);
    }

    public static AclEntry of(AuthorizationSubject authSubject, Iterable<Permission> permissions) {
        if (permissions instanceof Set) {
            return new ImmutableAclEntry(authSubject, (Set)permissions);
        }
        EnumSet<Permission> permissionSet = EnumSet.noneOf(Permission.class);
        permissions.forEach(permissionSet::add);
        return new ImmutableAclEntry(authSubject, permissionSet);
    }

    public static AclEntry of(CharSequence jsonKey, JsonValue jsonValue) {
        ImmutableAclEntry.validate(jsonKey, jsonValue);
        JsonObject permissionsJsonObject = jsonValue.asObject();
        AuthorizationSubject authorizationSubject = AuthorizationModelFactory.newAuthSubject((CharSequence)jsonKey);
        EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
        for (Permission permission : Permission.values()) {
            Optional permissionValue = permissionsJsonObject.getValue((CharSequence)permission.toJsonKey());
            ImmutableAclEntry.validate(jsonKey, permission, permissionValue);
            if (!permissionValue.map(JsonValue::asBoolean).orElse(false).booleanValue()) continue;
            permissions.add(permission);
        }
        AclEntry result = ImmutableAclEntry.of(authorizationSubject, permissions);
        ImmutableAclEntry.validate(result);
        return result;
    }

    private static void validate(CharSequence jsonKey, JsonValue jsonValue) {
        ConditionChecker.checkNotNull((Object)jsonKey, (String)"JSON key");
        ConditionChecker.checkNotNull((Object)jsonValue, (String)"JSON value");
        String msgTemplate = "Expected for Authorization Subject ''{0}'' a JSON object containing all of {1} but got <{2}>!";
        Supplier<String> descriptionSupplier = () -> MessageFormat.format("Expected for Authorization Subject ''{0}'' a JSON object containing all of {1} but got <{2}>!", jsonKey, Permission.allToString(), jsonValue);
        if (!jsonValue.isObject()) {
            throw new DittoJsonException((RuntimeException)JsonParseException.newBuilder().description(descriptionSupplier).build());
        }
        JsonObject permissionsJsonObject = jsonValue.asObject();
        if (permissionsJsonObject.isEmpty()) {
            throw (AclEntryInvalidException)AclEntryInvalidException.newBuilder().description(descriptionSupplier).build();
        }
    }

    private static void validate(CharSequence authSubjectId, Permission permission, Optional<JsonValue> permissionValue) {
        if (permissionValue.isPresent()) {
            JsonValue permissionJsonValue = permissionValue.get();
            if (!permissionJsonValue.isBoolean()) {
                String descTemplate = "Expected for permission ''{0}'' of Authorization Subject ''{1}'' the value <true> or <false> but got <{2}>!";
                throw (AclEntryInvalidException)AclEntryInvalidException.newBuilder().message(MessageFormat.format("Expected for permission ''{0}'' of Authorization Subject ''{1}'' the value <true> or <false> but got <{2}>!", new Object[]{permission, authSubjectId, permissionValue.get()})).build();
            }
        } else {
            String descTemplate = "Expected for Authorization Subject ''{0}'' the permission ''{1}'' with value <true> or <false> but the permission is absent at all!";
            throw (AclEntryInvalidException)AclEntryInvalidException.newBuilder().message(MessageFormat.format("Expected for Authorization Subject ''{0}'' the permission ''{1}'' with value <true> or <false> but the permission is absent at all!", new Object[]{authSubjectId, permission})).build();
        }
    }

    private static void validate(AclEntry aclEntry) {
        Permissions entryPermissions = aclEntry.getPermissions();
        if (entryPermissions.isEmpty()) {
            String descTemplate = "The ACL entry for ''{0}'' did not contain any permission of {1} which evaluates to <true>!";
            AuthorizationSubject authorizationSubject = aclEntry.getAuthorizationSubject();
            String allPermissions = Permission.allToString();
            throw (AclEntryInvalidException)AclEntryInvalidException.newBuilder().message(MessageFormat.format("The ACL entry for ''{0}'' did not contain any permission of {1} which evaluates to <true>!", authorizationSubject.getId(), allPermissions)).build();
        }
    }

    public static AclEntry fromJson(JsonObject jsonObject) {
        ConditionChecker.checkNotNull((Object)jsonObject, (String)"JSON object");
        return jsonObject.stream().filter(field -> !Objects.equals(field.getKey(), JsonSchemaVersion.getJsonKey())).findFirst().map(field -> ImmutableAclEntry.of((CharSequence)field.getKey(), field.getValue())).orElseThrow(() -> new DittoJsonException((RuntimeException)JsonMissingFieldException.newBuilder().message("The JSON object for 'aclEntry' is missing.").build()));
    }

    @Override
    public AuthorizationSubject getAuthorizationSubject() {
        return this.authSubject;
    }

    @Override
    public boolean contains(Permission permission) {
        return this.permissions.contains((Object)permission);
    }

    @Override
    public boolean containsAll(@Nullable Collection<Permission> permissions) {
        return null != permissions && this.permissions.containsAll(permissions);
    }

    @Override
    public Permissions getPermissions() {
        return AccessControlListModelFactory.newPermissions(this.permissions);
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        return JsonFactory.newObjectBuilder().set(JSON_SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate).set((CharSequence)this.authSubject.getId(), this.permissions.toJson((Predicate)schemaVersion)).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAclEntry aclEntry = (ImmutableAclEntry)o;
        return Objects.equals(this.authSubject, aclEntry.authSubject) && Objects.equals(this.permissions, aclEntry.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.authSubject, this.permissions);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [authSubject=" + this.authSubject + ", permissions=" + this.permissions + "]";
    }
}

