/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.things.DefinitionIdentifier;
import org.eclipse.ditto.model.things.DefinitionIdentifierInvalidException;

@Immutable
final class ImmutableDefinitionIdentifier
implements DefinitionIdentifier {
    private static final Pattern IDENTIFIER_PATTERN = DefinitionIdentifierPatternBuilder.getInstance().addCapturingGroup("NAMESPACE").addCapturingGroup("NAME").addCapturingGroup("VERSION").build();
    private static final String COLON = ":";
    private final String namespace;
    private final String name;
    private final String version;
    private final String stringRepresentation;

    private ImmutableDefinitionIdentifier(CharSequence theNamespace, CharSequence theName, CharSequence theVersion) {
        this.namespace = ConditionChecker.argumentNotEmpty((CharSequence)theNamespace, (String)"namespace").toString();
        this.name = ConditionChecker.argumentNotEmpty((CharSequence)theName, (String)"name").toString();
        this.version = ConditionChecker.argumentNotEmpty((CharSequence)theVersion, (String)"version").toString();
        this.stringRepresentation = this.namespace + COLON + this.name + COLON + this.version;
    }

    static DefinitionIdentifier getInstance(CharSequence namespace, CharSequence name, CharSequence version) {
        return new ImmutableDefinitionIdentifier(namespace, name, version);
    }

    static DefinitionIdentifier ofParsed(CharSequence definitionIdentifier) {
        ConditionChecker.checkNotNull((Object)definitionIdentifier, (String)"CharSequence-representation of the identifier");
        if (definitionIdentifier instanceof DefinitionIdentifier) {
            return (DefinitionIdentifier)definitionIdentifier;
        }
        Matcher matcher = IDENTIFIER_PATTERN.matcher(definitionIdentifier);
        if (!matcher.matches()) {
            throw new DefinitionIdentifierInvalidException(definitionIdentifier);
        }
        String parsedNamespace = matcher.group("NAMESPACE");
        String parsedName = matcher.group("NAME");
        String parsedVersion = matcher.group("VERSION");
        return ImmutableDefinitionIdentifier.getInstance(parsedNamespace, parsedName, parsedVersion);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableDefinitionIdentifier that = (ImmutableDefinitionIdentifier)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.name, this.version);
    }

    @Override
    public int length() {
        return this.stringRepresentation.length();
    }

    @Override
    public char charAt(int index) {
        return this.stringRepresentation.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.stringRepresentation.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.stringRepresentation;
    }

    @NotThreadSafe
    private static final class DefinitionIdentifierPatternBuilder {
        private static final Pattern ELEMENT_PATTERN = Pattern.compile("[_a-zA-Z0-9\\-.]+");
        private final StringBuilder stringBuilder = new StringBuilder();

        private DefinitionIdentifierPatternBuilder() {
        }

        public static DefinitionIdentifierPatternBuilder getInstance() {
            return new DefinitionIdentifierPatternBuilder();
        }

        public DefinitionIdentifierPatternBuilder addCapturingGroup(CharSequence elementCapturingGroupName) {
            if (0 < this.stringBuilder.length()) {
                this.stringBuilder.append(ImmutableDefinitionIdentifier.COLON);
            }
            this.stringBuilder.append("(?<").append(elementCapturingGroupName).append(">");
            this.stringBuilder.append(ELEMENT_PATTERN).append(")");
            return this;
        }

        public Pattern build() {
            return Pattern.compile(this.stringBuilder.toString());
        }
    }

    @Immutable
    private static final class CapturingGroup {
        public static final String NAMESPACE = "NAMESPACE";
        public static final String NAME = "NAME";
        public static final String VERSION = "VERSION";

        private CapturingGroup() {
            throw new AssertionError();
        }
    }
}

