/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.things.DefinitionIdentifier;
import org.eclipse.ditto.model.things.FeatureDefinition;
import org.eclipse.ditto.model.things.FeatureDefinitionBuilder;
import org.eclipse.ditto.model.things.FeatureDefinitionEmptyException;
import org.eclipse.ditto.model.things.ImmutableFeatureDefinitionIdentifier;
import org.eclipse.ditto.model.things.ThingsModelFactory;

@Immutable
final class ImmutableFeatureDefinition
implements FeatureDefinition {
    private final List<DefinitionIdentifier> identifierList;

    private ImmutableFeatureDefinition(Collection<DefinitionIdentifier> identifiers) {
        this.identifierList = Collections.unmodifiableList(new ArrayList<DefinitionIdentifier>(identifiers));
    }

    public static ImmutableFeatureDefinition fromJson(JsonArray featureDefinitionEntriesAsJsonArray) {
        ConditionChecker.checkNotNull((Object)featureDefinitionEntriesAsJsonArray, (String)"JSON array containing the FeatureDefinition entries");
        if (featureDefinitionEntriesAsJsonArray.isEmpty()) {
            throw new FeatureDefinitionEmptyException();
        }
        List<DefinitionIdentifier> identifiersFromJson = featureDefinitionEntriesAsJsonArray.stream().filter(JsonValue::isString).map(JsonValue::asString).map(ImmutableFeatureDefinitionIdentifier::ofParsed).collect(Collectors.toList());
        return new ImmutableFeatureDefinition(identifiersFromJson);
    }

    public static Builder getBuilder(DefinitionIdentifier firstIdentifier) {
        return Builder.getInstance().add((CharSequence)ConditionChecker.checkNotNull((Object)firstIdentifier, (String)"first identifier"));
    }

    @Override
    public DefinitionIdentifier getFirstIdentifier() {
        return this.identifierList.get(0);
    }

    @Override
    public int getSize() {
        return this.identifierList.size();
    }

    @Override
    public Stream<DefinitionIdentifier> stream() {
        return this.identifierList.stream();
    }

    @Override
    public Iterator<DefinitionIdentifier> iterator() {
        return this.identifierList.iterator();
    }

    public JsonArray toJson() {
        return (JsonArray)this.identifierList.stream().map(DefinitionIdentifier::toString).map(JsonFactory::newValue).collect(JsonCollectors.valuesToArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableFeatureDefinition that = (ImmutableFeatureDefinition)o;
        return Objects.equals(this.identifierList, that.identifierList);
    }

    public int hashCode() {
        return Objects.hash(this.identifierList);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [identifierList=" + this.identifierList + "]";
    }

    public static final class Builder
    implements FeatureDefinitionBuilder {
        private final Set<DefinitionIdentifier> identifiers = new LinkedHashSet<DefinitionIdentifier>();

        private Builder() {
        }

        static Builder getInstance() {
            return new Builder();
        }

        @Override
        public Builder add(CharSequence identifier) {
            this.identifiers.add(Builder.castOrParse((CharSequence)ConditionChecker.checkNotNull((Object)identifier, (String)"Identifier to be added")));
            return this;
        }

        private static DefinitionIdentifier castOrParse(CharSequence identifierAsCharSequence) {
            return ThingsModelFactory.newFeatureDefinitionIdentifier(identifierAsCharSequence);
        }

        @Override
        public <T extends CharSequence> Builder addAll(Iterable<T> identifiers) {
            ((Iterable)ConditionChecker.checkNotNull(identifiers, (String)"Identifiers to be added")).forEach(this::add);
            return this;
        }

        @Override
        public Builder remove(CharSequence identifier) {
            this.identifiers.remove(Builder.castOrParse((CharSequence)ConditionChecker.checkNotNull((Object)identifier, (String)"Identifier to be removed")));
            return this;
        }

        @Override
        public <T extends CharSequence> Builder removeAll(Iterable<T> identifiers) {
            ((Iterable)ConditionChecker.checkNotNull(identifiers, (String)"Identifiers to be removed")).forEach(this::remove);
            return this;
        }

        @Override
        public DefinitionIdentifier getFirstIdentifier() {
            return this.iterator().next();
        }

        @Override
        public int getSize() {
            return this.identifiers.size();
        }

        @Override
        public Stream<DefinitionIdentifier> stream() {
            return this.identifiers.stream();
        }

        @Override
        public Iterator<DefinitionIdentifier> iterator() {
            return this.identifiers.iterator();
        }

        @Override
        public ImmutableFeatureDefinition build() {
            if (this.identifiers.isEmpty()) {
                throw new IndexOutOfBoundsException("This builder does not contain at least one Identifier!");
            }
            return new ImmutableFeatureDefinition(this.identifiers);
        }
    }
}

