/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.things.DefinitionIdentifier;
import org.eclipse.ditto.model.things.ImmutableDefinitionIdentifier;

@Immutable
final class ImmutableFeatureDefinitionIdentifier
implements DefinitionIdentifier {
    private final DefinitionIdentifier delegate;

    private ImmutableFeatureDefinitionIdentifier(DefinitionIdentifier delegate) {
        this.delegate = delegate;
    }

    private ImmutableFeatureDefinitionIdentifier(CharSequence theNamespace, CharSequence theName, CharSequence theVersion) {
        this(ImmutableDefinitionIdentifier.getInstance(theNamespace, theName, theVersion));
    }

    public static ImmutableFeatureDefinitionIdentifier getInstance(CharSequence namespace, CharSequence name, CharSequence version) {
        return new ImmutableFeatureDefinitionIdentifier(namespace, name, version);
    }

    public static ImmutableFeatureDefinitionIdentifier ofParsed(CharSequence featureDefinitionIdentifier) {
        ConditionChecker.checkNotNull((Object)featureDefinitionIdentifier, (String)"CharSequence-representation of the identifier");
        if (featureDefinitionIdentifier instanceof ImmutableFeatureDefinitionIdentifier) {
            return (ImmutableFeatureDefinitionIdentifier)featureDefinitionIdentifier;
        }
        return new ImmutableFeatureDefinitionIdentifier(ImmutableDefinitionIdentifier.ofParsed(featureDefinitionIdentifier));
    }

    @Override
    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getVersion() {
        return this.delegate.getVersion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableFeatureDefinitionIdentifier that = (ImmutableFeatureDefinitionIdentifier)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    @Override
    public int length() {
        return this.delegate.length();
    }

    @Override
    public char charAt(int index) {
        return this.delegate.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.delegate.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

