/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.things.Feature;
import org.eclipse.ditto.model.things.FeatureBuilder;
import org.eclipse.ditto.model.things.FeatureDefinition;
import org.eclipse.ditto.model.things.FeatureProperties;
import org.eclipse.ditto.model.things.ImmutableFeature;
import org.eclipse.ditto.model.things.ThingsModelFactory;

@NotThreadSafe
final class ImmutableFeatureFromCopyBuilder
implements FeatureBuilder,
FeatureBuilder.FromCopyBuildable {
    private String featureId;
    @Nullable
    private FeatureDefinition definition;
    @Nullable
    private FeatureProperties properties;
    @Nullable
    private FeatureProperties desiredProperties;

    private ImmutableFeatureFromCopyBuilder(String theFeatureId) {
        this.featureId = theFeatureId;
        this.properties = null;
        this.desiredProperties = null;
        this.definition = null;
    }

    public static ImmutableFeatureFromCopyBuilder of(Feature feature) {
        ConditionChecker.checkNotNull((Object)feature, (String)"Feature");
        ImmutableFeatureFromCopyBuilder result = new ImmutableFeatureFromCopyBuilder(feature.getId());
        result.properties((FeatureProperties)feature.getProperties().orElse(null));
        result.desiredProperties((FeatureProperties)feature.getDesiredProperties().orElse(null));
        result.definition(feature.getDefinition().orElse(null));
        return result;
    }

    @Override
    public FeatureBuilder.FromCopyBuildable definition(@Nullable FeatureDefinition featureDefinition) {
        this.definition = featureDefinition;
        return this;
    }

    @Override
    public FeatureBuilder.FromCopyBuildable properties(@Nullable FeatureProperties properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public FeatureBuilder.FromCopyBuildable properties(@Nullable JsonObject properties) {
        this.properties = null == properties ? null : (properties instanceof FeatureProperties ? (FeatureProperties)properties : ThingsModelFactory.newFeatureProperties(properties));
        return this;
    }

    @Override
    public FeatureBuilder.FromCopyBuildable properties(Function<FeatureProperties, FeatureProperties> transform) {
        ConditionChecker.checkNotNull(transform, (String)"transform function");
        this.properties = transform.apply(this.properties == null ? ThingsModelFactory.emptyFeatureProperties() : this.properties);
        return this;
    }

    @Override
    public FeatureBuilder.FromCopyBuildable desiredProperties(@Nullable FeatureProperties desiredProperties) {
        this.desiredProperties = desiredProperties;
        return this;
    }

    @Override
    public FeatureBuilder.FromCopyBuildable desiredProperties(@Nullable JsonObject desiredProperties) {
        this.desiredProperties = null == desiredProperties ? null : (desiredProperties instanceof FeatureProperties ? (FeatureProperties)desiredProperties : ThingsModelFactory.newFeatureProperties(desiredProperties));
        return this;
    }

    @Override
    public FeatureBuilder.FromCopyBuildable desiredProperties(UnaryOperator<FeatureProperties> transform) {
        ConditionChecker.checkNotNull(transform, (String)"transform function");
        this.desiredProperties = (FeatureProperties)transform.apply(this.desiredProperties == null ? ThingsModelFactory.emptyFeatureProperties() : this.desiredProperties);
        return this;
    }

    @Override
    public FeatureBuilder.FromCopyBuildable setId(String featureId) {
        this.featureId = (String)ConditionChecker.argumentNotEmpty((CharSequence)featureId, (String)"Feature ID to be set");
        return this;
    }

    @Override
    public FeatureBuilder.FromCopyBuildable setId(Predicate<String> existingIdPredicate, String featureId) {
        if (existingIdPredicate.test(this.featureId)) {
            this.setId(featureId);
        }
        return this;
    }

    @Override
    public Feature build() {
        return ImmutableFeature.of(this.featureId, this.definition, this.properties, this.desiredProperties);
    }
}

