/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.id.NamespacedEntityIdWithType;
import org.eclipse.ditto.model.base.entity.metadata.Metadata;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PolicyId;
import org.eclipse.ditto.model.things.AccessControlList;
import org.eclipse.ditto.model.things.AclEntry;
import org.eclipse.ditto.model.things.AclInvalidException;
import org.eclipse.ditto.model.things.Attributes;
import org.eclipse.ditto.model.things.Feature;
import org.eclipse.ditto.model.things.FeatureDefinition;
import org.eclipse.ditto.model.things.FeatureProperties;
import org.eclipse.ditto.model.things.Features;
import org.eclipse.ditto.model.things.ImmutableThingDefinition;
import org.eclipse.ditto.model.things.NullThingDefinition;
import org.eclipse.ditto.model.things.Thing;
import org.eclipse.ditto.model.things.ThingDefinition;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.model.things.ThingLifecycle;
import org.eclipse.ditto.model.things.ThingRevision;
import org.eclipse.ditto.model.things.ThingsModelFactory;

@Immutable
final class ImmutableThing
implements Thing {
    @Nullable
    private final ThingId thingId;
    @Nullable
    @Deprecated
    private final AccessControlList acl;
    @Nullable
    private final PolicyId policyId;
    @Nullable
    private final ThingDefinition definition;
    @Nullable
    private final Attributes attributes;
    @Nullable
    private final Features features;
    @Nullable
    private final ThingLifecycle lifecycle;
    @Nullable
    private final ThingRevision revision;
    @Nullable
    private final Instant modified;
    @Nullable
    private final Instant created;
    @Nullable
    private final Metadata metadata;

    private ImmutableThing(@Nullable ThingId thingId, @Nullable AccessControlList acl, @Nullable PolicyId policyId, @Nullable ThingDefinition definition, @Nullable Attributes attributes, @Nullable Features features, @Nullable ThingLifecycle lifecycle, @Nullable ThingRevision revision, @Nullable Instant modified, @Nullable Instant created, @Nullable Metadata metadata) {
        this.thingId = thingId;
        this.acl = acl;
        this.policyId = policyId;
        this.definition = definition;
        this.attributes = attributes;
        this.features = features;
        this.lifecycle = lifecycle;
        this.revision = revision;
        this.modified = modified;
        this.created = created;
        this.metadata = metadata;
    }

    @Deprecated
    static Thing of(@Nullable String thingId, @Nullable AccessControlList accessControlList, @Nullable Attributes attributes, @Nullable Features features, @Nullable ThingLifecycle lifecycle, @Nullable ThingRevision revision, @Nullable Instant modified, @Nullable Instant created, @Nullable Metadata metadata) {
        return ImmutableThing.of(ThingId.of(thingId), accessControlList, attributes, features, lifecycle, revision, modified, created, metadata);
    }

    @Deprecated
    static Thing of(@Nullable ThingId thingId, @Nullable AccessControlList accessControlList, @Nullable Attributes attributes, @Nullable Features features, @Nullable ThingLifecycle lifecycle, @Nullable ThingRevision revision, @Nullable Instant modified, @Nullable Instant created, @Nullable Metadata metadata) {
        return new ImmutableThing(thingId, accessControlList, null, null, attributes, features, lifecycle, revision, modified, created, metadata);
    }

    static Thing of(@Nullable ThingId thingId, @Nullable AccessControlList accessControlList, @Nullable PolicyId policyId, @Nullable ThingDefinition definition, @Nullable Attributes attributes, @Nullable Features features, @Nullable ThingLifecycle lifecycle, @Nullable ThingRevision revision, @Nullable Instant modified, @Nullable Instant created, @Nullable Metadata metadata) {
        return new ImmutableThing(thingId, accessControlList, policyId, definition, attributes, features, lifecycle, revision, modified, created, metadata);
    }

    static Thing of(@Nullable ThingId thingId, @Nullable PolicyId policyId, @Nullable ThingDefinition definition, @Nullable Attributes attributes, @Nullable Features features, @Nullable ThingLifecycle lifecycle, @Nullable ThingRevision revision, @Nullable Instant modified, @Nullable Instant created, @Nullable Metadata metadata) {
        return new ImmutableThing(thingId, null, policyId, definition, attributes, features, lifecycle, revision, modified, created, metadata);
    }

    public Optional<ThingRevision> getRevision() {
        return Optional.ofNullable(this.revision);
    }

    public Optional<Instant> getModified() {
        return Optional.ofNullable(this.modified);
    }

    public Optional<Instant> getCreated() {
        return Optional.ofNullable(this.created);
    }

    public boolean isDeleted() {
        return ThingLifecycle.DELETED.equals((Object)this.lifecycle);
    }

    @Override
    public Optional<ThingId> getEntityId() {
        return Optional.ofNullable(this.thingId);
    }

    @Override
    public Optional<String> getNamespace() {
        return Optional.ofNullable(this.thingId).map(NamespacedEntityIdWithType::getNamespace);
    }

    @Override
    public Optional<Attributes> getAttributes() {
        return Optional.ofNullable(this.attributes);
    }

    @Override
    public Thing setAttributes(@Nullable Attributes attributes) {
        if (Objects.equals(this.attributes, attributes)) {
            return this;
        }
        return new ImmutableThing(this.thingId, this.acl, this.policyId, this.definition, attributes, this.features, this.lifecycle, this.revision, this.modified, this.created, this.metadata);
    }

    @Override
    public Thing removeAttributes() {
        if (null == this.attributes) {
            return this;
        }
        return this.setAttributes(null);
    }

    @Override
    public Thing setAttribute(JsonPointer attributePath, JsonValue attributeValue) {
        Attributes newAttributes = null == this.attributes || this.attributes.isNull() ? ThingsModelFactory.newAttributesBuilder().set((CharSequence)attributePath, attributeValue).build() : this.attributes.setValue((CharSequence)attributePath, attributeValue);
        return this.setAttributes(newAttributes);
    }

    @Override
    public Thing removeAttribute(JsonPointer attributePath) {
        if (null == this.attributes || this.attributes.isEmpty() || this.attributes.isNull()) {
            return this;
        }
        return this.setAttributes(this.attributes.remove((CharSequence)attributePath));
    }

    @Override
    public Optional<ThingDefinition> getDefinition() {
        return Optional.ofNullable(this.definition);
    }

    @Override
    public Thing setDefinition(@Nullable CharSequence definitionIdentifier) {
        if (null != definitionIdentifier) {
            return new ImmutableThing(this.thingId, this.acl, this.policyId, ImmutableThingDefinition.ofParsed(definitionIdentifier), this.attributes, this.features, this.lifecycle, this.revision, this.modified, this.created, this.metadata);
        }
        return new ImmutableThing(this.thingId, this.acl, this.policyId, NullThingDefinition.getInstance(), this.attributes, this.features, this.lifecycle, this.revision, this.modified, this.created, this.metadata);
    }

    @Override
    public Thing removeDefinition() {
        if (null == this.definition) {
            return this;
        }
        return new ImmutableThing(this.thingId, this.acl, this.policyId, null, this.attributes, this.features, this.lifecycle, this.revision, this.modified, this.created, this.metadata);
    }

    @Override
    public Optional<Features> getFeatures() {
        return Optional.ofNullable(this.features);
    }

    @Override
    public Thing removeFeatures() {
        if (null == this.features) {
            return this;
        }
        return this.setFeatures(null);
    }

    @Override
    public Thing setFeatures(@Nullable Features features) {
        if (Objects.equals(this.features, features)) {
            return this;
        }
        return new ImmutableThing(this.thingId, this.acl, this.policyId, this.definition, this.attributes, features, this.lifecycle, this.revision, this.modified, this.created, this.metadata);
    }

    @Override
    public Thing setFeature(Feature feature) {
        Features newFeatures = null == this.features || this.features.isNull() ? ThingsModelFactory.newFeaturesBuilder().set(feature).build() : this.features.setFeature(feature);
        return this.setFeatures(newFeatures);
    }

    @Override
    public Thing removeFeature(String featureId) {
        return null != this.features ? this.setFeatures(this.features.removeFeature(featureId)) : this;
    }

    @Override
    public Thing setFeatureDefinition(String featureId, FeatureDefinition definition) {
        if (null == this.features || this.features.isNull()) {
            return this.setFeature(ThingsModelFactory.newFeature(featureId, definition, null));
        }
        return this.setFeatures(this.features.setDefinition(featureId, definition));
    }

    @Override
    public Thing removeFeatureDefinition(String featureId) {
        return null != this.features ? this.setFeatures(this.features.removeDefinition(featureId)) : this;
    }

    @Override
    public Thing setFeatureProperties(String featureId, FeatureProperties properties) {
        if (null == this.features || this.features.isNull()) {
            return this.setFeature(ThingsModelFactory.newFeature(featureId, properties));
        }
        return this.setFeatures(this.features.setProperties(featureId, properties));
    }

    @Override
    public Thing removeFeatureProperties(String featureId) {
        return null != this.features ? this.setFeatures(this.features.removeProperties(featureId)) : this;
    }

    @Override
    public Thing setFeatureProperty(String featureId, JsonPointer propertyJsonPointer, JsonValue propertyValue) {
        Features newFeatures;
        if (null == this.features || this.features.isNull()) {
            FeatureProperties featureProperties = ThingsModelFactory.newFeaturePropertiesBuilder().set((CharSequence)propertyJsonPointer, propertyValue).build();
            newFeatures = ThingsModelFactory.newFeatures(ThingsModelFactory.newFeature(featureId, featureProperties), new Feature[0]);
        } else {
            newFeatures = this.features.setProperty(featureId, propertyJsonPointer, propertyValue);
        }
        return this.setFeatures(newFeatures);
    }

    @Override
    public Thing removeFeatureProperty(String featureId, JsonPointer propertyPath) {
        return null != this.features ? this.setFeatures(this.features.removeProperty(featureId, propertyPath)) : this;
    }

    @Override
    public Thing setFeatureDesiredProperties(CharSequence featureId, FeatureProperties desiredProperties) {
        if (null == this.features || this.features.isNull()) {
            return this.setFeature(ThingsModelFactory.newFeature(featureId, null, null, desiredProperties));
        }
        return this.setFeatures(this.features.setDesiredProperties(featureId, desiredProperties));
    }

    @Override
    public Thing removeFeatureDesiredProperties(CharSequence featureId) {
        return null != this.features ? this.setFeatures(this.features.removeDesiredProperties(featureId)) : this;
    }

    @Override
    public Thing setFeatureDesiredProperty(CharSequence featureId, JsonPointer desiredPropertyPath, JsonValue desiredPropertyValue) {
        Features newFeatures;
        if (null == this.features || this.features.isNull()) {
            FeatureProperties desiredProperties = ThingsModelFactory.newFeaturePropertiesBuilder().set((CharSequence)desiredPropertyPath, desiredPropertyValue).build();
            newFeatures = ThingsModelFactory.newFeatures(ThingsModelFactory.newFeature(featureId, null, null, desiredProperties), new Feature[0]);
        } else {
            newFeatures = this.features.setDesiredProperty(featureId, desiredPropertyPath, desiredPropertyValue);
        }
        return this.setFeatures(newFeatures);
    }

    @Override
    public Thing removeFeatureDesiredProperty(CharSequence featureId, JsonPointer desiredPropertyPath) {
        return null != this.features ? this.setFeatures(this.features.removeDesiredProperty(featureId, desiredPropertyPath)) : this;
    }

    @Override
    @Deprecated
    public Optional<AccessControlList> getAccessControlList() {
        return Optional.ofNullable(this.acl);
    }

    @Override
    @Deprecated
    public Thing setAccessControlList(AccessControlList accessControlList) {
        if (this.policyId != null) {
            throw (AclInvalidException)AclInvalidException.newBuilder(this.thingId).description("Could not set v1 ACL to Thing already containing v2 Policy").build();
        }
        if (Objects.equals(this.acl, accessControlList)) {
            return this;
        }
        return new ImmutableThing(this.thingId, accessControlList, null, this.definition, this.attributes, this.features, this.lifecycle, this.revision, this.modified, this.created, this.metadata);
    }

    @Override
    @Deprecated
    public Thing setAclEntry(AclEntry aclEntry) {
        AccessControlList newAcl = null == this.acl || this.acl.isEmpty() ? ThingsModelFactory.newAcl(aclEntry, new AclEntry[0]) : this.acl.setEntry(aclEntry);
        return this.setAccessControlList(newAcl);
    }

    @Override
    @Deprecated
    public Thing removeAllPermissionsOf(AuthorizationSubject authorizationSubject) {
        if (null == this.acl || this.acl.isEmpty()) {
            return this;
        }
        return this.setAccessControlList(this.acl.removeAllPermissionsOf(authorizationSubject));
    }

    @Override
    public Optional<PolicyId> getPolicyEntityId() {
        return Optional.ofNullable(this.policyId);
    }

    @Override
    public Thing setPolicyId(@Nullable PolicyId policyId) {
        return new ImmutableThing(this.thingId, this.acl, policyId, this.definition, this.attributes, this.features, this.lifecycle, this.revision, this.modified, this.created, this.metadata);
    }

    @Override
    public Optional<ThingLifecycle> getLifecycle() {
        return Optional.ofNullable(this.lifecycle);
    }

    @Override
    public Thing setLifecycle(ThingLifecycle newLifecycle) {
        ConditionChecker.checkNotNull((Object)((Object)newLifecycle), (String)"lifecycle to be set");
        return new ImmutableThing(this.thingId, this.acl, this.policyId, this.definition, this.attributes, this.features, newLifecycle, this.revision, this.modified, this.created, this.metadata);
    }

    public Optional<Metadata> getMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(Thing.JsonFields.SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate);
        if (null != this.lifecycle) {
            jsonObjectBuilder.set(Thing.JsonFields.LIFECYCLE, (Object)this.lifecycle.name(), predicate);
        }
        if (null != this.revision) {
            jsonObjectBuilder.set(Thing.JsonFields.REVISION, (Object)this.revision.toLong(), predicate);
        }
        if (null != this.modified) {
            jsonObjectBuilder.set(Thing.JsonFields.MODIFIED, (Object)this.modified.toString(), predicate);
        }
        if (null != this.created) {
            jsonObjectBuilder.set(Thing.JsonFields.CREATED, (Object)this.created.toString(), predicate);
        }
        if (null != this.thingId) {
            jsonObjectBuilder.set(Thing.JsonFields.NAMESPACE, (Object)this.thingId.getNamespace(), predicate);
            jsonObjectBuilder.set(Thing.JsonFields.ID, (Object)this.thingId.toString(), predicate);
        }
        if (JsonSchemaVersion.V_1.equals((Object)schemaVersion)) {
            AccessControlList theAcl = this.getAccessControlList().orElseGet(ThingsModelFactory::emptyAcl);
            jsonObjectBuilder.set(Thing.JsonFields.ACL, (Object)theAcl.toJson(), predicate);
        } else {
            if (null != this.policyId) {
                jsonObjectBuilder.set(Thing.JsonFields.POLICY_ID, (Object)String.valueOf(this.policyId), predicate);
            }
            if (null != this.definition) {
                if (this.definition instanceof NullThingDefinition) {
                    jsonObjectBuilder.set(Thing.JsonFields.DEFINITION, (Object)JsonValue.nullLiteral(), predicate);
                } else {
                    jsonObjectBuilder.set(Thing.JsonFields.DEFINITION, (Object)JsonValue.of((String)this.definition.toString()), predicate);
                }
            }
        }
        if (null != this.attributes) {
            jsonObjectBuilder.set(Thing.JsonFields.ATTRIBUTES, (Object)this.attributes, predicate);
        }
        if (null != this.features) {
            jsonObjectBuilder.set(Thing.JsonFields.FEATURES, (Object)((JsonObject)this.features.toJson(schemaVersion, thePredicate.and(FieldType.notHidden()))), predicate);
        }
        if (null != this.metadata) {
            jsonObjectBuilder.set(Thing.JsonFields.METADATA, (Object)((JsonObject)this.metadata.toJson(schemaVersion, thePredicate)), predicate);
        }
        return jsonObjectBuilder.build();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.thingId, this.policyId, this.acl, this.definition, this.attributes, this.features, this.lifecycle, this.revision, this.modified, this.created, this.metadata});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableThing other = (ImmutableThing)obj;
        return Objects.equals((Object)this.thingId, (Object)other.thingId) && Objects.equals(this.policyId, other.policyId) && Objects.equals(this.acl, other.acl) && Objects.equals(this.definition, other.definition) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.features, other.features) && Objects.equals((Object)this.lifecycle, (Object)other.lifecycle) && Objects.equals(this.revision, other.revision) && Objects.equals(this.modified, other.modified) && Objects.equals(this.created, other.created) && Objects.equals(this.metadata, other.metadata);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [thingId=" + (Object)((Object)this.thingId) + ", acl=" + this.acl + ", policyId=" + this.policyId + ", definition=" + this.definition + ", attributes=" + this.attributes + ", features=" + this.features + ", lifecycle=" + (Object)((Object)this.lifecycle) + ", revision=" + this.revision + ", modified=" + this.modified + ", created=" + this.created + ", metadata=" + this.metadata + "]";
    }
}

