/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.time.Instant;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.metadata.Metadata;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PolicyId;
import org.eclipse.ditto.model.things.AccessControlList;
import org.eclipse.ditto.model.things.AccessControlListBuilder;
import org.eclipse.ditto.model.things.AclEntry;
import org.eclipse.ditto.model.things.Attributes;
import org.eclipse.ditto.model.things.AttributesBuilder;
import org.eclipse.ditto.model.things.Feature;
import org.eclipse.ditto.model.things.FeatureDefinition;
import org.eclipse.ditto.model.things.FeatureProperties;
import org.eclipse.ditto.model.things.Features;
import org.eclipse.ditto.model.things.FeaturesBuilder;
import org.eclipse.ditto.model.things.ImmutableThing;
import org.eclipse.ditto.model.things.NullThingDefinition;
import org.eclipse.ditto.model.things.Permission;
import org.eclipse.ditto.model.things.Permissions;
import org.eclipse.ditto.model.things.Thing;
import org.eclipse.ditto.model.things.ThingBuilder;
import org.eclipse.ditto.model.things.ThingDefinition;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.model.things.ThingLifecycle;
import org.eclipse.ditto.model.things.ThingRevision;
import org.eclipse.ditto.model.things.ThingsModelFactory;

@NotThreadSafe
final class ImmutableThingFromScratchBuilder
implements ThingBuilder,
ThingBuilder.FromScratch {
    @Nullable
    ThingId id = null;
    @Nullable
    ThingLifecycle lifecycle = null;
    @Nullable
    ThingRevision revision = null;
    @Nullable
    Instant modified = null;
    @Nullable
    Instant created = null;
    @Nullable
    Metadata metadata = null;
    @Nullable
    private JsonSchemaVersion schemaVersion;
    @Nullable
    private PolicyId policyId = null;
    @Nullable
    @Deprecated
    private AccessControlListBuilder aclBuilder = null;
    @Nullable
    private AttributesBuilder attributesBuilder = null;
    @Nullable
    private Attributes attributes = null;
    @Nullable
    private ThingDefinition definition = null;
    @Nullable
    private FeaturesBuilder featuresBuilder = null;
    @Nullable
    private Features features = null;

    private ImmutableThingFromScratchBuilder() {
    }

    public static ImmutableThingFromScratchBuilder newInstance() {
        return new ImmutableThingFromScratchBuilder();
    }

    @Override
    public ThingBuilder.FromScratch setAttributes(Attributes attributes) {
        ConditionChecker.checkNotNull((Object)attributes, (String)"Attributes to be set");
        if (attributes.isNull()) {
            return this.setNullAttributes();
        }
        this.invokeOnAttributesBuilder(ab -> ab.removeAll().setAll((Iterable)((Object)attributes)));
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setAttributes(JsonObject attributesJsonObject) {
        ConditionChecker.checkNotNull((Object)attributesJsonObject, (String)"JSON object representation of Attributes to be set");
        if (attributesJsonObject.isNull()) {
            return this.setNullAttributes();
        }
        if (attributesJsonObject.isEmpty()) {
            return this.setEmptyAttributes();
        }
        return this.setAttributes(ThingsModelFactory.newAttributes(attributesJsonObject));
    }

    @Override
    public ThingBuilder.FromScratch setAttributes(String attributesJsonString) {
        return this.setAttributes(ThingsModelFactory.newAttributes(attributesJsonString));
    }

    @Override
    public ThingBuilder.FromScratch removeAllAttributes() {
        this.attributesBuilder = null;
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setEmptyAttributes() {
        this.attributesBuilder = null;
        this.attributes = ThingsModelFactory.emptyAttributes();
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setNullAttributes() {
        this.attributesBuilder = null;
        this.attributes = ThingsModelFactory.nullAttributes();
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setAttribute(JsonPointer attributePath, JsonValue attributeValue) {
        ConditionChecker.checkNotNull((Object)attributeValue, (String)"attribute value to be set");
        this.invokeOnAttributesBuilder(ab -> ab.set((CharSequence)attributePath, attributeValue));
        return this;
    }

    @Override
    public ThingBuilder.FromScratch removeAttribute(JsonPointer attributePath) {
        if (null != this.attributesBuilder) {
            this.invokeOnAttributesBuilder(ab -> ab.remove((CharSequence)attributePath));
        }
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setDefinition(@Nullable ThingDefinition definition) {
        this.definition = definition;
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setNullDefinition() {
        this.definition = NullThingDefinition.getInstance();
        return this;
    }

    @Override
    public ThingBuilder.FromScratch removeDefinition() {
        this.definition = null;
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setFeature(Feature feature) {
        this.invokeOnFeaturesBuilder(fb -> fb.set(feature));
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setFeature(String featureId) {
        return this.setFeature(ThingsModelFactory.newFeature(featureId));
    }

    @Override
    public ThingBuilder.FromScratch setFeature(String featureId, @Nullable FeatureDefinition featureDefinition, FeatureProperties featureProperties) {
        return this.setFeature(ThingsModelFactory.newFeature(featureId, featureDefinition, featureProperties));
    }

    @Override
    public ThingBuilder.FromScratch setFeature(CharSequence featureId, @Nullable FeatureDefinition featureDefinition, @Nullable FeatureProperties featureProperties, @Nullable FeatureProperties featureDesiredProperties) {
        return this.setFeature(ThingsModelFactory.newFeature(featureId, featureDefinition, featureProperties, featureDesiredProperties));
    }

    @Override
    public ThingBuilder.FromScratch setFeature(String featureId, @Nullable FeatureProperties featureProperties) {
        return this.setFeature(ThingsModelFactory.newFeature(featureId, featureProperties));
    }

    @Override
    public ThingBuilder.FromScratch removeFeature(String featureId) {
        this.invokeOnFeaturesBuilder(fb -> fb.remove(featureId));
        Features fs = this.getFeatures();
        if (null == fs || fs.isEmpty()) {
            this.featuresBuilder = null;
        }
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setFeatureDefinition(String featureId, @Nullable FeatureDefinition featureDefinition) {
        ConditionChecker.checkNotNull((Object)featureDefinition, (String)"Feature Definition to be set");
        this.invokeOnFeaturesBuilder(fb -> fb.set(fb.get(featureId).map(feature -> feature.setDefinition(featureDefinition)).orElseGet(() -> ThingsModelFactory.newFeature(featureId, featureDefinition))));
        return this;
    }

    @Override
    public ThingBuilder.FromScratch removeFeatureDefinition(String featureId) {
        if (null != this.featuresBuilder) {
            this.featuresBuilder.get(featureId).map(Feature::removeDefinition).ifPresent(this.featuresBuilder::set);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setFeatureProperty(String featureId, JsonPointer propertyPath, JsonValue propertyValue) {
        ConditionChecker.checkNotNull((Object)propertyValue, (String)"property value to be set");
        Features existingFeatures = this.getFeatures();
        if (null != existingFeatures) {
            return this.setFeatures(existingFeatures.setProperty(featureId, propertyPath, propertyValue));
        }
        FeatureProperties featureProperties = ThingsModelFactory.newFeaturePropertiesBuilder().set((CharSequence)propertyPath, propertyValue).build();
        return this.setFeature(featureId, featureProperties);
    }

    @Override
    public ThingBuilder.FromScratch removeFeatureProperty(String featureId, JsonPointer propertyPath) {
        Features existingFeatures;
        ConditionChecker.checkNotNull((Object)featureId, (String)"identifier of the Feature from which the property to be removed");
        ConditionChecker.checkNotNull((Object)propertyPath, (String)"path to the property to be removed");
        if (null != this.featuresBuilder && null != (existingFeatures = this.getFeatures())) {
            return this.setFeatures(existingFeatures.removeProperty(featureId, propertyPath));
        }
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setFeatureProperties(String featureId, FeatureProperties featureProperties) {
        ConditionChecker.checkNotNull((Object)featureId, (String)"ID of the Feature to set the properties for");
        ConditionChecker.checkNotNull((Object)featureProperties, (String)"FeatureProperties to be set");
        this.invokeOnFeaturesBuilder(fb -> fb.set(fb.get(featureId).map(feature -> feature.setProperties(featureProperties)).orElseGet(() -> ThingsModelFactory.newFeature(featureId, featureProperties))));
        return this;
    }

    @Override
    public ThingBuilder.FromScratch removeFeatureProperties(String featureId) {
        ConditionChecker.checkNotNull((Object)featureId, (String)"ID of the Feature to set the properties for");
        if (null != this.featuresBuilder) {
            this.featuresBuilder.get(featureId).map(Feature::removeProperties).ifPresent(this.featuresBuilder::set);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setFeatureDesiredProperty(CharSequence featureId, JsonPointer desiredPropertyPath, JsonValue desiredPropertyValue) {
        ConditionChecker.checkNotNull((Object)desiredPropertyPath, (String)"desiredPropertyPath");
        Features existingFeatures = this.getFeatures();
        if (null != existingFeatures) {
            return this.setFeatures(existingFeatures.setDesiredProperty(featureId, desiredPropertyPath, desiredPropertyValue));
        }
        FeatureProperties featureDesiredProperties = ThingsModelFactory.newFeaturePropertiesBuilder().set((CharSequence)desiredPropertyPath, desiredPropertyValue).build();
        return this.setFeature(featureId, null, null, featureDesiredProperties);
    }

    @Override
    public ThingBuilder.FromScratch removeFeatureDesiredProperty(CharSequence featureId, JsonPointer desiredPropertyPath) {
        Features existingFeatures;
        ConditionChecker.checkNotNull((Object)featureId, (String)"featureId");
        ConditionChecker.checkNotNull((Object)desiredPropertyPath, (String)"desiredPropertyPath");
        if (null != this.featuresBuilder && null != (existingFeatures = this.getFeatures())) {
            return this.setFeatures(existingFeatures.removeDesiredProperty(featureId, desiredPropertyPath));
        }
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setFeatureDesiredProperties(CharSequence featureId, FeatureProperties desiredPropertiesPath) {
        ConditionChecker.checkNotNull((Object)featureId, (String)"featureId");
        ConditionChecker.checkNotNull((Object)desiredPropertiesPath, (String)"desiredPropertiesPath");
        this.invokeOnFeaturesBuilder(fb -> fb.set(fb.get(featureId).map(feature -> feature.setDesiredProperties(desiredPropertiesPath)).orElseGet(() -> ThingsModelFactory.newFeature(featureId, null, null, desiredPropertiesPath))));
        return this;
    }

    @Override
    public ThingBuilder.FromScratch removeFeatureDesiredProperties(CharSequence featureId) {
        ConditionChecker.checkNotNull((Object)featureId, (String)"featureId");
        if (null != this.featuresBuilder) {
            this.featuresBuilder.get(featureId).map(Feature::removeDesiredProperties).ifPresent(this.featuresBuilder::set);
        }
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setFeatures(Iterable<Feature> features) {
        Features featuresToSet;
        ConditionChecker.checkNotNull(features, (String)"Features to be set");
        if (features instanceof Features && (featuresToSet = (Features)features).isNull()) {
            return this.setNullFeatures();
        }
        this.invokeOnFeaturesBuilder(fb -> fb.removeAll().setAll(features));
        return this;
    }

    @Override
    public ThingBuilder.FromScratch removeAllFeatures() {
        this.featuresBuilder = null;
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setEmptyFeatures() {
        this.featuresBuilder = null;
        this.features = ThingsModelFactory.emptyFeatures();
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setNullFeatures() {
        this.featuresBuilder = null;
        this.features = ThingsModelFactory.nullFeatures();
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setFeatures(JsonObject featuresJsonObject) {
        ConditionChecker.checkNotNull((Object)featuresJsonObject, (String)"JSON object representation of Features to be set");
        if (featuresJsonObject.isNull()) {
            return this.setNullFeatures();
        }
        return this.setFeatures(ThingsModelFactory.newFeatures(featuresJsonObject));
    }

    @Override
    public ThingBuilder.FromScratch setFeatures(String featuresJsonString) {
        return this.setFeatures(ThingsModelFactory.newFeatures(featuresJsonString));
    }

    @Override
    public ThingBuilder.FromScratch setLifecycle(@Nullable ThingLifecycle lifecycle) {
        this.lifecycle = lifecycle;
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setRevision(@Nullable ThingRevision revision) {
        this.revision = revision;
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setRevision(long revisionNumber) {
        return this.setRevision(ThingsModelFactory.newThingRevision(revisionNumber));
    }

    @Override
    public ThingBuilder.FromScratch setModified(@Nullable Instant modified) {
        this.modified = modified;
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setCreated(@Nullable Instant created) {
        this.created = created;
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setMetadata(@Nullable Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromScratch setPermissions(JsonObject accessControlListJsonObject) {
        AccessControlList accessControlList = ThingsModelFactory.newAcl(accessControlListJsonObject);
        return this.setPermissions(accessControlList);
    }

    @Override
    @Deprecated
    public ThingBuilder.FromScratch setPermissions(String accessControlListJsonString) {
        AccessControlList accessControlList = ThingsModelFactory.newAcl(accessControlListJsonString);
        return this.setPermissions(accessControlList);
    }

    @Override
    @Deprecated
    public ThingBuilder.FromScratch setPermissions(AuthorizationSubject authorizationSubject, Permissions permissions) {
        AclEntry aclEntry = ThingsModelFactory.newAclEntry(authorizationSubject, permissions);
        return this.setPermissions(aclEntry, new AclEntry[0]);
    }

    @Override
    @Deprecated
    public ThingBuilder.FromScratch setPermissions(AuthorizationSubject authorizationSubject, Permission permission, Permission ... furtherPermissions) {
        AclEntry aclEntry = ThingsModelFactory.newAclEntry(authorizationSubject, permission, furtherPermissions);
        return this.setPermissions(aclEntry, new AclEntry[0]);
    }

    @Override
    @Deprecated
    public ThingBuilder.FromScratch setPermissions(AclEntry aclEntry, AclEntry ... furtherAclEntries) {
        this.invokeOnAclBuilder(ab -> ab.set(aclEntry));
        for (AclEntry furtherAclEntry : furtherAclEntries) {
            this.invokeOnAclBuilder(ab -> ab.set(furtherAclEntry));
        }
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromScratch setPermissions(Iterable<AclEntry> aclEntries) {
        this.invokeOnAclBuilder(ab -> ab.setAll(aclEntries));
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromScratch removePermissionsOf(AuthorizationSubject authorizationSubject) {
        ConditionChecker.checkNotNull((Object)authorizationSubject, (String)"authorization subject of which all permissions are to be removed");
        if (null != this.aclBuilder) {
            this.invokeOnAclBuilder(ab -> ab.remove(authorizationSubject));
        }
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromScratch removeAllPermissions() {
        this.aclBuilder = null;
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setPolicyId(@Nullable PolicyId policyId) {
        this.policyId = policyId;
        return this;
    }

    @Override
    public ThingBuilder.FromScratch removePolicyId() {
        this.policyId = null;
        return this;
    }

    @Override
    @Deprecated
    public ThingBuilder.FromScratch setId(@Nullable String thingId) {
        this.id = thingId == null ? null : ThingId.of(thingId);
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setId(@Nullable ThingId thingId) {
        this.id = thingId;
        return this;
    }

    @Override
    public ThingBuilder.FromScratch setGeneratedId() {
        this.id = ThingBuilder.generateRandomTypedThingId();
        return this;
    }

    @Override
    public Thing build() {
        if (null != this.policyId) {
            return ImmutableThing.of(this.id, null, this.policyId, this.definition, this.getAttributes(), this.getFeatures(), this.lifecycle, this.revision, this.modified, this.created, this.metadata);
        }
        return ImmutableThing.of(this.id, this.getAcl(), null, this.definition, this.getAttributes(), this.getFeatures(), this.lifecycle, this.revision, this.modified, this.created, this.metadata);
    }

    @Deprecated
    private void invokeOnAclBuilder(Consumer<AccessControlListBuilder> aclBuilderConsumer) {
        AccessControlListBuilder result = this.aclBuilder;
        if (null == result) {
            this.aclBuilder = result = ThingsModelFactory.newAclBuilder();
        }
        aclBuilderConsumer.accept(result);
    }

    private void invokeOnAttributesBuilder(Consumer<AttributesBuilder> attributesBuilderConsumer) {
        AttributesBuilder result = this.attributesBuilder;
        if (null == result) {
            this.attributesBuilder = result = ThingsModelFactory.newAttributesBuilder();
        }
        attributesBuilderConsumer.accept(result);
        this.attributes = null;
    }

    private void invokeOnFeaturesBuilder(Consumer<FeaturesBuilder> featuresBuilderConsumer) {
        FeaturesBuilder result = this.featuresBuilder;
        if (null == result) {
            this.featuresBuilder = result = ThingsModelFactory.newFeaturesBuilder();
        }
        featuresBuilderConsumer.accept(result);
        this.features = null;
    }

    @Nullable
    @Deprecated
    AccessControlList getAcl() {
        AccessControlList result = null;
        if (null != this.aclBuilder) {
            result = this.aclBuilder.build();
        }
        return result;
    }

    @Nullable
    Attributes getAttributes() {
        Attributes result = this.attributes;
        if (null != this.attributesBuilder) {
            result = this.attributesBuilder.build();
        }
        return result;
    }

    @Nullable
    Features getFeatures() {
        Features result = this.features;
        if (null != this.featuresBuilder) {
            result = this.featuresBuilder.build();
        }
        return result;
    }
}

