/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.things.ThingRevision;

@Immutable
final class ImmutableThingRevision
implements ThingRevision {
    private final long value;

    private ImmutableThingRevision(long theValue) {
        this.value = theValue;
    }

    public static ThingRevision of(long value) {
        return new ImmutableThingRevision(value);
    }

    public boolean isGreaterThan(ThingRevision other) {
        return 0 < this.compareTo(other);
    }

    public boolean isGreaterThanOrEqualTo(ThingRevision other) {
        return 0 <= this.compareTo(other);
    }

    public boolean isLowerThan(ThingRevision other) {
        return 0 > this.compareTo(other);
    }

    public boolean isLowerThanOrEqualTo(ThingRevision other) {
        return 0 >= this.compareTo(other);
    }

    public ThingRevision increment() {
        return ImmutableThingRevision.of(this.value + 1L);
    }

    public int compareTo(ThingRevision o) {
        ConditionChecker.checkNotNull((Object)o, (String)"other revision to compare this revision with");
        return Long.compare(this.value, o.toLong());
    }

    public long toLong() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableThingRevision that = (ImmutableThingRevision)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

