/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonKeyInvalidException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.entity.validation.NoControlCharactersNoSlashesValidator;

final class JsonKeyValidator {
    JsonKeyValidator() {
    }

    static JsonObject validateJsonKeys(JsonObject jsonObject) {
        for (JsonField jsonField : jsonObject) {
            JsonKeyValidator.validate(jsonField.getKey());
            JsonValue value = jsonField.getValue();
            if (!value.isObject()) continue;
            JsonKeyValidator.validateJsonKeys(value.asObject());
        }
        return jsonObject;
    }

    static JsonPointer validate(JsonPointer pointer) {
        pointer.forEach(key -> {
            NoControlCharactersNoSlashesValidator validator = NoControlCharactersNoSlashesValidator.getInstance((CharSequence)key);
            if (!validator.isValid()) {
                throw (JsonKeyInvalidException)JsonKeyInvalidException.newBuilderWithDescription((CharSequence)key, (String)validator.getReason().orElse(null)).build();
            }
        });
        return pointer;
    }

    private static void validate(JsonKey key) {
        NoControlCharactersNoSlashesValidator validator = NoControlCharactersNoSlashesValidator.getInstance((CharSequence)key);
        if (!validator.isValid()) {
            throw (JsonKeyInvalidException)JsonKeyInvalidException.newBuilderWithDescription((CharSequence)key, (String)validator.getReason().orElse(null)).build();
        }
    }
}

