/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.entity.id.DefaultNamespacedEntityId;
import org.eclipse.ditto.model.base.entity.id.NamespacedEntityId;
import org.eclipse.ditto.model.base.entity.id.NamespacedEntityIdInvalidException;
import org.eclipse.ditto.model.base.entity.id.NamespacedEntityIdWithType;
import org.eclipse.ditto.model.base.entity.type.EntityType;
import org.eclipse.ditto.model.things.ThingConstants;
import org.eclipse.ditto.model.things.ThingIdInvalidException;

@Immutable
public final class ThingId
extends NamespacedEntityIdWithType {
    private static final ThingId DUMMY_ID = ThingId.of((CharSequence)DefaultNamespacedEntityId.dummy());

    private ThingId(NamespacedEntityId entityId) {
        super(entityId);
    }

    public static ThingId of(CharSequence thingId) {
        if (thingId instanceof ThingId) {
            return (ThingId)((Object)thingId);
        }
        return ThingId.wrapInThingIdInvalidException(() -> new ThingId(DefaultNamespacedEntityId.of((CharSequence)thingId)));
    }

    public static ThingId of(String namespace, String name) {
        return ThingId.wrapInThingIdInvalidException(() -> new ThingId(DefaultNamespacedEntityId.of((String)namespace, (String)name)));
    }

    public static ThingId inDefaultNamespace(String name) {
        return ThingId.wrapInThingIdInvalidException(() -> new ThingId(DefaultNamespacedEntityId.fromName((String)name)));
    }

    public static ThingId generateRandom() {
        return ThingId.wrapInThingIdInvalidException(() -> new ThingId(DefaultNamespacedEntityId.fromName((String)UUID.randomUUID().toString())));
    }

    private static <T> T wrapInThingIdInvalidException(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (NamespacedEntityIdInvalidException e) {
            throw (ThingIdInvalidException)ThingIdInvalidException.newBuilder(e.getEntityId().orElse(null)).cause(e).build();
        }
    }

    public static ThingId dummy() {
        return DUMMY_ID;
    }

    public EntityType getEntityType() {
        return ThingConstants.ENTITY_TYPE;
    }
}

