/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.things.ThingException;

@JsonParsableException(errorCode="things:thing.toolarge")
@Immutable
public final class ThingTooLargeException
extends DittoRuntimeException
implements ThingException {
    public static final String ERROR_CODE = "things:thing.toolarge";
    private static final String MESSAGE_TEMPLATE = "The size of ''{0}'' kB exceeds the maximal allowed Thing size of ''{1}'' kB.";
    private static final String DEFAULT_DESCRIPTION = "Reduce the Thing size in the bounds of the specified limit";
    private static final long serialVersionUID = 6239157630841614456L;

    private ThingTooLargeException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.REQUEST_ENTITY_TOO_LARGE, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(long actualBytes, long maxBytes) {
        return new Builder(actualBytes, maxBytes);
    }

    public static ThingTooLargeException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ThingTooLargeException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<ThingTooLargeException> {
        private Builder() {
            this.description(ThingTooLargeException.DEFAULT_DESCRIPTION);
        }

        private Builder(long actualBytes, long maxBytes) {
            this();
            this.message(MessageFormat.format(ThingTooLargeException.MESSAGE_TEMPLATE, (double)actualBytes / 1024.0, (double)maxBytes / 1024.0));
        }

        protected ThingTooLargeException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new ThingTooLargeException(dittoHeaders, message, description, cause, href);
        }
    }
}

