/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.metadata.Metadata;
import org.eclipse.ditto.model.base.entity.metadata.MetadataBuilder;
import org.eclipse.ditto.model.base.entity.metadata.MetadataModelFactory;
import org.eclipse.ditto.model.base.exceptions.DittoJsonException;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.things.AccessControlList;
import org.eclipse.ditto.model.things.AccessControlListBuilder;
import org.eclipse.ditto.model.things.AccessControlListModelFactory;
import org.eclipse.ditto.model.things.AclEntry;
import org.eclipse.ditto.model.things.Attributes;
import org.eclipse.ditto.model.things.AttributesBuilder;
import org.eclipse.ditto.model.things.AttributesModelFactory;
import org.eclipse.ditto.model.things.DefinitionIdentifier;
import org.eclipse.ditto.model.things.Feature;
import org.eclipse.ditto.model.things.FeatureBuilder;
import org.eclipse.ditto.model.things.FeatureDefinition;
import org.eclipse.ditto.model.things.FeatureDefinitionBuilder;
import org.eclipse.ditto.model.things.FeatureProperties;
import org.eclipse.ditto.model.things.FeaturePropertiesBuilder;
import org.eclipse.ditto.model.things.Features;
import org.eclipse.ditto.model.things.FeaturesBuilder;
import org.eclipse.ditto.model.things.ImmutableFeature;
import org.eclipse.ditto.model.things.ImmutableFeatureDefinition;
import org.eclipse.ditto.model.things.ImmutableFeatureDefinitionIdentifier;
import org.eclipse.ditto.model.things.ImmutableFeatureFromCopyBuilder;
import org.eclipse.ditto.model.things.ImmutableFeatureFromScratchBuilder;
import org.eclipse.ditto.model.things.ImmutableFeatureProperties;
import org.eclipse.ditto.model.things.ImmutableFeaturePropertiesBuilder;
import org.eclipse.ditto.model.things.ImmutableFeatures;
import org.eclipse.ditto.model.things.ImmutableFeaturesBuilder;
import org.eclipse.ditto.model.things.ImmutableThingDefinition;
import org.eclipse.ditto.model.things.ImmutableThingFromCopyBuilder;
import org.eclipse.ditto.model.things.ImmutableThingFromScratchBuilder;
import org.eclipse.ditto.model.things.ImmutableThingRevision;
import org.eclipse.ditto.model.things.JsonKeyValidator;
import org.eclipse.ditto.model.things.NullFeature;
import org.eclipse.ditto.model.things.NullFeatureDefinition;
import org.eclipse.ditto.model.things.NullFeatureProperties;
import org.eclipse.ditto.model.things.NullFeatures;
import org.eclipse.ditto.model.things.NullThingDefinition;
import org.eclipse.ditto.model.things.Permission;
import org.eclipse.ditto.model.things.Permissions;
import org.eclipse.ditto.model.things.Thing;
import org.eclipse.ditto.model.things.ThingBuilder;
import org.eclipse.ditto.model.things.ThingDefinition;
import org.eclipse.ditto.model.things.ThingRevision;

@Immutable
public final class ThingsModelFactory {
    private ThingsModelFactory() {
        throw new AssertionError();
    }

    public static Attributes emptyAttributes() {
        return AttributesModelFactory.emptyAttributes();
    }

    public static Attributes nullAttributes() {
        return AttributesModelFactory.nullAttributes();
    }

    public static Attributes newAttributes(JsonObject jsonObject) {
        return AttributesModelFactory.newAttributes(jsonObject);
    }

    public static Attributes newAttributes(String jsonString) {
        return AttributesModelFactory.newAttributes(jsonString);
    }

    public static AttributesBuilder newAttributesBuilder() {
        return AttributesModelFactory.newAttributesBuilder();
    }

    public static AttributesBuilder newAttributesBuilder(JsonObject jsonObject) {
        return AttributesModelFactory.newAttributesBuilder(jsonObject);
    }

    public static ThingDefinition newDefinition(@Nullable CharSequence thingDefinition) {
        if (null != thingDefinition) {
            return ImmutableThingDefinition.ofParsed(thingDefinition);
        }
        return ThingsModelFactory.nullDefinition();
    }

    public static ThingDefinition nullDefinition() {
        return NullThingDefinition.getInstance();
    }

    public static DefinitionIdentifier newFeatureDefinitionIdentifier(CharSequence namespace, CharSequence name, CharSequence version) {
        return ImmutableFeatureDefinitionIdentifier.getInstance(namespace, name, version);
    }

    public static DefinitionIdentifier newFeatureDefinitionIdentifier(CharSequence featureIdentifierAsCharSequence) {
        if (featureIdentifierAsCharSequence instanceof DefinitionIdentifier) {
            return (DefinitionIdentifier)featureIdentifierAsCharSequence;
        }
        return ImmutableFeatureDefinitionIdentifier.ofParsed(featureIdentifierAsCharSequence);
    }

    public static FeatureDefinition newFeatureDefinition(JsonArray jsonArray) {
        ConditionChecker.checkNotNull((Object)jsonArray, (String)"JSON array");
        if (!jsonArray.isNull()) {
            return ImmutableFeatureDefinition.fromJson(jsonArray);
        }
        return ThingsModelFactory.nullFeatureDefinition();
    }

    public static FeatureDefinition newFeatureDefinition(String jsonString) {
        JsonArray jsonArray = (JsonArray)DittoJsonException.wrapJsonRuntimeException(() -> JsonFactory.newArray((String)jsonString));
        return ThingsModelFactory.newFeatureDefinition(jsonArray);
    }

    public static FeatureDefinition nullFeatureDefinition() {
        return NullFeatureDefinition.getInstance();
    }

    public static FeatureDefinitionBuilder newFeatureDefinitionBuilder(CharSequence firstIdentifier) {
        return ImmutableFeatureDefinition.getBuilder(ThingsModelFactory.newFeatureDefinitionIdentifier(firstIdentifier));
    }

    public static FeatureDefinitionBuilder newFeatureDefinitionBuilder(JsonArray jsonArray) {
        return ImmutableFeatureDefinition.Builder.getInstance().addAll((Iterable)ThingsModelFactory.newFeatureDefinition(jsonArray));
    }

    public static FeatureProperties emptyFeatureProperties() {
        return ImmutableFeatureProperties.empty();
    }

    public static FeatureProperties nullFeatureProperties() {
        return NullFeatureProperties.newInstance();
    }

    public static FeatureProperties newFeatureProperties(JsonObject jsonObject) {
        ConditionChecker.checkNotNull((Object)jsonObject, (String)"JSON object for initialization");
        if (!jsonObject.isNull()) {
            return ImmutableFeatureProperties.of(jsonObject);
        }
        return ThingsModelFactory.nullFeatureProperties();
    }

    public static FeatureProperties newFeatureProperties(String jsonString) {
        JsonObject jsonObject = (JsonObject)DittoJsonException.wrapJsonRuntimeException(() -> JsonFactory.newObject((String)jsonString));
        return ThingsModelFactory.newFeatureProperties(jsonObject);
    }

    public static FeaturePropertiesBuilder newFeaturePropertiesBuilder() {
        return ImmutableFeaturePropertiesBuilder.empty();
    }

    public static FeaturePropertiesBuilder newFeaturePropertiesBuilder(JsonObject jsonObject) {
        return ImmutableFeaturePropertiesBuilder.of(jsonObject);
    }

    public static Feature nullFeature(String featureId) {
        return NullFeature.of(featureId);
    }

    public static Feature newFeature(String featureId) {
        return ImmutableFeature.of(featureId);
    }

    public static Feature newFeature(String featureId, @Nullable FeatureProperties featureProperties) {
        return ImmutableFeature.of(featureId, featureProperties);
    }

    public static Feature newFeature(String featureId, @Nullable FeatureDefinition featureDefinition) {
        return ImmutableFeature.of(featureId, featureDefinition, null);
    }

    public static Feature newFeature(String featureId, @Nullable FeatureDefinition featureDefinition, @Nullable FeatureProperties featureProperties) {
        return ImmutableFeature.of(featureId, featureDefinition, featureProperties);
    }

    public static Feature newFeature(CharSequence featureId, @Nullable FeatureDefinition featureDefinition, @Nullable FeatureProperties featureProperties, @Nullable FeatureProperties desiredFeatureProperties) {
        return ImmutableFeature.of(featureId, featureDefinition, featureProperties, desiredFeatureProperties);
    }

    public static FeatureBuilder.FromScratchBuildable newFeatureBuilder() {
        return ImmutableFeatureFromScratchBuilder.newFeatureFromScratch();
    }

    public static FeatureBuilder.FromCopyBuildable newFeatureBuilder(Feature feature) {
        return ImmutableFeatureFromCopyBuilder.of(feature);
    }

    public static FeatureBuilder.FromJsonBuildable newFeatureBuilder(JsonObject jsonObject) {
        return ImmutableFeatureFromScratchBuilder.newFeatureFromJson(jsonObject);
    }

    public static FeatureBuilder.FromJsonBuildable newFeatureBuilder(String jsonString) {
        JsonObject jsonObject = (JsonObject)DittoJsonException.wrapJsonRuntimeException(() -> JsonFactory.newObject((String)jsonString));
        return ThingsModelFactory.newFeatureBuilder(jsonObject);
    }

    public static Features emptyFeatures() {
        return ImmutableFeatures.empty();
    }

    public static Features nullFeatures() {
        return NullFeatures.newInstance();
    }

    public static Features newFeatures(Iterable<Feature> features) {
        return ImmutableFeatures.of(features);
    }

    public static Features newFeatures(JsonObject jsonObject) {
        Features result;
        ConditionChecker.checkNotNull((Object)jsonObject, (String)"Features JSON object");
        if (!jsonObject.isNull()) {
            Set<Feature> features = jsonObject.stream().filter(field -> !Objects.equals(field.getKey(), JsonSchemaVersion.getJsonKey())).peek(field -> {
                if (!field.getValue().isObject()) {
                    String errorMsgTemplate = "The Feature value is not an object for Feature with ID ''{0}'': {1}";
                    String errorMsg = MessageFormat.format("The Feature value is not an object for Feature with ID ''{0}'': {1}", field.getKey(), field.getValue());
                    throw new DittoJsonException((RuntimeException)new JsonParseException(errorMsg));
                }
            }).map(field -> ImmutableFeatureFromScratchBuilder.newFeatureFromJson(field.getValue().asObject()).useId(field.getKeyName()).build()).collect(Collectors.toSet());
            result = ImmutableFeatures.of(features);
        } else {
            result = ThingsModelFactory.nullFeatures();
        }
        return result;
    }

    public static Features newFeatures(String jsonString) {
        JsonObject featuresJsonObject = (JsonObject)DittoJsonException.wrapJsonRuntimeException(() -> JsonFactory.newObject((String)jsonString));
        return ThingsModelFactory.newFeatures(featuresJsonObject);
    }

    public static Features newFeatures(Feature feature, Feature ... additionalFeatures) {
        return ImmutableFeatures.of(feature, additionalFeatures);
    }

    public static FeaturesBuilder newFeaturesBuilder() {
        return ImmutableFeaturesBuilder.newInstance();
    }

    public static FeaturesBuilder newFeaturesBuilder(Iterable<Feature> features) {
        FeaturesBuilder result = ImmutableFeaturesBuilder.newInstance();
        result.setAll(features);
        return result;
    }

    public static JsonPointer validateFeaturePropertyPointer(JsonPointer jsonPointer) {
        return JsonKeyValidator.validate(jsonPointer);
    }

    public static void validateJsonKeys(JsonObject jsonObject) {
        JsonKeyValidator.validateJsonKeys(jsonObject);
    }

    public static Metadata emptyMetadata() {
        return MetadataModelFactory.emptyMetadata();
    }

    public static Metadata nullMetadata() {
        return MetadataModelFactory.nullMetadata();
    }

    public static Metadata newMetadata(JsonObject jsonObject) {
        return MetadataModelFactory.newMetadata((JsonObject)jsonObject);
    }

    public static Metadata newMetadata(String jsonString) {
        return MetadataModelFactory.newMetadata((String)jsonString);
    }

    public static MetadataBuilder newMetadataBuilder() {
        return MetadataModelFactory.newMetadataBuilder();
    }

    public static MetadataBuilder newMetadataBuilder(Metadata metadata) {
        return MetadataModelFactory.newMetadataBuilder((Metadata)metadata);
    }

    public static ThingRevision newThingRevision(long revisionNumber) {
        return ImmutableThingRevision.of(revisionNumber);
    }

    @Deprecated
    public static Permissions noPermissions() {
        return AccessControlListModelFactory.noPermissions();
    }

    public static Permissions allPermissions() {
        return AccessControlListModelFactory.allPermissions();
    }

    public static Permissions newPermissions(Collection<Permission> permissions) {
        return AccessControlListModelFactory.newPermissions(permissions);
    }

    public static Permissions newPermissions(Permission permission, Permission ... furtherPermissions) {
        return AccessControlListModelFactory.newPermissions(permission, furtherPermissions);
    }

    public static Permissions newUnmodifiablePermissions(Permission permission, Permission ... furtherPermissions) {
        return AccessControlListModelFactory.newUnmodifiablePermissions(permission, furtherPermissions);
    }

    public static AclEntry newAclEntry(AuthorizationSubject authorizationSubject, Permission permission, Permission ... furtherPermissions) {
        return AccessControlListModelFactory.newAclEntry(authorizationSubject, permission, furtherPermissions);
    }

    public static AclEntry newAclEntry(AuthorizationSubject authorizationSubject, Iterable<Permission> permissions) {
        return AccessControlListModelFactory.newAclEntry(authorizationSubject, permissions);
    }

    public static AclEntry newAclEntry(JsonObject jsonObject) {
        return AccessControlListModelFactory.newAclEntry(jsonObject);
    }

    @Deprecated
    public static AclEntry newAclEntry(CharSequence authorizationSubjectId, JsonValue permissionsValue) {
        return AccessControlListModelFactory.newAclEntry(authorizationSubjectId, permissionsValue);
    }

    @Deprecated
    public static AccessControlListBuilder newAclBuilder() {
        return AccessControlListModelFactory.newAclBuilder();
    }

    @Deprecated
    public static AccessControlListBuilder newAclBuilder(Iterable<AclEntry> aclEntries) {
        return AccessControlListModelFactory.newAclBuilder(aclEntries);
    }

    @Deprecated
    public static AccessControlListBuilder newAclBuilder(Optional<? extends Iterable<AclEntry>> aclEntries) {
        return AccessControlListModelFactory.newAclBuilder(aclEntries);
    }

    @Deprecated
    public static AccessControlList emptyAcl() {
        return AccessControlListModelFactory.emptyAcl();
    }

    @Deprecated
    public static AccessControlList newAcl(AclEntry entry, AclEntry ... furtherEntries) {
        return AccessControlListModelFactory.newAcl(entry, furtherEntries);
    }

    @Deprecated
    public static AccessControlList newAcl(Iterable<AclEntry> entries) {
        return AccessControlListModelFactory.newAcl(entries);
    }

    @Deprecated
    public static AccessControlList newAcl(JsonObject jsonObject) {
        return AccessControlListModelFactory.newAcl(jsonObject);
    }

    @Deprecated
    public static AccessControlList newAcl(String jsonString) {
        return AccessControlListModelFactory.newAcl(jsonString);
    }

    public static Thing newThing(JsonObject jsonObject) {
        return ThingsModelFactory.newThingBuilder(jsonObject).build();
    }

    public static Thing newThing(String jsonString) {
        JsonObject jsonObject = (JsonObject)DittoJsonException.wrapJsonRuntimeException(() -> JsonFactory.newObject((String)jsonString));
        return ThingsModelFactory.newThingBuilder(jsonObject).build();
    }

    public static ThingBuilder.FromScratch newThingBuilder() {
        return ImmutableThingFromScratchBuilder.newInstance();
    }

    public static ThingBuilder.FromCopy newThingBuilder(JsonObject jsonObject) {
        return (ThingBuilder.FromCopy)DittoJsonException.wrapJsonRuntimeException(() -> ImmutableThingFromCopyBuilder.of(jsonObject));
    }

    public static ThingBuilder.FromCopy newThingBuilder(String jsonString) {
        JsonObject jsonObject = (JsonObject)DittoJsonException.wrapJsonRuntimeException(() -> JsonFactory.newObject((String)jsonString));
        return ThingsModelFactory.newThingBuilder(jsonObject);
    }

    public static ThingBuilder.FromCopy newThingBuilder(Thing thing) {
        return ImmutableThingFromCopyBuilder.of(thing);
    }
}

