/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.httpclient;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.security.auth.login.LoginException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.ProxyAddress;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient.Messages;
import org.eclipse.ecf.provider.filetransfer.httpclient.SslProtocolSocketFactory;
import org.eclipse.ecf.provider.filetransfer.identity.FileTransferID;
import org.eclipse.ecf.provider.filetransfer.retrieve.AbstractRetrieveFileTransfer;

public class HttpClientRetrieveFileTransfer
extends AbstractRetrieveFileTransfer {
    private static final String HTTP_PROXY_PORT = Messages.HttpClientRetrieveFileTransfer_Http_ProxyPort_Prop;
    private static final String HTTP_PROXY_HOST = Messages.HttpClientRetrieveFileTransfer_Http_ProxyHost_Prop;
    private static final String USERNAME_PREFIX = Messages.HttpClientRetrieveFileTransfer_Username_Prefix;
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    protected static final int HTTP_PORT = 80;
    protected static final int HTTPS_PORT = 443;
    protected static final int MAX_RETRY = 2;
    protected static final String HTTPS = Messages.FileTransferNamespace_Https_Protocol;
    protected static final String HTTP = Messages.FileTransferNamespace_Http_Protocol;
    protected static final String[] supportedProtocols = new String[]{HTTP, HTTPS};
    private GetMethod getMethod = null;
    private HttpClient httpClient = null;
    private IConnectContext fileRequestConnectContext = null;
    private String username;
    private String password;
    private Proxy proxy;

    public HttpClientRetrieveFileTransfer(HttpClient httpClient) {
        if (httpClient == null) {
            throw new NullPointerException("httpClient cannot be null");
        }
        this.httpClient = httpClient;
    }

    protected void hardClose() {
        if (this.getMethod != null) {
            this.getMethod.releaseConnection();
            this.getMethod = null;
        }
        super.hardClose();
    }

    protected Credentials getFileRequestCredentials() throws UnsupportedCallbackException, IOException {
        if (this.fileRequestConnectContext == null) {
            return null;
        }
        CallbackHandler callbackHandler = this.fileRequestConnectContext.getCallbackHandler();
        if (callbackHandler == null) {
            return null;
        }
        NameCallback usernameCallback = new NameCallback(USERNAME_PREFIX);
        ObjectCallback passwordCallback = new ObjectCallback();
        callbackHandler.handle(new Callback[]{usernameCallback, passwordCallback});
        this.username = usernameCallback.getName();
        this.password = (String)passwordCallback.getObject();
        return new UsernamePasswordCredentials(this.username, this.password);
    }

    private Proxy getSystemProxy() {
        String systemHttpProxyHost = System.getProperty(HTTP_PROXY_HOST, null);
        String systemHttpProxyPort = System.getProperty(HTTP_PROXY_PORT, "80");
        int port = -1;
        try {
            port = Integer.parseInt(systemHttpProxyPort);
        }
        catch (Exception exception) {}
        if (systemHttpProxyHost == null || systemHttpProxyHost.equals("")) {
            return null;
        }
        return new Proxy(Proxy.Type.HTTP, new ProxyAddress(systemHttpProxyHost, port));
    }

    protected void setupProxy(String urlString) {
        if (this.proxy == null) {
            this.proxy = this.getSystemProxy();
        }
        if (this.proxy != null && !Proxy.NO_PROXY.equals((Object)this.proxy) && !HttpClientRetrieveFileTransfer.urlUsesHttps(urlString)) {
            ProxyAddress address = this.proxy.getAddress();
            this.httpClient.getHostConfiguration().setProxy(HttpClientRetrieveFileTransfer.getHostFromURL(address.getHostName()), address.getPort());
            String proxyUsername = this.proxy.getUsername();
            String proxyPassword = this.proxy.getPassword();
            if (this.username != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                AuthScope proxyAuthScope = new AuthScope(address.getHostName(), address.getPort(), AuthScope.ANY_REALM);
                this.httpClient.getState().setProxyCredentials(proxyAuthScope, (Credentials)credentials);
            }
        }
    }

    protected void setupAuthentication(String urlString) throws UnsupportedCallbackException, IOException {
        Credentials credentials = null;
        if (this.username == null) {
            credentials = this.getFileRequestCredentials();
        }
        if (credentials != null && this.username != null) {
            AuthScope authScope = new AuthScope(HttpClientRetrieveFileTransfer.getHostFromURL(urlString), HttpClientRetrieveFileTransfer.getPortFromURL(urlString), AuthScope.ANY_REALM);
            this.httpClient.getState().setCredentials(authScope, credentials);
        }
    }

    protected void setupHostAndPort(String urlString) {
        if (HttpClientRetrieveFileTransfer.urlUsesHttps(urlString)) {
            Protocol acceptAllSsl = new Protocol(HTTPS, (ProtocolSocketFactory)new SslProtocolSocketFactory(this.proxy), HttpClientRetrieveFileTransfer.getPortFromURL(urlString));
            this.httpClient.getHostConfiguration().setHost(HttpClientRetrieveFileTransfer.getHostFromURL(urlString), HttpClientRetrieveFileTransfer.getPortFromURL(urlString), acceptAllSsl);
        } else {
            this.httpClient.getHostConfiguration().setHost(HttpClientRetrieveFileTransfer.getHostFromURL(urlString), HttpClientRetrieveFileTransfer.getPortFromURL(urlString));
        }
    }

    protected void openStreams() throws IncomingFileTransferException {
        String urlString = this.getRemoteFileURL().toString();
        try {
            this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(30000);
            this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
            this.setupProxy(urlString);
            this.setupAuthentication(urlString);
            this.setupHostAndPort(urlString);
            this.getMethod = new GetMethod(urlString);
            this.getMethod.setFollowRedirects(true);
            int code = this.httpClient.executeMethod((HttpMethod)this.getMethod);
            if (code != 200) {
                if (code == 401 || code == 403) {
                    this.getMethod.getResponseBody();
                    this.getMethod.releaseConnection();
                    throw new IncomingFileTransferException(Messages.HttpClientRetrieveFileTransfer_Unauthorized);
                }
                if (code == 407) {
                    throw new LoginException(Messages.HttpClientRetrieveFileTransfer_Proxy_Auth_Required);
                }
                throw new IOException("HttpClient connection error response code: " + code);
            }
            long contentLength = this.getMethod.getResponseContentLength();
            this.setInputStream(this.getMethod.getResponseBodyAsStream());
            this.setFileLength(contentLength);
            this.listener.handleTransferEvent((IFileTransferEvent)new IIncomingFileTransferReceiveStartEvent(){
                private static final long serialVersionUID = -59096575294481755L;

                public IFileID getFileID() {
                    return HttpClientRetrieveFileTransfer.this.remoteFileID;
                }

                public IIncomingFileTransfer receive(File localFileToSave) throws IOException {
                    HttpClientRetrieveFileTransfer.this.setOutputStream(new BufferedOutputStream(new FileOutputStream(localFileToSave)));
                    HttpClientRetrieveFileTransfer.this.job = (Job)new AbstractRetrieveFileTransfer.FileTransferJob((AbstractRetrieveFileTransfer)HttpClientRetrieveFileTransfer.this, HttpClientRetrieveFileTransfer.this.getRemoteFileURL().toString());
                    HttpClientRetrieveFileTransfer.this.job.schedule();
                    return HttpClientRetrieveFileTransfer.this;
                }

                public String toString() {
                    StringBuffer sb = new StringBuffer("IIncomingFileTransferReceiveStartEvent[");
                    sb.append("isdone=").append(HttpClientRetrieveFileTransfer.this.done).append(";");
                    sb.append("bytesReceived=").append(HttpClientRetrieveFileTransfer.this.bytesReceived).append("]");
                    return sb.toString();
                }

                public void cancel() {
                    HttpClientRetrieveFileTransfer.this.hardClose();
                }

                public IIncomingFileTransfer receive(OutputStream streamToStore) throws IOException {
                    HttpClientRetrieveFileTransfer.this.setOutputStream(streamToStore);
                    HttpClientRetrieveFileTransfer.this.setCloseOutputStream(false);
                    HttpClientRetrieveFileTransfer.this.job = (Job)new AbstractRetrieveFileTransfer.FileTransferJob((AbstractRetrieveFileTransfer)HttpClientRetrieveFileTransfer.this, HttpClientRetrieveFileTransfer.this.getRemoteFileURL().toString());
                    HttpClientRetrieveFileTransfer.this.job.schedule();
                    return HttpClientRetrieveFileTransfer.this;
                }
            });
        }
        catch (Exception e) {
            throw new IncomingFileTransferException("Could not connect to " + urlString, (Throwable)e);
        }
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
        this.fileRequestConnectContext = connectContext;
        this.username = null;
        this.password = null;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    protected static String getHostFromURL(String url) {
        String result = url;
        int colonSlashSlash = url.indexOf("://");
        if (colonSlashSlash >= 0) {
            result = url.substring(colonSlashSlash + 3);
        }
        int colonPort = result.indexOf(58);
        int requestPath = result.indexOf(47);
        int substringEnd = colonPort > 0 && requestPath > 0 ? Math.min(colonPort, requestPath) : (colonPort > 0 ? colonPort : (requestPath > 0 ? requestPath : result.length()));
        return result.substring(0, substringEnd);
    }

    protected static int getPortFromURL(String url) {
        int colonSlashSlash = url.indexOf("://");
        int colonPort = url.indexOf(58, colonSlashSlash + 1);
        if (colonPort < 0) {
            return HttpClientRetrieveFileTransfer.urlUsesHttps(url) ? 443 : 80;
        }
        int requestPath = url.indexOf(47, colonPort + 1);
        int end = requestPath < 0 ? url.length() : requestPath;
        return Integer.parseInt(url.substring(colonPort + 1, end));
    }

    protected static boolean urlUsesHttps(String url) {
        return url.matches(String.valueOf(HTTPS) + ".*");
    }

    public static boolean supportsProtocol(String protocolString) {
        int i = 0;
        while (i < supportedProtocols.length) {
            if (supportedProtocols[i].equalsIgnoreCase(protocolString)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ID getID() {
        return new FileTransferID(this.getRetrieveNamespace(), this.getRemoteFileURL());
    }
}

