/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.health;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.edc.connector.core.health.HealthCheckServiceConfiguration;
import org.eclipse.edc.spi.system.ExecutorInstrumentation;
import org.eclipse.edc.spi.system.health.HealthCheckResult;
import org.eclipse.edc.spi.system.health.HealthCheckService;
import org.eclipse.edc.spi.system.health.HealthStatus;
import org.eclipse.edc.spi.system.health.LivenessProvider;
import org.eclipse.edc.spi.system.health.ReadinessProvider;
import org.eclipse.edc.spi.system.health.StartupStatusProvider;

public class HealthCheckServiceImpl
implements HealthCheckService {
    private final List<LivenessProvider> livenessProviders;
    private final List<ReadinessProvider> readinessProviders;
    private final List<StartupStatusProvider> startupStatusProviders;
    private final Map<LivenessProvider, HealthCheckResult> cachedLivenessResults;
    private final Map<ReadinessProvider, HealthCheckResult> cachedReadinessResults;
    private final Map<StartupStatusProvider, HealthCheckResult> cachedStartupStatus;
    private final ScheduledExecutorService executor;
    private final HealthCheckServiceConfiguration configuration;

    public HealthCheckServiceImpl(HealthCheckServiceConfiguration configuration, ExecutorInstrumentation executorInstrumentation) {
        this.configuration = configuration;
        this.readinessProviders = new CopyOnWriteArrayList<ReadinessProvider>();
        this.livenessProviders = new CopyOnWriteArrayList<LivenessProvider>();
        this.startupStatusProviders = new CopyOnWriteArrayList<StartupStatusProvider>();
        this.cachedLivenessResults = new ConcurrentHashMap<LivenessProvider, HealthCheckResult>();
        this.cachedReadinessResults = new ConcurrentHashMap<ReadinessProvider, HealthCheckResult>();
        this.cachedStartupStatus = new ConcurrentHashMap<StartupStatusProvider, HealthCheckResult>();
        this.executor = executorInstrumentation.instrument(Executors.newScheduledThreadPool(configuration.getThreadPoolSize()), HealthCheckService.class.getSimpleName());
    }

    public void addLivenessProvider(LivenessProvider provider) {
        this.livenessProviders.add(provider);
    }

    public void addReadinessProvider(ReadinessProvider provider) {
        this.readinessProviders.add(provider);
    }

    public void addStartupStatusProvider(StartupStatusProvider provider) {
        this.startupStatusProviders.add(provider);
    }

    public HealthStatus isLive() {
        return new HealthStatus(this.cachedLivenessResults.values());
    }

    public HealthStatus isReady() {
        return new HealthStatus(this.cachedReadinessResults.values());
    }

    public HealthStatus getStartupStatus() {
        return new HealthStatus(this.cachedStartupStatus.values());
    }

    public void refresh() {
        this.executor.execute(this::queryReadiness);
        this.executor.execute(this::queryLiveness);
        this.executor.execute(this::queryStartupStatus);
    }

    public void stop() {
        if (!this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
    }

    public void start() {
        this.executor.scheduleAtFixedRate(this::queryReadiness, 0L, this.configuration.getReadinessPeriod().toMillis(), TimeUnit.MILLISECONDS);
        this.executor.scheduleAtFixedRate(this::queryLiveness, 0L, this.configuration.getLivenessPeriod().toMillis(), TimeUnit.MILLISECONDS);
        this.executor.scheduleAtFixedRate(this::queryStartupStatus, 0L, this.configuration.getStartupStatusPeriod().toMillis(), TimeUnit.MILLISECONDS);
    }

    private void queryReadiness() {
        this.readinessProviders.parallelStream().forEach(provider -> this.updateCache((Supplier)provider, (Map)this.cachedReadinessResults));
    }

    private void queryLiveness() {
        this.livenessProviders.parallelStream().forEach(provider -> this.updateCache((Supplier)provider, (Map)this.cachedLivenessResults));
    }

    private void queryStartupStatus() {
        this.startupStatusProviders.parallelStream().forEach(provider -> this.updateCache((Supplier)provider, (Map)this.cachedStartupStatus));
    }

    private <T extends Supplier<HealthCheckResult>> void updateCache(T provider, Map<T, HealthCheckResult> cache) {
        try {
            cache.put(provider, provider.get());
        }
        catch (Exception ex) {
            cache.put(provider, HealthCheckResult.failed((String[])new String[]{ex.getMessage()}));
        }
    }
}

