/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.base;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.jetbrains.annotations.NotNull;

public class OkHttpClientFactory {
    @Setting(value="If true, enable HTTPS call enforcement. Default value is 'false'", type="boolean")
    public static final String EDC_HTTP_ENFORCE_HTTPS = "edc.http.enforce-https";

    @NotNull
    public static OkHttpClient create(ServiceExtensionContext context, EventListener okHttpEventListener) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS);
        Optional.ofNullable(okHttpEventListener).ifPresent(arg_0 -> ((OkHttpClient.Builder)builder).eventListener(arg_0));
        boolean enforceHttps = context.getSetting(EDC_HTTP_ENFORCE_HTTPS, false);
        if (enforceHttps) {
            builder.addInterceptor((Interceptor)new EnforceHttps());
        } else {
            context.getMonitor().info("HTTPS enforcement it not enabled, please enable it in a production environment", new Throwable[0]);
        }
        return builder.build();
    }

    private static class EnforceHttps
    implements Interceptor {
        private EnforceHttps() {
        }

        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            if (!request.isHttps()) {
                throw new EdcException(String.format("HTTP call to %s blocked due to HTTPS enforcement enabled", request.url()));
            }
            return chain.proceed(request);
        }
    }
}

