/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.eclipse.edc.spi.event.Event;
import org.eclipse.edc.spi.event.EventRouter;
import org.eclipse.edc.spi.event.EventSubscriber;
import org.eclipse.edc.spi.monitor.Monitor;

public class EventRouterImpl
implements EventRouter {
    private final List<EventSubscriber> subscribers = new ArrayList<EventSubscriber>();
    private final List<EventSubscriber> syncSubscribers = new ArrayList<EventSubscriber>();
    private final Monitor monitor;
    private final ExecutorService executor;

    public EventRouterImpl(Monitor monitor, ExecutorService executor) {
        this.monitor = monitor;
        this.executor = executor;
    }

    public void registerSync(EventSubscriber subscriber) {
        this.syncSubscribers.add(subscriber);
    }

    public void register(EventSubscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    public void publish(Event event) {
        this.syncSubscribers.forEach(subscriber -> subscriber.on(event));
        this.subscribers.stream().map(subscriber -> CompletableFuture.runAsync(() -> subscriber.on(event), this.executor).thenApply(v -> subscriber)).forEach(future -> future.whenComplete((subscriber, throwable) -> {
            if (throwable != null) {
                String subscriberName = subscriber.getClass().getSimpleName();
                String eventName = event.getClass().getSimpleName();
                this.monitor.severe(String.format("Subscriber %s failed to handle event %s", subscriberName, eventName), new Throwable[]{throwable});
            }
        }));
    }
}

