/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.security;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.util.Optional;
import java.util.function.Function;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.eclipse.edc.spi.EdcException;

public class DefaultPrivateKeyParseFunction
implements Function<String, PrivateKey> {
    @Override
    public PrivateKey apply(String encoded) {
        PEMParser pemParser = new PEMParser((Reader)new StringReader(encoded));
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        try {
            Object o = pemParser.readObject();
            if (o instanceof PEMKeyPair) {
                PEMKeyPair keyPair = (PEMKeyPair)o;
                return converter.getKeyPair(keyPair).getPrivate();
            }
            if (o instanceof PrivateKeyInfo) {
                PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)o);
                return converter.getPrivateKey(privateKeyInfo);
            }
            throw new EdcException(Optional.ofNullable(o).map(obj -> "Invalid object type: " + obj.getClass()).orElse("Object cannot be null"));
        }
        catch (IOException e) {
            throw new EdcException((Throwable)e);
        }
    }
}

