# Notices for Eclipse Dataspace Connector

This content is produced and maintained by the Eclipse Dash, Tools for
Committers project.

* Project home: https://projects.eclipse.org/projects/technology.dataspaceconnector

## Trademarks

Eclipse Dataspace Connector and the Eclipse Dataspace Connector logo are trademarks of the Eclipse Foundation.
Eclipse and the Eclipse Logo are registered trademarks of the Eclipse Foundation.

## Copyright

All content is the property of the respective authors or their employers. For more information regarding authorship of content, please consult the listed source code repository logs.

## Declared Project Licenses

This program and the accompanying materials are made available under the terms of the Apache License, Version 2.0 which is available at https://www.apache.org/licenses/LICENSE-2.0.

SPDX-License-Identifier: Apache-2.0

## Source Code

The project maintains the following source code repositoriy:

* https://github.com/eclipse-dataspaceconnector/DataSpaceConnector

## Third-party Content (Overarching All Modules)

Atomikos Util
* Project: https://www.atomikos.com/Main/WebHome
* Source: scm:git@github.com:atomikos/transactions-essentials.git
* Maven Artifact: com.atomikos/atomikos-util/5.0.8
* License: Apache-2.0

Atomikos Transactions API
* Project: https://www.atomikos.com/Main/WebHome
* Source: scm:git@github.com:atomikos/transactions-essentials.git
* Maven Artifact: com.atomikos/transactions-api/5.0.8
* License: Apache-2.0

Atomikos Transactions JDBC
* Project: https://www.atomikos.com/Main/WebHome
* Source: scm:git@github.com:atomikos/transactions-essentials.git
* Maven Artifact: com.atomikos/transactions-jdbc/5.0.8
* License: Apache-2.0

Atomikos Transactions JTA
* Project: https://www.atomikos.com/Main/WebHome
* Source: scm:git@github.com:atomikos/transactions-essentials.git
* Maven Artifact: com.atomikos/transactions-jta/5.0.8
* License: Apache-2.0

Atomikos Transactions Core
* Project: https://www.atomikos.com/Main/WebHome
* Source: scm:git@github.com:atomikos/transactions-essentials.git
* Maven Artifact: com.atomikos/transactions/5.0.8
* License: Apache-2.0

java jwt
* Project: https://github.com/auth0/java-jwt
* Source: scm:git@github.com:auth0/java-jwt.git
* Maven Artifact: com.auth0/java-jwt/3.13.0
* License: MIT

Microsoft Azure SDK for App Platform Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-appplatform/2.12.0
* License: MIT

Microsoft Azure SDK for App Service Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-appservice/2.12.0
* License: MIT

Microsoft Azure SDK for Authorization Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-authorization/2.12.0
* License: MIT

Microsoft Azure SDK for CDN Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-cdn/2.12.0
* License: MIT

Microsoft Azure SDK for Compute Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-compute/2.12.0
* License: MIT

Microsoft Azure SDK for Container Instance Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-containerinstance/2.12.0
* License: MIT

Microsoft Azure SDK for Container Registry Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-containerregistry/2.12.0
* License: MIT

Microsoft Azure SDK for Container Service Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-containerservice/2.12.0
* License: MIT

Microsoft Azure SDK for CosmosDB Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-cosmos/2.12.0
* License: MIT

Microsoft Azure SDK for DataFactory Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-datafactory/1.0.0-beta.12
* License: MIT

Microsoft Azure SDK for DNS Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-dns/2.12.0
* License: MIT

Microsoft Azure SDK for EventHubs Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-eventhubs/2.12.0
* License: MIT

Microsoft Azure SDK for Key Vault Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-keyvault/2.12.0
* License: MIT

Microsoft Azure SDK for Monitor Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-monitor/2.12.0
* License: MIT

Microsoft Azure SDK for Managed Service Identity (MSI) Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-msi/2.12.0
* License: MIT

Microsoft Azure SDK for Network Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-network/2.12.0
* License: MIT

Microsoft Azure SDK for Private DNS Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-privatedns/2.12.0
* License: MIT

Microsoft Azure SDK for Redis Cache Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-redis/2.12.0
* License: MIT

Microsoft Azure SDK for Resource Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-resources/2.12.0
* License: MIT

Microsoft Azure SDK for Cognitive Search Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-search/2.12.0
* License: MIT

Microsoft Azure SDK for ServiceBus Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-servicebus/2.12.0
* License: MIT

Microsoft Azure SDK for Sql Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-sql/2.12.0
* License: MIT

Microsoft Azure SDK for Storage Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-storage/2.12.0
* License: MIT

Microsoft Azure SDK for Traffic Manager Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager-trafficmanager/2.12.0
* License: MIT

Microsoft Azure SDK for Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure.resourcemanager/azure-resourcemanager/2.12.0
* License: MIT

Microsoft Azure Netty HTTP Client Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core-http-netty/1.10.0
* License: MIT

Microsoft Azure Netty HTTP Client Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core-http-netty/1.11.2
* License: MIT

Microsoft Azure Netty HTTP Client Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core-http-netty/1.11.7
* License: MIT

Microsoft Azure Netty HTTP Client Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core-http-netty/1.11.8
* License: MIT

Microsoft Azure Netty HTTP Client Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core-http-netty/1.6.3
* License: MIT

Microsoft Azure Management Java Core Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core-management/1.5.2
* License: MIT

Microsoft Azure Java Core Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core/1.10.0
* License: MIT

Microsoft Azure Java Core Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core/1.17.0
* License: MIT

Microsoft Azure Java Core Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core/1.22.0
* License: MIT

Microsoft Azure Java Core Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core/1.25.0
* License: MIT

Microsoft Azure Java Core Library
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:https://github.com/Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-core/1.26.0
* License: MIT

Microsoft Azure SDK for SQL API of Azure Cosmos DB Service
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-cosmos/4.26.0
* License: MIT

Microsoft Azure client library for Identity
* Project: https://github.com/Azure/azure-sdk-for-java
* Maven Artifact: com.azure/azure-identity/1.4.6
* License: MIT

Microsoft Azure SDK for eventgrid
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-messaging-eventgrid/4.4.0
* License: MIT

Microsoft Azure client library for KeyVault Keys
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-security-keyvault-keys/4.3.7
* License: MIT

Microsoft Azure client library for KeyVault Secrets
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-security-keyvault-secrets/4.2.3
* License: MIT

Microsoft Azure client library for KeyVault Secrets
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-security-keyvault-secrets/4.3.7
* License: MIT

Microsoft Azure client library for Blob Storage
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-storage-blob/12.14.2
* License: MIT

Microsoft Azure common module for Storage
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-storage-common/12.14.1
* License: MIT

Microsoft Azure common module for Storage
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-storage-common/12.14.3
* License: MIT

Microsoft Azure client library for File Share Storage
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-storage-file-share/12.11.4
* License: MIT

Microsoft Azure internal Avro module for Storage
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.azure/azure-storage-internal-avro/12.1.2
* License: MIT

Internet Time Utility
* Project: https://github.com/ethlo/itu
* Source: scm:git:git@github.com:ethlo/itu.git
* Maven Artifact: com.ethlo.time/itu/1.7.0
* License: Apache-2.0

Jackson-annotations
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-annotations.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-annotations/2.11.2
* License: Apache-2.0

Jackson-annotations
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-annotations.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-annotations/2.12.1
* License: Apache-2.0

Jackson-annotations
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-annotations.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-annotations/2.12.3
* License: Apache-2.0

Jackson-annotations
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-annotations.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-annotations/2.12.5
* License: Apache-2.0

Jackson-annotations
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-annotations.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-annotations/2.13.0
* License: Apache-2.0

Jackson-annotations
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-annotations.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-annotations/2.13.1
* License: Apache-2.0

Jackson-annotations
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-annotations.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-annotations/2.13.2
* License: Apache-2.0

Jackson-annotations
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-annotations.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-annotations/2.13.3
* License: Apache-2.0

Jackson-core
* Project: https://github.com/FasterXML/jackson-core
* Source: scm:git:git@github.com:FasterXML/jackson-core.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-core/2.12.1
* License: Apache-2.0

Jackson-core
* Project: https://github.com/FasterXML/jackson-core
* Source: scm:git:git@github.com:FasterXML/jackson-core.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-core/2.12.3
* License: Apache-2.0

Jackson-core
* Project: https://github.com/FasterXML/jackson-core
* Source: scm:git:git@github.com:FasterXML/jackson-core.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-core/2.12.5
* License: Apache-2.0

Jackson-core
* Project: https://github.com/FasterXML/jackson-core
* Source: scm:git:git@github.com:FasterXML/jackson-core.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-core/2.13.1
* License: Apache-2.0

Jackson-core
* Project: https://github.com/FasterXML/jackson-core
* Source: scm:git:git@github.com:FasterXML/jackson-core.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-core/2.13.3
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.11.0
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.12.1
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.12.3
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.12.5
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.13.0
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.13.1
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.13.2.2
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.13.3
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.9.8
* License: Apache-2.0

jackson-databind
* Project: http://github.com/FasterXML/jackson
* Source: scm:git:git@github.com:FasterXML/jackson-databind.git
* Maven Artifact: com.fasterxml.jackson.core/jackson-databind/2.9.9
* License: Apache-2.0

Jackson-dataformat-XML
* Project: https://github.com/FasterXML/jackson-dataformat-xml
* Source: scm:git:git@github.com:FasterXML/jackson-dataformat-xml.git
* Maven Artifact: com.fasterxml.jackson.dataformat/jackson-dataformat-xml/2.12.3
* License: Apache-2.0

Jackson-dataformat-XML
* Project: https://github.com/FasterXML/jackson-dataformat-xml
* Source: scm:git:git@github.com:FasterXML/jackson-dataformat-xml.git
* Maven Artifact: com.fasterxml.jackson.dataformat/jackson-dataformat-xml/2.12.5
* License: Apache-2.0

Jackson-dataformat-XML
* Project: https://github.com/FasterXML/jackson-dataformat-xml
* Source: scm:git:git@github.com:FasterXML/jackson-dataformat-xml.git
* Maven Artifact: com.fasterxml.jackson.dataformat/jackson-dataformat-xml/2.13.1
* License: Apache-2.0

Jackson-dataformat-XML
* Project: https://github.com/FasterXML/jackson-dataformat-xml
* Source: scm:git:git@github.com:FasterXML/jackson-dataformat-xml.git
* Maven Artifact: com.fasterxml.jackson.dataformat/jackson-dataformat-xml/2.13.3
* License: Apache-2.0

Jackson-dataformat-YAML
* Project: https://github.com/FasterXML/jackson-dataformats-text
* Maven Artifact: com.fasterxml.jackson.dataformat/jackson-dataformat-yaml/2.12.1
* License: Apache-2.0

Jackson-dataformat-YAML
* Project: https://github.com/FasterXML/jackson-dataformats-text
* Maven Artifact: com.fasterxml.jackson.dataformat/jackson-dataformat-yaml/2.13.2
* License: Apache-2.0

Jackson-dataformat-YAML
* Project: https://github.com/FasterXML/jackson-dataformats-text
* Maven Artifact: com.fasterxml.jackson.dataformat/jackson-dataformat-yaml/2.13.3
* License: Apache-2.0

Jackson-datatype-Joda
* Project: http://wiki.fasterxml.com/JacksonModuleJoda
* Source: scm:git:git@github.com:FasterXML/jackson-datatype-joda.git
* Maven Artifact: com.fasterxml.jackson.datatype/jackson-datatype-joda/2.10.5
* License: Apache-2.0

Jackson datatype: Joda
* Project: https://github.com/FasterXML/jackson-datatype-joda
* Source: scm:git:git@github.com:FasterXML/jackson-datatype-joda.git
* Maven Artifact: com.fasterxml.jackson.datatype/jackson-datatype-joda/2.13.3
* License: Apache-2.0

Jackson datatype: JSR310
* Maven Artifact: com.fasterxml.jackson.datatype/jackson-datatype-jsr310/2.12.1
* License: Apache-2.0

Jackson datatype: JSR310
* Maven Artifact: com.fasterxml.jackson.datatype/jackson-datatype-jsr310/2.12.3
* License: Apache-2.0

Jackson datatype: JSR310
* Maven Artifact: com.fasterxml.jackson.datatype/jackson-datatype-jsr310/2.12.5
* License: Apache-2.0

Jackson datatype: JSR310
* Maven Artifact: com.fasterxml.jackson.datatype/jackson-datatype-jsr310/2.13.1
* License: Apache-2.0

Jackson datatype: JSR310
* Maven Artifact: com.fasterxml.jackson.datatype/jackson-datatype-jsr310/2.13.3
* License: Apache-2.0

Jackson module: Afterburner
* Project: https://github.com/FasterXML/jackson-modules-base
* Maven Artifact: com.fasterxml.jackson.module/jackson-module-afterburner/2.12.5
* License: Apache-2.0

Jackson module: Afterburner
* Project: https://github.com/FasterXML/jackson-modules-base
* Maven Artifact: com.fasterxml.jackson.module/jackson-module-afterburner/2.13.3
* License: Apache-2.0

Jackson module: Jakarta XML Bind Annotations (jakarta.xml.bind)
* Project: https://github.com/FasterXML/jackson-modules-base
* Maven Artifact: com.fasterxml.jackson.module/jackson-module-jakarta-xmlbind-annotations/2.13.0
* License: Apache-2.0

Jackson module: Jakarta XML Bind Annotations (jakarta.xml.bind)
* Project: https://github.com/FasterXML/jackson-modules-base
* Maven Artifact: com.fasterxml.jackson.module/jackson-module-jakarta-xmlbind-annotations/2.13.3
* License: Apache-2.0

Jackson BOM
* Project: https://github.com/FasterXML/jackson-bom
* Source: scm:git:git@github.com:FasterXML/jackson-bom.git
* Maven Artifact: com.fasterxml.jackson/jackson-bom/2.12.1
* License: Apache-2.0

Jackson BOM
* Project: https://github.com/FasterXML/jackson-bom
* Source: scm:git:git@github.com:FasterXML/jackson-bom.git
* Maven Artifact: com.fasterxml.jackson/jackson-bom/2.13.3
* License: Apache-2.0

Java UUID Generator
* Project: https://github.com/cowtowncoder/java-uuid-generator
* Source: scm:git:git://github.com/cowtowncoder/java-uuid-generator.git
* Maven Artifact: com.fasterxml.uuid/java-uuid-generator/4.0.1
* License: Apache-2.0

Woodstox
* Project: https://github.com/FasterXML/woodstox
* Source: scm:git:git@github.com:FasterXML/woodstox.git
* Maven Artifact: com.fasterxml.woodstox/woodstox-core/6.2.7
* License: Apache-2.0

ClassMate
* Project: https://github.com/FasterXML/java-classmate
* Source: scm:git:git@github.com:FasterXML/java-classmate.git
* Maven Artifact: com.fasterxml/classmate/1.5.1
* License: Apache-2.0

Caffeine cache
* Project: https://github.com/ben-manes/caffeine
* Source: scm:git:https://github.com/ben-manes/caffeine.git
* Maven Artifact: com.github.ben-manes.caffeine/caffeine/2.9.3
* License: Apache-2.0

JSON.simple
* Project: https://cliftonlabs.github.io/json-simple/
* Source: scm:git:https://github.com/cliftonlabs/json-simple.git
* Maven Artifact: com.github.cliftonlabs/json-simple/3.0.2
* License: Apache-2.0

btf
* Project: https://github.com/java-json-tools/btf
* Source: git@github.com:java-json-tools/btf.git
* Maven Artifact: com.github.java-json-tools/btf/1.3
* License: Apache-2.0

jackson-coreutils-equivalence
* Project: https://github.com/java-json-tools/jackson-coreutils
* Source: git@github.com:java-json-tools/jackson-coreutils.git
* Maven Artifact: com.github.java-json-tools/jackson-coreutils-equivalence/1.0
* License: Apache-2.0

jackson-coreutils
* Project: https://github.com/java-json-tools/jackson-coreutils
* Source: git@github.com:java-json-tools/jackson-coreutils.git
* Maven Artifact: com.github.java-json-tools/jackson-coreutils/2.0
* License: Apache-2.0

json-patch
* Project: https://github.com/java-json-tools/json-patch
* Source: git@github.com:java-json-tools/json-patch.git
* Maven Artifact: com.github.java-json-tools/json-patch/1.13
* License: Apache-2.0

json-schema-core
* Project: https://github.com/java-json-tools/json-schema-core
* Source: git@github.com:java-json-tools/json-schema-core.git
* Maven Artifact: com.github.java-json-tools/json-schema-core/1.2.14
* License: Apache-2.0

json-schema-validator
* Project: https://github.com/java-json-tools/json-schema-validator
* Source: git@github.com:java-json-tools/json-schema-validator.git
* Maven Artifact: com.github.java-json-tools/json-schema-validator/2.2.14
* License: Apache-2.0

msg-simple
* Project: https://github.com/java-json-tools/msg-simple
* Source: git@github.com:java-json-tools/msg-simple.git
* Maven Artifact: com.github.java-json-tools/msg-simple/1.2
* License: Apache-2.0

uri-template
* Project: https://github.com/java-json-tools/uri-template
* Source: git@github.com:java-json-tools/uri-template.git
* Maven Artifact: com.github.java-json-tools/uri-template/0.10
* License: Apache-2.0

scopt
* Project: https://github.com/scopt/scopt
* Source: https://github.com/scopt/scopt.git
* Maven Artifact: com.github.scopt/scopt_2.13/3.7.1
* License: MIT

JCIP Annotations under Apache License
* Project: http://stephenc.github.com/jcip-annotations
* Source: scm:git:git://github.com/stephenc/jcip-annotations.git
* Maven Artifact: com.github.stephenc.jcip/jcip-annotations/1.0-1
* License: Apache-2.0

FindBugs-jsr305
* Project: http://findbugs.sourceforge.net/
* Source: scm:svn:http://findbugs.googlecode.com/svn/trunk/
* Maven Artifact: com.google.code.findbugs/jsr305/2.0.1
* License: BSD-3-Clause

FindBugs-jsr305
* Project: http://findbugs.sourceforge.net/
* Source: scm:git:https://code.google.com/p/jsr-305/
* Maven Artifact: com.google.code.findbugs/jsr305/3.0.2
* License: Apache-2.0

error-prone annotations
* Maven Artifact: com.google.errorprone/error_prone_annotations/2.10.0
* License: Apache-2.0

error-prone annotations
* Maven Artifact: com.google.errorprone/error_prone_annotations/2.11.0
* License: Apache-2.0

error-prone annotations
* Maven Artifact: com.google.errorprone/error_prone_annotations/2.5.1
* License: Apache-2.0

Guava InternalFutureFailureAccess and InternalFutures
* Maven Artifact: com.google.guava/failureaccess/1.0.1
* License: Apache-2.0

Guava: Google Core Libraries for Java
* Maven Artifact: com.google.guava/guava/20.0
* License: Apache-2.0

Guava: Google Core Libraries for Java
* Maven Artifact: com.google.guava/guava/28.1-android
* License: Apache-2.0

Guava: Google Core Libraries for Java
* Maven Artifact: com.google.guava/guava/28.2-android
* License: Apache-2.0

Guava: Google Core Libraries for Java
* Maven Artifact: com.google.guava/guava/30.1.1-jre
* License: Apache-2.0

Guava: Google Core Libraries for Java
* Project: https://github.com/google/guava
* Maven Artifact: com.google.guava/guava/31.0.1-android
* License: Apache-2.0

Guava: Google Core Libraries for Java
* Project: https://github.com/google/guava
* Maven Artifact: com.google.guava/guava/31.1-jre
* License: Apache-2.0

Guava ListenableFuture only
* Maven Artifact: com.google.guava/listenablefuture/9999.0-empty-to-avoid-conflict-with-guava
* License: LicenseRef-NONE

J2ObjC Annotations
* Project: https://github.com/google/j2objc/
* Maven Artifact: com.google.j2objc/j2objc-annotations/1.3
* License: Apache-2.0

Protocol Buffers Core
* Maven Artifact: com.google.protobuf/protobuf-java/3.19.4
* License: BSD-3-Clause

H2 Database Engine
* Project: https://h2database.com
* Source: scm:git:https://github.com/h2database/h2database
* Maven Artifact: com.h2database/h2/2.1.210
* License: EPL-1.0

project ':json-path'
* Project: https://github.com/jayway/JsonPath
* Source: scm:git:git://github.com/jayway/JsonPath.git
* Maven Artifact: com.jayway.jsonpath/json-path/2.4.0
* License: Apache-2.0

project ':json-path'
* Project: https://github.com/jayway/JsonPath
* Source: scm:git:git://github.com/jayway/JsonPath.git
* Maven Artifact: com.jayway.jsonpath/json-path/2.7.0
* License: Apache-2.0

JZlib
* Project: http://www.jcraft.com/jzlib/
* Source: scm:git:git://github.com/ymnk/jzlib.git
* Maven Artifact: com.jcraft/jzlib/1.1.3
* License: BSD-2-Clause

Disruptor Framework
* Project: http://lmax-exchange.github.com/disruptor
* Source: scm:git@github.com:LMAX-Exchange/disruptor.git
* Maven Artifact: com.lmax/disruptor/3.4.4
* License: Apache-2.0

Microsoft Azure SDK annotations
* Project: https://github.com/Microsoft/java-api-annotations
* Source: scm:git:git@github.com:Microsoft/java-api-annotations.git
* Maven Artifact: com.microsoft.azure/azure-annotations/1.10.0
* License: MIT

Azure Java Client Runtime for AutoRest
* Project: https://github.com/Azure/autorest-clientruntime-for-java
* Source: scm:git:git@github.com:Azure/autorest-clientruntime-for-java.git
* Maven Artifact: com.microsoft.azure/azure-client-runtime/1.7.14
* License: MIT

Microsoft Azure SDK for Resource Management
* Project: https://github.com/Azure/azure-sdk-for-java
* Source: scm:git:git@github.com:Azure/azure-sdk-for-java.git
* Maven Artifact: com.microsoft.azure/azure-mgmt-resources/1.41.4
* License: MIT

msal4j-persistence-extension
* Project: https://github.com/AzureAD/microsoft-authentication-extensions-for-java
* Maven Artifact: com.microsoft.azure/msal4j-persistence-extension/1.1.0
* License: MIT

msal4j
* Project: https://github.com/AzureAD/microsoft-authentication-library-for-java
* Maven Artifact: com.microsoft.azure/msal4j/1.11.0
* License: MIT

msal4j
* Project: https://github.com/AzureAD/microsoft-authentication-library-for-java
* Maven Artifact: com.microsoft.azure/msal4j/1.4.0
* License: MIT

Java Client Runtime for AutoRest
* Project: https://github.com/Azure/autorest-clientruntime-for-java
* Source: scm:git:git@github.com:Azure/autorest-clientruntime-for-java.git
* Maven Artifact: com.microsoft.rest/client-runtime/1.7.14
* License: MIT

JsonSchemaValidator
* Project: https://github.com/networknt/json-schema-validator
* Source: scm:git://github.com:networknt/json-schema-validator.git
* Maven Artifact: com.networknt/json-schema-validator/1.0.72
* License: Apache-2.0

Nimbus Content Type
* Project: https://bitbucket.org/connect2id/nimbus-content-type
* Source: scm:git:https://bitbucket.org/connect2id/nimbus-content-type.git
* Maven Artifact: com.nimbusds/content-type/2.1
* License: Apache-2.0

Nimbus LangTag
* Project: https://bitbucket.org/connect2id/nimbus-language-tags
* Source: scm:git:https://bitbucket.org/connect2id/nimbus-language-tags.git
* Maven Artifact: com.nimbusds/lang-tag/1.5
* License: Apache-2.0

Nimbus JOSE+JWT
* Project: https://bitbucket.org/connect2id/nimbus-jose-jwt
* Source: scm:git:https://bitbucket.org/connect2id/nimbus-jose-jwt.git
* Maven Artifact: com.nimbusds/nimbus-jose-jwt/8.23
* License: Apache-2.0

Nimbus JOSE+JWT
* Project: https://bitbucket.org/connect2id/nimbus-jose-jwt
* Source: scm:git:https://bitbucket.org/connect2id/nimbus-jose-jwt.git
* Maven Artifact: com.nimbusds/nimbus-jose-jwt/9.24.2
* License: Apache-2.0

Nimbus JOSE+JWT
* Project: https://bitbucket.org/connect2id/nimbus-jose-jwt
* Source: scm:git:https://bitbucket.org/connect2id/nimbus-jose-jwt.git
* Maven Artifact: com.nimbusds/nimbus-jose-jwt/9.9.3
* License: Apache-2.0

OAuth 2.0 SDK with OpenID Connect extensions
* Project: https://bitbucket.org/connect2id/oauth-2.0-sdk-with-openid-connect-extensions
* Source: scm:git:https://bitbucket.org/connect2id/oauth-2.0-sdk-with-openid-connect-extensions.git
* Maven Artifact: com.nimbusds/oauth2-oidc-sdk/9.7
* License: Apache-2.0

checkstyle
* Project: https://checkstyle.org/
* Source: scm:git:git@github.com:checkstyle/checkstyle.git
* Maven Artifact: com.puppycrawl.tools/checkstyle/9.0
* License: Apache-2.0

jmustache
* Project: http://github.com/samskivert/jmustache
* Source: scm:git:git://github.com/samskivert/jmustache.git
* Maven Artifact: com.samskivert/jmustache/1.15
* License: BSD-2-Clause

quicklens
* Project: http://softwaremill.com/open-source
* Source: scm:git:https://github.com/softwaremill/quicklens.git
* Maven Artifact: com.softwaremill.quicklens/quicklens_2.13/1.8.2
* License: Apache-2.0

OkHttp Logging Interceptor
* Maven Artifact: com.squareup.okhttp3/logging-interceptor/3.12.12
* License: Apache-2.0

okhttp-dnsoverhttps
* Project: https://square.github.io/okhttp/
* Source: scm:git:https://github.com/square/okhttp.git
* Maven Artifact: com.squareup.okhttp3/okhttp-dnsoverhttps/4.10.0
* License: Apache-2.0

OkHttp URLConnection
* Maven Artifact: com.squareup.okhttp3/okhttp-urlconnection/3.12.12
* License: Apache-2.0

OkHttp
* Maven Artifact: com.squareup.okhttp3/okhttp/3.12.0
* License: Apache-2.0

OkHttp
* Maven Artifact: com.squareup.okhttp3/okhttp/3.12.12
* License: Apache-2.0

okhttp
* Project: https://square.github.io/okhttp/
* Source: scm:git:https://github.com/square/okhttp.git
* Maven Artifact: com.squareup.okhttp3/okhttp/4.10.0
* License: Apache-2.0

okio
* Project: https://github.com/square/okio/
* Source: scm:git:git://github.com/square/okio.git
* Maven Artifact: com.squareup.okio/okio-jvm/3.0.0
* License: Apache-2.0

Okio
* Maven Artifact: com.squareup.okio/okio/1.15.0
* License: Apache-2.0

okio
* Project: https://github.com/square/okio/
* Source: scm:git:git://github.com/square/okio.git
* Maven Artifact: com.squareup.okio/okio/3.0.0
* License: Apache-2.0

Adapter: RxJava
* Maven Artifact: com.squareup.retrofit2/adapter-rxjava/2.6.4
* License: Apache-2.0

Converter: Jackson
* Maven Artifact: com.squareup.retrofit2/converter-jackson/2.6.4
* License: Apache-2.0

Retrofit
* Maven Artifact: com.squareup.retrofit2/retrofit/2.6.4
* License: Apache-2.0

Jakarta Activation
* Maven Artifact: com.sun.activation/jakarta.activation/2.0.0
* License: EPL-2.0

Jakarta Activation
* Maven Artifact: com.sun.activation/jakarta.activation/2.0.1
* License: EPL-2.0

JavaMail API (no providers)
* Maven Artifact: com.sun.mail/mailapi/1.6.2
* License: CDDL-1.1

Old JAXB Core
* Project: https://eclipse-ee4j.github.io/jaxb-ri/
* Maven Artifact: com.sun.xml.bind/jaxb-core/4.0.0
* License: BSD-3-Clause

Old JAXB Runtime
* Project: https://eclipse-ee4j.github.io/jaxb-ri/
* Maven Artifact: com.sun.xml.bind/jaxb-impl/4.0.0
* License: BSD-3-Clause

T-Digest
* Project: https://github.com/tdunning/t-digest
* Source: scm:git:https://github.com/tdunning/t-digest.git
* Maven Artifact: com.tdunning/t-digest/3.1
* License: Apache-2.0

akka-actor
* Project: https://akka.io/
* Source: scm:git:https://github.com/akka/akka.git
* Maven Artifact: com.typesafe.akka/akka-actor_2.13/2.6.18
* License: Apache-2.0

akka-slf4j
* Project: https://akka.io/
* Source: scm:git:https://github.com/akka/akka.git
* Maven Artifact: com.typesafe.akka/akka-slf4j_2.13/2.6.18
* License: Apache-2.0

Netty Reactive Streams HTTP support
* Maven Artifact: com.typesafe.netty/netty-reactive-streams-http/2.0.4
* License: Apache-2.0

Netty Reactive Streams Implementation
* Maven Artifact: com.typesafe.netty/netty-reactive-streams/2.0.4
* License: Apache-2.0

scala-logging
* Project: https://github.com/lightbend/scala-logging
* Source: scm:git:git@github.com:lightbend/scala-logging.git
* Maven Artifact: com.typesafe.scala-logging/scala-logging_2.13/3.9.4
* License: Apache-2.0

config
* Project: https://github.com/lightbend/config
* Source: scm:git@github.com:lightbend/config.git
* Maven Artifact: com.typesafe/config/1.4.0
* License: Apache-2.0

config
* Project: https://github.com/lightbend/config
* Source: scm:git@github.com:lightbend/config.git
* Maven Artifact: com.typesafe/config/1.4.2
* License: Apache-2.0

Commons BeanUtils
* Project: http://commons.apache.org/beanutils/
* Source: scm:svn:http://svn.apache.org/repos/asf/commons/proper/beanutils/trunk/
* Maven Artifact: commons-beanutils/commons-beanutils/1.8.3
* License: Apache-2.0

Apache Commons BeanUtils
* Project: https://commons.apache.org/proper/commons-beanutils/
* Source: scm:svn:http://svn.apache.org/repos/asf/commons/proper/beanutils/tags/BEANUTILS_1_9_3_RC3
* Maven Artifact: commons-beanutils/commons-beanutils/1.9.4
* License: Apache-2.0

Apache Commons Codec
* Project: http://commons.apache.org/proper/commons-codec/
* Source: scm:svn:http://svn.apache.org/repos/asf/commons/proper/codec/trunk
* Maven Artifact: commons-codec/commons-codec/1.11
* License: Apache-2.0

Apache Commons Codec
* Project: https://commons.apache.org/proper/commons-codec/
* Source: scm:git:https://gitbox.apache.org/repos/asf?p=commons-codec.git
* Maven Artifact: commons-codec/commons-codec/1.14
* License: Apache-2.0

Apache Commons Codec
* Project: https://commons.apache.org/proper/commons-codec/
* Source: scm:git:https://gitbox.apache.org/repos/asf?p=commons-codec.git
* Maven Artifact: commons-codec/commons-codec/1.15
* License: Apache-2.0

Apache Commons Collections
* Project: http://commons.apache.org/collections/
* Source: scm:svn:http://svn.apache.org/repos/asf/commons/proper/collections/trunk
* Maven Artifact: commons-collections/commons-collections/3.2.2
* License: Apache-2.0

Apache Commons IO
* Project: https://commons.apache.org/proper/commons-io/
* Source: scm:git:https://gitbox.apache.org/repos/asf/commons-io.git
* Maven Artifact: commons-io/commons-io/2.11.0
* License: Apache-2.0

Commons Logging
* Project: http://commons.apache.org/logging
* Source: scm:svn:http://svn.apache.org/repos/asf/commons/proper/logging/tags/commons-logging-1.1.1
* Maven Artifact: commons-logging/commons-logging/1.1.1
* License: Apache-2.0

Apache Commons Logging
* Project: http://commons.apache.org/proper/commons-logging/
* Source: scm:svn:http://svn.apache.org/repos/asf/commons/proper/logging/trunk
* Maven Artifact: commons-logging/commons-logging/1.2
* License: Apache-2.0

Failsafe
* Maven Artifact: dev.failsafe/failsafe/3.2.4
* License: Apache-2.0

picocli - a mighty tiny Command Line Interface
* Project: http://picocli.info
* Source: scm:git:https://github.com/remkop/picocli.git
* Maven Artifact: info.picocli/picocli/4.6.1
* License: Apache-2.0

JMESPath Core
* Maven Artifact: io.burt/jmespath-core/0.5.1
* License: BSD-3-Clause

JMESPath Jackson
* Maven Artifact: io.burt/jmespath-jackson/0.5.1
* License: BSD-3-Clause

CloudEvents - API
* Maven Artifact: io.cloudevents/cloudevents-api/2.3.0
* License: Apache-2.0

CloudEvents - Core
* Maven Artifact: io.cloudevents/cloudevents-core/2.3.0
* License: Apache-2.0

CloudEvents - Basic Http Binding
* Maven Artifact: io.cloudevents/cloudevents-http-basic/2.3.0
* License: Apache-2.0

Metrics Core
* Maven Artifact: io.dropwizard.metrics/metrics-core/4.1.0
* License: Apache-2.0

gatling-charts-highcharts
* Project: https://gatling.io
* Source: scm:git:https://github.com/gatling/gatling-highcharts.git
* Maven Artifact: io.gatling.highcharts/gatling-charts-highcharts/3.7.5
* License: Gatling Highcharts

gatling-app
* Project: https://gatling.io
* Source: scm:git:https://github.com/gatling/gatling.git
* Maven Artifact: io.gatling/gatling-app/3.7.5
* License: Apache-2.0

gatling-charts
* Project: https://gatling.io
* Source: scm:git:https://github.com/gatling/gatling.git
* Maven Artifact: io.gatling/gatling-charts/3.7.5
* License: Apache-2.0

gatling-commons-shared-unstable
* Project: https://gatling.io
* Source: scm:git:https://github.com/gatling/gatling.git
* Maven Artifact: io.gatling/gatling-commons-shared-unstable/3.7.5
* License: Apache-2.0

gatling-commons-shared
* Project: https://gatling.io
* Source: scm:git:https://github.com/gatling/gatling.git
* Maven Artifact: io.gatling/gatling-commons-shared/3.7.5
* License: Apache-2.0

gatling-commons
* Project: https://gatling.io
* Source: scm:git:https://github.com/gatling/gatling.git
* Maven Artifact: io.gatling/gatling-commons/3.7.5
* License: Apache-2.0

gatling-core-java
* Project: https://gatling.io
* Source: scm:git:https://github.com/gatling/gatling.git
* Maven Artifact: io.gatling/gatling-core-java/3.7.5
* License: Apache-2.0

gatling-core
* Project: https://gatling.io
* Source: scm:git:https://github.com/gatling/gatling.git
* Maven Artifact: io.gatling/gatling-core/3.7.5
* License: Apache-2.0

gatling-http-client
* Project: https://gatling.io
* Source: scm:git:https://github.com/gatling/gatling.git
* Maven Artifact: io.gatling/gatling-http-client/3.7.5
* License: Apache-2.0

gatling-http-java
* Project: https://gatling.io
* Source: scm:git:https://github.com/gatling/gatling.git
* Maven Artifact: io.gatling/gatling-http-java/3.7.5
* License: Apache-2.0

gatling-http
* Project: https://gatling.io
* Source: scm:git:https://github.com/gatling/gatling.git
* Maven Artifact: io.gatling/gatling-http/3.7.5
* License: Apache-2.0

gatling-jsonpath
* Project: https://gatling.io
* Source: scm:git:https://github.com/gatling/gatling.git
* Maven Artifact: io.gatling/gatling-jsonpath/3.7.5
* License: Apache-2.0

gatling-netty-util
* Project: https://gatling.io
* Source: scm:git:https://github.com/gatling/gatling.git
* Maven Artifact: io.gatling/gatling-netty-util/3.7.5
* License: Apache-2.0

gatling-recorder
* Project: https://gatling.io
* Source: scm:git:https://github.com/gatling/gatling.git
* Maven Artifact: io.gatling/gatling-recorder/3.7.5
* License: Apache-2.0

ClassGraph
* Project: https://github.com/classgraph/classgraph
* Source: scm:git:git@github.com:classgraph/classgraph.git
* Maven Artifact: io.github.classgraph/classgraph/4.8.138
* License: MIT

ClassGraph
* Project: https://github.com/classgraph/classgraph
* Source: scm:git:git@github.com:classgraph/classgraph.git
* Maven Artifact: io.github.classgraph/classgraph/4.8.149
* License: MIT

micrometer-core
* Project: https://github.com/micrometer-metrics/micrometer
* Maven Artifact: io.micrometer/micrometer-core/1.8.1
* License: Apache-2.0

micrometer-core
* Project: https://github.com/micrometer-metrics/micrometer
* Maven Artifact: io.micrometer/micrometer-core/1.8.2
* License: Apache-2.0

Netty/Buffer
* Maven Artifact: io.netty/netty-buffer/4.1.63.Final
* License: Apache-2.0

Netty/Buffer
* Maven Artifact: io.netty/netty-buffer/4.1.65.Final
* License: Apache-2.0

Netty/Buffer
* Maven Artifact: io.netty/netty-buffer/4.1.68.Final
* License: Apache-2.0

Netty/Buffer
* Maven Artifact: io.netty/netty-buffer/4.1.72.Final
* License: Apache-2.0

Netty/Buffer
* Maven Artifact: io.netty/netty-buffer/4.1.73.Final
* License: Apache-2.0

Netty/Buffer
* Maven Artifact: io.netty/netty-buffer/4.1.74.Final
* License: Apache-2.0

Netty/Buffer
* Maven Artifact: io.netty/netty-buffer/4.1.79.Final
* License: Apache-2.0

Netty/Codec/DNS
* Maven Artifact: io.netty/netty-codec-dns/4.1.63.Final
* License: Apache-2.0

Netty/Codec/DNS
* Maven Artifact: io.netty/netty-codec-dns/4.1.68.Final
* License: Apache-2.0

Netty/Codec/DNS
* Maven Artifact: io.netty/netty-codec-dns/4.1.72.Final
* License: Apache-2.0

Netty/Codec/DNS
* Maven Artifact: io.netty/netty-codec-dns/4.1.74.Final
* License: Apache-2.0

Netty/Codec/HTTP
* Maven Artifact: io.netty/netty-codec-http/4.1.43.Final
* License: Apache-2.0

Netty/Codec/HTTP
* Maven Artifact: io.netty/netty-codec-http/4.1.63.Final
* License: Apache-2.0

Netty/Codec/HTTP
* Maven Artifact: io.netty/netty-codec-http/4.1.65.Final
* License: Apache-2.0

Netty/Codec/HTTP
* Maven Artifact: io.netty/netty-codec-http/4.1.68.Final
* License: Apache-2.0

Netty/Codec/HTTP
* Maven Artifact: io.netty/netty-codec-http/4.1.72.Final
* License: Apache-2.0

Netty/Codec/HTTP
* Maven Artifact: io.netty/netty-codec-http/4.1.73.Final
* License: Apache-2.0

Netty/Codec/HTTP
* Maven Artifact: io.netty/netty-codec-http/4.1.74.Final
* License: Apache-2.0

Netty/Codec/HTTP
* Maven Artifact: io.netty/netty-codec-http/4.1.79.Final
* License: Apache-2.0

Netty/Codec/HTTP2
* Maven Artifact: io.netty/netty-codec-http2/4.1.63.Final
* License: Apache-2.0

Netty/Codec/HTTP2
* Maven Artifact: io.netty/netty-codec-http2/4.1.65.Final
* License: Apache-2.0

Netty/Codec/HTTP2
* Maven Artifact: io.netty/netty-codec-http2/4.1.68.Final
* License: Apache-2.0

Netty/Codec/HTTP2
* Maven Artifact: io.netty/netty-codec-http2/4.1.72.Final
* License: Apache-2.0

Netty/Codec/HTTP2
* Maven Artifact: io.netty/netty-codec-http2/4.1.73.Final
* License: Apache-2.0

Netty/Codec/HTTP2
* Maven Artifact: io.netty/netty-codec-http2/4.1.74.Final
* License: Apache-2.0

Netty/Codec/Socks
* Maven Artifact: io.netty/netty-codec-socks/4.1.65.Final
* License: Apache-2.0

Netty/Codec/Socks
* Maven Artifact: io.netty/netty-codec-socks/4.1.68.Final
* License: Apache-2.0

Netty/Codec/Socks
* Maven Artifact: io.netty/netty-codec-socks/4.1.72.Final
* License: Apache-2.0

Netty/Codec/Socks
* Maven Artifact: io.netty/netty-codec-socks/4.1.73.Final
* License: Apache-2.0

Netty/Codec/Socks
* Maven Artifact: io.netty/netty-codec-socks/4.1.74.Final
* License: Apache-2.0

Netty/Codec/Socks
* Maven Artifact: io.netty/netty-codec-socks/4.1.79.Final
* License: Apache-2.0

Netty/Codec
* Maven Artifact: io.netty/netty-codec/4.1.63.Final
* License: Apache-2.0

Netty/Codec
* Maven Artifact: io.netty/netty-codec/4.1.65.Final
* License: Apache-2.0

Netty/Codec
* Maven Artifact: io.netty/netty-codec/4.1.68.Final
* License: Apache-2.0

Netty/Codec
* Maven Artifact: io.netty/netty-codec/4.1.72.Final
* License: Apache-2.0

Netty/Codec
* Maven Artifact: io.netty/netty-codec/4.1.73.Final
* License: Apache-2.0

Netty/Codec
* Maven Artifact: io.netty/netty-codec/4.1.74.Final
* License: Apache-2.0

Netty/Codec
* Maven Artifact: io.netty/netty-codec/4.1.79.Final
* License: Apache-2.0

Netty/Common
* Maven Artifact: io.netty/netty-common/4.1.63.Final
* License: Apache-2.0

Netty/Common
* Maven Artifact: io.netty/netty-common/4.1.65.Final
* License: Apache-2.0

Netty/Common
* Maven Artifact: io.netty/netty-common/4.1.68.Final
* License: Apache-2.0

Netty/Common
* Maven Artifact: io.netty/netty-common/4.1.72.Final
* License: Apache-2.0

Netty/Common
* Maven Artifact: io.netty/netty-common/4.1.73.Final
* License: Apache-2.0

Netty/Common
* Maven Artifact: io.netty/netty-common/4.1.74.Final
* License: Apache-2.0

Netty/Common
* Maven Artifact: io.netty/netty-common/4.1.79.Final
* License: Apache-2.0

Netty/Handler/Proxy
* Maven Artifact: io.netty/netty-handler-proxy/4.1.63.Final
* License: Apache-2.0

Netty/Handler/Proxy
* Maven Artifact: io.netty/netty-handler-proxy/4.1.65.Final
* License: Apache-2.0

Netty/Handler/Proxy
* Maven Artifact: io.netty/netty-handler-proxy/4.1.68.Final
* License: Apache-2.0

Netty/Handler/Proxy
* Maven Artifact: io.netty/netty-handler-proxy/4.1.72.Final
* License: Apache-2.0

Netty/Handler/Proxy
* Maven Artifact: io.netty/netty-handler-proxy/4.1.73.Final
* License: Apache-2.0

Netty/Handler/Proxy
* Maven Artifact: io.netty/netty-handler-proxy/4.1.74.Final
* License: Apache-2.0

Netty/Handler/Proxy
* Maven Artifact: io.netty/netty-handler-proxy/4.1.79.Final
* License: Apache-2.0

Netty/Handler
* Maven Artifact: io.netty/netty-handler/4.1.43.Final
* License: Apache-2.0

Netty/Handler
* Maven Artifact: io.netty/netty-handler/4.1.63.Final
* License: Apache-2.0

Netty/Handler
* Maven Artifact: io.netty/netty-handler/4.1.65.Final
* License: Apache-2.0

Netty/Handler
* Maven Artifact: io.netty/netty-handler/4.1.68.Final
* License: Apache-2.0

Netty/Handler
* Maven Artifact: io.netty/netty-handler/4.1.72.Final
* License: Apache-2.0

Netty/Handler
* Maven Artifact: io.netty/netty-handler/4.1.73.Final
* License: Apache-2.0

Netty/Handler
* Maven Artifact: io.netty/netty-handler/4.1.74.Final
* License: Apache-2.0

Netty/Handler
* Maven Artifact: io.netty/netty-handler/4.1.79.Final
* License: Apache-2.0

Netty/Resolver/DNS/Classes/MacOS
* Maven Artifact: io.netty/netty-resolver-dns-classes-macos/4.1.72.Final
* License: Apache-2.0

Netty/Resolver/DNS/MacOS
* Maven Artifact: io.netty/netty-resolver-dns-native-macos/4.1.63.Final
* License: Apache-2.0

Netty/Resolver/DNS/MacOS
* Maven Artifact: io.netty/netty-resolver-dns-native-macos/4.1.68.Final
* License: Apache-2.0

Netty/Resolver/DNS/Native/MacOS
* Maven Artifact: io.netty/netty-resolver-dns-native-macos/4.1.72.Final
* License: Apache-2.0

Netty/Resolver/DNS
* Maven Artifact: io.netty/netty-resolver-dns/4.1.63.Final
* License: Apache-2.0

Netty/Resolver/DNS
* Maven Artifact: io.netty/netty-resolver-dns/4.1.68.Final
* License: Apache-2.0

Netty/Resolver/DNS
* Maven Artifact: io.netty/netty-resolver-dns/4.1.72.Final
* License: Apache-2.0

Netty/Resolver/DNS
* Maven Artifact: io.netty/netty-resolver-dns/4.1.74.Final
* License: Apache-2.0

Netty/Resolver
* Maven Artifact: io.netty/netty-resolver/4.1.63.Final
* License: Apache-2.0

Netty/Resolver
* Maven Artifact: io.netty/netty-resolver/4.1.65.Final
* License: Apache-2.0

Netty/Resolver
* Maven Artifact: io.netty/netty-resolver/4.1.68.Final
* License: Apache-2.0

Netty/Resolver
* Maven Artifact: io.netty/netty-resolver/4.1.72.Final
* License: Apache-2.0

Netty/Resolver
* Maven Artifact: io.netty/netty-resolver/4.1.73.Final
* License: Apache-2.0

Netty/Resolver
* Maven Artifact: io.netty/netty-resolver/4.1.74.Final
* License: Apache-2.0

Netty/Resolver
* Maven Artifact: io.netty/netty-resolver/4.1.79.Final
* License: Apache-2.0

Netty/TomcatNative - BoringSSL - Static
* Maven Artifact: io.netty/netty-tcnative-boringssl-static/2.0.39.Final
* License: Apache-2.0

Netty/TomcatNative - BoringSSL - Static
* Maven Artifact: io.netty/netty-tcnative-boringssl-static/2.0.43.Final
* License: Apache-2.0

Netty/TomcatNative - BoringSSL - Static
* Maven Artifact: io.netty/netty-tcnative-boringssl-static/2.0.46.Final
* License: Apache-2.0

Netty/TomcatNative - BoringSSL - Static
* Maven Artifact: io.netty/netty-tcnative-boringssl-static/2.0.47.Final
* License: Apache-2.0

Netty/TomcatNative - BoringSSL - Static
* Maven Artifact: io.netty/netty-tcnative-boringssl-static/2.0.48.Final
* License: Apache-2.0

Netty/TomcatNative - BoringSSL - Static
* Project: https://github.com/netty/netty-tcnative/netty-tcnative-boringssl-static/
* Source: scm:git:git://github.com/netty/netty-tcnative.git/netty-tcnative-boringssl-static
* Maven Artifact: io.netty/netty-tcnative-boringssl-static/2.0.54.Final
* License: Apache-2.0

Netty/TomcatNative - OpenSSL - Classes
* Maven Artifact: io.netty/netty-tcnative-classes/2.0.46.Final
* License: Apache-2.0

Netty/TomcatNative - OpenSSL - Classes
* Maven Artifact: io.netty/netty-tcnative-classes/2.0.47.Final
* License: Apache-2.0

Netty/TomcatNative - OpenSSL - Classes
* Maven Artifact: io.netty/netty-tcnative-classes/2.0.48.Final
* License: Apache-2.0

Netty/TomcatNative - OpenSSL - Classes
* Maven Artifact: io.netty/netty-tcnative-classes/2.0.54.Final
* License: Apache-2.0

Netty/Transport/Classes/Epoll
* Maven Artifact: io.netty/netty-transport-classes-epoll/4.1.72.Final
* License: Apache-2.0

Netty/Transport/Classes/Epoll
* Maven Artifact: io.netty/netty-transport-classes-epoll/4.1.73.Final
* License: Apache-2.0

Netty/Transport/Classes/Epoll
* Maven Artifact: io.netty/netty-transport-classes-epoll/4.1.74.Final
* License: Apache-2.0

Netty/Transport/Classes/KQueue
* Maven Artifact: io.netty/netty-transport-classes-kqueue/4.1.72.Final
* License: Apache-2.0

Netty/Transport/Classes/KQueue
* Maven Artifact: io.netty/netty-transport-classes-kqueue/4.1.73.Final
* License: Apache-2.0

Netty/Transport/Native/Epoll
* Maven Artifact: io.netty/netty-transport-native-epoll/4.1.63.Final
* License: Apache-2.0

Netty/Transport/Native/Epoll
* Maven Artifact: io.netty/netty-transport-native-epoll/4.1.65.Final
* License: Apache-2.0

Netty/Transport/Native/Epoll
* Maven Artifact: io.netty/netty-transport-native-epoll/4.1.68.Final
* License: Apache-2.0

Netty/Transport/Native/Epoll
* Maven Artifact: io.netty/netty-transport-native-epoll/4.1.72.Final
* License: Apache-2.0

Netty/Transport/Native/Epoll
* Maven Artifact: io.netty/netty-transport-native-epoll/4.1.73.Final
* License: Apache-2.0

Netty/Transport/Native/Epoll
* Maven Artifact: io.netty/netty-transport-native-epoll/4.1.74.Final
* License: Apache-2.0

Netty/Transport/Native/KQueue
* Maven Artifact: io.netty/netty-transport-native-kqueue/4.1.65.Final
* License: Apache-2.0

Netty/Transport/Native/KQueue
* Maven Artifact: io.netty/netty-transport-native-kqueue/4.1.68.Final
* License: Apache-2.0

Netty/Transport/Native/KQueue
* Maven Artifact: io.netty/netty-transport-native-kqueue/4.1.72.Final
* License: Apache-2.0

Netty/Transport/Native/KQueue
* Maven Artifact: io.netty/netty-transport-native-kqueue/4.1.73.Final
* License: Apache-2.0

Netty/Transport/Native/Unix/Common
* Maven Artifact: io.netty/netty-transport-native-unix-common/4.1.63.Final
* License: Apache-2.0

Netty/Transport/Native/Unix/Common
* Maven Artifact: io.netty/netty-transport-native-unix-common/4.1.65.Final
* License: Apache-2.0

Netty/Transport/Native/Unix/Common
* Maven Artifact: io.netty/netty-transport-native-unix-common/4.1.68.Final
* License: Apache-2.0

Netty/Transport/Native/Unix/Common
* Maven Artifact: io.netty/netty-transport-native-unix-common/4.1.72.Final
* License: Apache-2.0

Netty/Transport/Native/Unix/Common
* Maven Artifact: io.netty/netty-transport-native-unix-common/4.1.73.Final
* License: Apache-2.0

Netty/Transport/Native/Unix/Common
* Maven Artifact: io.netty/netty-transport-native-unix-common/4.1.74.Final
* License: Apache-2.0

Netty/Transport/Native/Unix/Common
* Maven Artifact: io.netty/netty-transport-native-unix-common/4.1.79.Final
* License: Apache-2.0

Netty/Transport
* Maven Artifact: io.netty/netty-transport/4.1.63.Final
* License: Apache-2.0

Netty/Transport
* Maven Artifact: io.netty/netty-transport/4.1.65.Final
* License: Apache-2.0

Netty/Transport
* Maven Artifact: io.netty/netty-transport/4.1.68.Final
* License: Apache-2.0

Netty/Transport
* Maven Artifact: io.netty/netty-transport/4.1.72.Final
* License: Apache-2.0

Netty/Transport
* Maven Artifact: io.netty/netty-transport/4.1.73.Final
* License: Apache-2.0

Netty/Transport
* Maven Artifact: io.netty/netty-transport/4.1.74.Final
* License: Apache-2.0

Netty/Transport
* Maven Artifact: io.netty/netty-transport/4.1.79.Final
* License: Apache-2.0

OpenTelemetry Protocol
* Project: https://github.com/open-telemetry/opentelemetry-proto-java
* Source: scm:git:git@github.com:open-telemetry/opentelemetry-proto-java.git
* Maven Artifact: io.opentelemetry.proto/opentelemetry-proto/0.14.0-alpha
* License: Apache-2.0

OpenTelemetry Java
* Project: https://github.com/open-telemetry/opentelemetry-java
* Source: scm:git:git@github.com:open-telemetry/opentelemetry-java.git
* Maven Artifact: io.opentelemetry/opentelemetry-api/1.12.0
* License: Apache-2.0

OpenTelemetry Java
* Project: https://github.com/open-telemetry/opentelemetry-java
* Source: scm:git:git@github.com:open-telemetry/opentelemetry-java.git
* Maven Artifact: io.opentelemetry/opentelemetry-context/1.12.0
* License: Apache-2.0

OpenTelemetry Java
* Project: https://github.com/open-telemetry/opentelemetry-java
* Source: scm:git:git@github.com:open-telemetry/opentelemetry-java.git
* Maven Artifact: io.opentelemetry/opentelemetry-extension-annotations/1.12.0
* License: Apache-2.0

Pebble
* Project: http://pebbletemplates.io
* Maven Artifact: io.pebbletemplates/pebble/3.1.5
* License: BSD-3-Clause

Core functionality for the Reactor Netty library
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-core/1.0.11
* License: Apache-2.0

Core functionality for the Reactor Netty library
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-core/1.0.14
* License: Apache-2.0

Core functionality for the Reactor Netty library
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-core/1.0.15
* License: Apache-2.0

Core functionality for the Reactor Netty library
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-core/1.0.7
* License: Apache-2.0

Brave instrumentation for Reactor Netty HTTP
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-http-brave/1.0.7
* License: Apache-2.0

HTTP functionality for the Reactor Netty library
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-http/1.0.11
* License: Apache-2.0

HTTP functionality for the Reactor Netty library
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-http/1.0.14
* License: Apache-2.0

HTTP functionality for the Reactor Netty library
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-http/1.0.15
* License: Apache-2.0

HTTP functionality for the Reactor Netty library
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty-http/1.0.7
* License: Apache-2.0

Reactor Netty with all modules
* Project: https://github.com/reactor/reactor-netty
* Source: scm:git:git://github.com/reactor/reactor-netty
* Maven Artifact: io.projectreactor.netty/reactor-netty/1.0.7
* License: Apache-2.0

Non-Blocking Reactive Foundation for the JVM
* Project: https://github.com/reactor/reactor-core
* Source: scm:git:git://github.com/reactor/reactor-core
* Maven Artifact: io.projectreactor/reactor-core/3.4.10
* License: Apache-2.0

Non-Blocking Reactive Foundation for the JVM
* Project: https://github.com/reactor/reactor-core
* Source: scm:git:git://github.com/reactor/reactor-core
* Maven Artifact: io.projectreactor/reactor-core/3.4.13
* License: Apache-2.0

Non-Blocking Reactive Foundation for the JVM
* Project: https://github.com/reactor/reactor-core
* Source: scm:git:git://github.com/reactor/reactor-core
* Maven Artifact: io.projectreactor/reactor-core/3.4.14
* License: Apache-2.0

Non-Blocking Reactive Foundation for the JVM
* Project: https://github.com/reactor/reactor-core
* Source: scm:git:git://github.com/reactor/reactor-core
* Maven Artifact: io.projectreactor/reactor-core/3.4.6
* License: Apache-2.0

rxjava
* Project: https://github.com/ReactiveX/RxJava
* Maven Artifact: io.reactivex/rxjava/1.3.0
* License: Apache-2.0

rxjava
* Project: https://github.com/ReactiveX/RxJava
* Maven Artifact: io.reactivex/rxjava/1.3.8
* License: Apache-2.0

json-path
* Project: http://maven.apache.org
* Maven Artifact: io.rest-assured/json-path/4.5.0
* License: Apache-2.0

rest-assured-common
* Project: http://maven.apache.org
* Maven Artifact: io.rest-assured/rest-assured-common/4.5.0
* License: Apache-2.0

REST Assured
* Project: http://code.google.com/p/rest-assured
* Maven Artifact: io.rest-assured/rest-assured/4.5.0
* License: Apache-2.0

boopickle
* Project: https://github.com/suzaku-io/boopickle
* Source: scm:git:git@github.com:suzaku-io/boopickle.git
* Maven Artifact: io.suzaku/boopickle_2.13/1.3.3
* License: Apache-2.0

swagger-annotations-jakarta
* Maven Artifact: io.swagger.core.v3/swagger-annotations-jakarta/2.1.13
* License: Apache-2.0

swagger-annotations
* Maven Artifact: io.swagger.core.v3/swagger-annotations/2.1.13
* License: Apache-2.0

swagger-annotations
* Maven Artifact: io.swagger.core.v3/swagger-annotations/2.2.2
* License: Apache-2.0

swagger-core-jakarta
* Maven Artifact: io.swagger.core.v3/swagger-core-jakarta/2.1.13
* License: Apache-2.0

swagger-core
* Maven Artifact: io.swagger.core.v3/swagger-core/2.1.13
* License: Apache-2.0

swagger-core
* Maven Artifact: io.swagger.core.v3/swagger-core/2.2.2
* License: Apache-2.0

swagger-integration-jakarta
* Maven Artifact: io.swagger.core.v3/swagger-integration-jakarta/2.1.13
* License: Apache-2.0

swagger-integration
* Maven Artifact: io.swagger.core.v3/swagger-integration/2.1.13
* License: Apache-2.0

swagger-jaxrs2-jakarta
* Maven Artifact: io.swagger.core.v3/swagger-jaxrs2-jakarta/2.1.13
* License: Apache-2.0

swagger-jaxrs2
* Maven Artifact: io.swagger.core.v3/swagger-jaxrs2/2.1.13
* License: Apache-2.0

swagger-models-jakarta
* Maven Artifact: io.swagger.core.v3/swagger-models-jakarta/2.1.13
* License: Apache-2.0

swagger-models
* Maven Artifact: io.swagger.core.v3/swagger-models/2.1.13
* License: Apache-2.0

swagger-models
* Maven Artifact: io.swagger.core.v3/swagger-models/2.2.2
* License: Apache-2.0

swagger-parser
* Maven Artifact: io.swagger.parser.v3/swagger-parser-core/2.1.2
* License: Apache-2.0

swagger-parser-v2-converter
* Maven Artifact: io.swagger.parser.v3/swagger-parser-v2-converter/2.1.2
* License: Apache-2.0

swagger-parser-v3
* Maven Artifact: io.swagger.parser.v3/swagger-parser-v3/2.1.2
* License: Apache-2.0

swagger-parser
* Maven Artifact: io.swagger.parser.v3/swagger-parser/2.1.2
* License: Apache-2.0

swagger-annotations
* Maven Artifact: io.swagger/swagger-annotations/1.6.6
* License: Apache-2.0

swagger-compat-spec-parser
* Maven Artifact: io.swagger/swagger-compat-spec-parser/1.0.61
* License: Apache-2.0

swagger-core
* Maven Artifact: io.swagger/swagger-core/1.6.6
* License: Apache-2.0

swagger-models
* Maven Artifact: io.swagger/swagger-models/1.6.6
* License: Apache-2.0

swagger-parser
* Maven Artifact: io.swagger/swagger-parser/1.0.61
* License: Apache-2.0

Brave Instrumentation: Http Adapters
* Maven Artifact: io.zipkin.brave/brave-instrumentation-http/5.13.3
* License: Apache-2.0

Brave
* Maven Artifact: io.zipkin.brave/brave/5.13.3
* License: Apache-2.0

Zipkin Reporter Brave
* Maven Artifact: io.zipkin.reporter2/zipkin-reporter-brave/2.16.3
* License: Apache-2.0

Zipkin Reporter: Core
* Maven Artifact: io.zipkin.reporter2/zipkin-reporter/2.16.3
* License: Apache-2.0

Zipkin Core Library
* Maven Artifact: io.zipkin.zipkin2/zipkin/2.23.2
* License: Apache-2.0

JavaBeans Activation Framework API jar
* Maven Artifact: jakarta.activation/jakarta.activation-api/1.2.1
* License: BSD-3-Clause

Jakarta Activation API
* Project: https://github.com/eclipse-ee4j/jaf
* Source: scm:git:ssh://git@github.com/eclipse/jaf.git
* Maven Artifact: jakarta.activation/jakarta.activation-api/2.1.0
* License: BSD-3-Clause

Jakarta Annotations API
* Project: https://projects.eclipse.org/projects/ee4j.ca
* Source: scm:git:https://github.com/eclipse-ee4j/common-annotations-api.git
* Maven Artifact: jakarta.annotation/jakarta.annotation-api/2.0.0
* License: EPL-2.0

Jakarta Expression Language API
* Project: https://projects.eclipse.org/projects/ee4j.el
* Source: scm:git:https://github.com/eclipse-ee4j/el-ri.git
* Maven Artifact: jakarta.el/jakarta.el-api/4.0.0
* License: EPL-2.0

Jakarta Dependency Injection
* Project: https://github.com/eclipse-ee4j/injection-api
* Source: scm:git:ssh://git@github.com/eclipse-ee4j/injection-api.git
* Maven Artifact: jakarta.inject/jakarta.inject-api/2.0.0
* License: Apache-2.0

Jakarta Transaction API
* Project: https://projects.eclipse.org/projects/ee4j.jta
* Source: scm:git:https://github.com/eclipse-ee4j/jta-api.git
* Maven Artifact: jakarta.transaction/jakarta.transaction-api/2.0.0
* License: EPL-2.0

Jakarta Bean Validation API
* Project: https://beanvalidation.org
* Source: scm:git:git://github.com/eclipse-ee4j/beanvalidation-api.git
* Maven Artifact: jakarta.validation/jakarta.validation-api/2.0.2
* License: Apache-2.0

Jakarta Bean Validation API
* Project: https://beanvalidation.org
* Source: scm:git:git://github.com/eclipse-ee4j/beanvalidation-api.git
* Maven Artifact: jakarta.validation/jakarta.validation-api/3.0.0
* License: Apache-2.0

Jakarta Bean Validation API
* Project: https://beanvalidation.org
* Source: scm:git:git://github.com/eclipse-ee4j/beanvalidation-api.git
* Maven Artifact: jakarta.validation/jakarta.validation-api/3.0.1
* License: Apache-2.0

jakarta.ws.rs-api
* Project: https://github.com/eclipse-ee4j/jaxrs-api
* Source: scm:git:https://github.com/eclipse-ee4j/jaxrs-api
* Maven Artifact: jakarta.ws.rs/jakarta.ws.rs-api/3.0.0
* License: EPL-2.0

Jakarta RESTful WS API
* Project: https://github.com/eclipse-ee4j/jaxrs-api
* Source: scm:git:https://github.com/eclipse-ee4j/jaxrs-api
* Maven Artifact: jakarta.ws.rs/jakarta.ws.rs-api/3.1.0
* License: EPL-2.0

Jakarta XML Binding API
* Maven Artifact: jakarta.xml.bind/jakarta.xml.bind-api/3.0.0
* License: BSD-3-Clause

Jakarta XML Binding API
* Maven Artifact: jakarta.xml.bind/jakarta.xml.bind-api/3.0.1
* License: BSD-3-Clause

Jakarta XML Binding API
* Maven Artifact: jakarta.xml.bind/jakarta.xml.bind-api/4.0.0
* License: BSD-3-Clause

Java Servlet API
* Project: http://servlet-spec.java.net
* Source: scm:svn:https://svn.java.net/svn/glassfish~svn/tags/javax.servlet-api-3.1.0
* Maven Artifact: javax.servlet/javax.servlet-api/3.1.0
* License: CDDL-1.1

Java Servlet API
* Project: https://javaee.github.io/servlet-spec/
* Source: scm:git:https://github.com/javaee/servlet-spec.git
* Maven Artifact: javax.servlet/javax.servlet-api/4.0.1
* License: CDDL-1.1

Javax Transaction API
* Project: http://jta-spec.java.net
* Source: scm:git:https://github.com/javaee/javax.transaction.git
* Maven Artifact: javax.transaction/javax.transaction-api/1.3
* License: CDDL-1.1

Bean Validation API
* Project: http://beanvalidation.org
* Source: scm:git:git://github.com/beanvalidation/beanvalidation-api.git
* Maven Artifact: javax.validation/validation-api/2.0.1.Final
* License: Apache-2.0

javax.ws.rs-api
* Project: http://jax-rs-spec.java.net
* Source: scm:git:https://github.com/jax-rs/api.git
* Maven Artifact: javax.ws.rs/javax.ws.rs-api/2.1
* License: CDDL-1.1

Joda-Time
* Project: https://www.joda.org/joda-time/
* Source: scm:git:https://github.com/JodaOrg/joda-time.git
* Maven Artifact: joda-time/joda-time/2.10.5
* License: Apache-2.0

Joda-Time
* Project: https://www.joda.org/joda-time/
* Source: scm:git:https://github.com/JodaOrg/joda-time.git
* Maven Artifact: joda-time/joda-time/2.10.8
* License: Apache-2.0

Byte Buddy agent
* Maven Artifact: net.bytebuddy/byte-buddy-agent/1.12.4
* License: Apache-2.0

Byte Buddy (without dependencies)
* Maven Artifact: net.bytebuddy/byte-buddy/1.12.4
* License: Apache-2.0

Java Native Access Platform
* Project: https://github.com/java-native-access/jna
* Source: scm:git:https://github.com/java-native-access/jna
* Maven Artifact: net.java.dev.jna/jna-platform/5.5.0
* License: Apache-2.0

Java Native Access Platform
* Project: https://github.com/java-native-access/jna
* Source: scm:git:https://github.com/java-native-access/jna
* Maven Artifact: net.java.dev.jna/jna-platform/5.6.0
* License: Apache-2.0

Java Native Access
* Project: https://github.com/java-native-access/jna
* Source: scm:git:https://github.com/java-native-access/jna
* Maven Artifact: net.java.dev.jna/jna/5.5.0
* License: Apache-2.0

Java Native Access
* Project: https://github.com/java-native-access/jna
* Source: scm:git:https://github.com/java-native-access/jna
* Maven Artifact: net.java.dev.jna/jna/5.6.0
* License: Apache-2.0

TypeTools
* Project: http://github.com/jhalterman/typetools/
* Source: scm:git:git@github.com:jhalterman/typetools.git
* Maven Artifact: net.jodah/typetools/0.6.3
* License: Apache-2.0

ASM based accessors helper used by json-smart
* Project: http://www.minidev.net/
* Source: scm:git:https://github.com/netplex/json-smart-v2.git
* Maven Artifact: net.minidev/accessors-smart/1.2
* License: Apache-2.0

ASM based accessors helper used by json-smart
* Project: https://urielch.github.io/
* Source: scm:git:https://github.com/netplex/json-smart-v2.git
* Maven Artifact: net.minidev/accessors-smart/2.4.7
* License: Apache-2.0

JSON Small and Fast Parser
* Project: http://www.minidev.net/
* Source: scm:git:https://github.com/netplex/json-smart-v2.git
* Maven Artifact: net.minidev/json-smart/2.3
* License: Apache-2.0

JSON Small and Fast Parser
* Project: https://urielch.github.io/
* Source: scm:git:https://github.com/netplex/json-smart-v2.git
* Maven Artifact: net.minidev/json-smart/2.4.7
* License: Apache-2.0

JOpt Simple
* Project: http://jopt-simple.github.io/jopt-simple
* Source: scm:git:git://github.com/jopt-simple/jopt-simple.git
* Maven Artifact: net.sf.jopt-simple/jopt-simple/5.0.4
* License: MIT

Saxon-HE
* Project: http://www.saxonica.com/
* Source: scm:svn:https://dev.saxonica.com/repos/archive/opensource/
* Maven Artifact: net.sf.saxon/Saxon-HE/10.5
* License: MPL-2.0

Saxon-HE
* Project: http://www.saxonica.com/
* Source: scm:git:https://saxonica.plan.io/projects/saxonmirrorhe/repository
* Maven Artifact: net.sf.saxon/Saxon-HE/11.1.1
* License: MPL-2.0

ANTLR 4 Runtime
* Maven Artifact: org.antlr/antlr4-runtime/4.9.2
* License: BSD-3-Clause

Apache Commons Digester
* Project: http://commons.apache.org/digester/
* Source: scm:svn:http://svn.apache.org/repos/asf/commons/proper/digester/tags/DIGESTER3_3_2_RC2
* Maven Artifact: org.apache.commons/commons-digester3/3.2
* License: Apache-2.0

Apache Commons Lang
* Project: https://commons.apache.org/proper/commons-lang/
* Source: scm:git:http://gitbox.apache.org/repos/asf/commons-lang.git
* Maven Artifact: org.apache.commons/commons-lang3/3.10
* License: Apache-2.0

Apache Commons Lang
* Project: https://commons.apache.org/proper/commons-lang/
* Source: scm:git:http://gitbox.apache.org/repos/asf/commons-lang.git
* Maven Artifact: org.apache.commons/commons-lang3/3.11
* License: Apache-2.0

Apache Commons Lang
* Project: https://commons.apache.org/proper/commons-lang/
* Source: scm:git:http://gitbox.apache.org/repos/asf/commons-lang.git
* Maven Artifact: org.apache.commons/commons-lang3/3.12.0
* License: Apache-2.0

Apache Commons Lang
* Project: http://commons.apache.org/proper/commons-lang/
* Source: scm:svn:http://svn.apache.org/repos/asf/commons/proper/lang/trunk
* Maven Artifact: org.apache.commons/commons-lang3/3.2.1
* License: Apache-2.0

Apache Commons Lang
* Project: http://commons.apache.org/proper/commons-lang/
* Source: scm:svn:http://svn.apache.org/repos/asf/commons/proper/lang/tags/LANG_3_4
* Maven Artifact: org.apache.commons/commons-lang3/3.4
* License: Apache-2.0

Apache Commons Lang
* Project: http://commons.apache.org/proper/commons-lang/
* Source: scm:git:http://git-wip-us.apache.org/repos/asf/commons-lang.git
* Maven Artifact: org.apache.commons/commons-lang3/3.7
* License: Apache-2.0

Apache Commons Pool
* Project: https://commons.apache.org/proper/commons-pool/
* Source: scm:git:https://gitbox.apache.org/repos/asf/commons-pool.git
* Maven Artifact: org.apache.commons/commons-pool2/2.11.1
* License: Apache-2.0

Apache Commons Text
* Project: https://commons.apache.org/proper/commons-text
* Source: scm:git:http://gitbox.apache.org/repos/asf/commons-text
* Maven Artifact: org.apache.commons/commons-text/1.9
* License: Apache-2.0

Apache HttpClient
* Project: http://hc.apache.org/httpcomponents-client
* Maven Artifact: org.apache.httpcomponents/httpclient/4.5.13
* License: Apache-2.0

Apache HttpCore
* Project: http://hc.apache.org/httpcomponents-core-ga
* Maven Artifact: org.apache.httpcomponents/httpcore/4.4.11
* License: Apache-2.0

Apache HttpCore
* Project: http://hc.apache.org/httpcomponents-core-ga
* Maven Artifact: org.apache.httpcomponents/httpcore/4.4.13
* License: Apache-2.0

Apache HttpCore
* Project: http://hc.apache.org/httpcomponents-core-ga
* Maven Artifact: org.apache.httpcomponents/httpcore/4.4.5
* License: Apache-2.0

Apache HttpClient Mime
* Project: http://hc.apache.org/httpcomponents-client
* Maven Artifact: org.apache.httpcomponents/httpmime/4.5.13
* License: Apache-2.0

Apache Velocity Tools - Generic tools
* Maven Artifact: org.apache.velocity.tools/velocity-tools-generic/3.1
* License: Apache-2.0

Apache Velocity - Engine
* Maven Artifact: org.apache.velocity/velocity-engine-core/2.3
* License: Apache-2.0

Apache Velocity - JSR 223 Scripting
* Maven Artifact: org.apache.velocity/velocity-engine-scripting/2.3
* License: Apache-2.0

org.apiguardian:apiguardian-api
* Project: https://github.com/apiguardian-team/apiguardian
* Source: scm:git:git://github.com/apiguardian-team/apiguardian.git
* Maven Artifact: org.apiguardian/apiguardian-api/1.1.2
* License: Apache-2.0

AssertJ fluent assertions
* Source: scm:git:https://github.com/assertj/assertj-core.git
* Maven Artifact: org.assertj/assertj-core/3.22.0
* License: Apache-2.0

Awaitility
* Project: http://awaitility.org
* Maven Artifact: org.awaitility/awaitility/4.2.0
* License: Apache-2.0

Bouncy Castle PKIX, CMS, EAC, TSP, PKCS, OCSP, CMP, and CRMF APIs
* Project: https://www.bouncycastle.org/java.html
* Maven Artifact: org.bouncycastle/bcpkix-jdk15on/1.70
* License: MIT

Bouncy Castle PKIX, CMS, EAC, TSP, PKCS, OCSP, CMP, and CRMF APIs
* Project: https://www.bouncycastle.org/java.html
* Maven Artifact: org.bouncycastle/bcpkix-jdk18on/1.71
* License: MIT

Bouncy Castle Provider
* Project: https://www.bouncycastle.org/java.html
* Maven Artifact: org.bouncycastle/bcprov-jdk15on/1.70
* License: MIT

Bouncy Castle Provider
* Project: https://www.bouncycastle.org/java.html
* Maven Artifact: org.bouncycastle/bcprov-jdk18on/1.71
* License: MIT

Bouncy Castle ASN.1 Extension and Utility APIs
* Project: https://www.bouncycastle.org/java.html
* Maven Artifact: org.bouncycastle/bcutil-jdk15on/1.70
* License: MIT

Bouncy Castle ASN.1 Extension and Utility APIs
* Project: https://www.bouncycastle.org/java.html
* Maven Artifact: org.bouncycastle/bcutil-jdk18on/1.71
* License: MIT

TagSoup
* Project: http://home.ccil.org/~cowan/XML/tagsoup/
* Maven Artifact: org.ccil.cowan.tagsoup/tagsoup/1.2.1
* License: Apache-2.0

Checker Qual
* Project: https://checkerframework.org
* Source: scm:git:git://github.com/typetools/checker-framework.git
* Maven Artifact: org.checkerframework/checker-qual/3.12.0
* License: MIT

Checker Qual
* Project: https://checkerframework.org
* Source: scm:git:git://github.com/typetools/checker-framework.git
* Maven Artifact: org.checkerframework/checker-qual/3.19.0
* License: MIT

Checker Qual
* Project: https://checkerframework.org
* Source: https://github.com/typetools/checker-framework.git
* Maven Artifact: org.checkerframework/checker-qual/3.5.0
* License: MIT

Checker Qual
* Project: https://checkerframework.org
* Source: https://github.com/typetools/checker-framework.git
* Maven Artifact: org.checkerframework/checker-qual/3.8.0
* License: MIT

Apache Groovy
* Project: https://groovy-lang.org
* Source: scm:git:https://github.com/apache/groovy.git
* Maven Artifact: org.codehaus.groovy/groovy-json/3.0.9
* License: Apache-2.0

Apache Groovy
* Project: https://groovy-lang.org
* Source: scm:git:https://github.com/apache/groovy.git
* Maven Artifact: org.codehaus.groovy/groovy-xml/3.0.9
* License: Apache-2.0

Apache Groovy
* Project: https://groovy-lang.org
* Source: scm:git:https://github.com/apache/groovy.git
* Maven Artifact: org.codehaus.groovy/groovy/3.0.9
* License: Apache-2.0

Stax2 API
* Project: http://github.com/FasterXML/stax2-api
* Source: scm:git:git@github.com:FasterXML/stax2-api.git
* Maven Artifact: org.codehaus.woodstox/stax2-api/4.2.1
* License: BSD-2-Clause

Angus Activation Registries
* Maven Artifact: org.eclipse.angus/angus-activation/1.0.0
* License: EPL-2.0

Jetty :: Jakarta Servlet API and Schemas for JPMS and OSGi
* Source: scm:git:https://github.com/eclipse/jetty.toolchain.git
* Maven Artifact: org.eclipse.jetty.toolchain/jetty-jakarta-servlet-api/5.0.2
* License: EPL-2.0

Jetty :: Jakarta WebSocket API for JPMS and OSGi
* Source: scm:git:https://github.com/eclipse/jetty.toolchain.git
* Maven Artifact: org.eclipse.jetty.toolchain/jetty-jakarta-websocket-api/2.0.0
* License: EPL-2.0

Jetty :: Websocket :: Core :: Client
* Maven Artifact: org.eclipse.jetty.websocket/websocket-core-client/11.0.8
* License: EPL-2.0

Jetty :: Websocket :: Core :: Common
* Maven Artifact: org.eclipse.jetty.websocket/websocket-core-common/11.0.8
* License: EPL-2.0

Jetty :: Websocket :: Core :: Server
* Maven Artifact: org.eclipse.jetty.websocket/websocket-core-server/11.0.8
* License: EPL-2.0

Jetty :: Websocket :: jakarta.websocket :: Client
* Maven Artifact: org.eclipse.jetty.websocket/websocket-jakarta-client/11.0.8
* License: EPL-2.0

Jetty :: Websocket :: jakarta.websocket :: Common
* Maven Artifact: org.eclipse.jetty.websocket/websocket-jakarta-common/11.0.8
* License: EPL-2.0

Jetty :: Websocket :: jakarta.websocket :: Server
* Maven Artifact: org.eclipse.jetty.websocket/websocket-jakarta-server/11.0.8
* License: EPL-2.0

Jetty :: Websocket :: Servlet
* Maven Artifact: org.eclipse.jetty.websocket/websocket-servlet/11.0.8
* License: EPL-2.0

Jetty :: ALPN :: Client
* Maven Artifact: org.eclipse.jetty/jetty-alpn-client/11.0.8
* License: EPL-2.0

Jetty :: Servlet Annotations
* Maven Artifact: org.eclipse.jetty/jetty-annotations/11.0.8
* License: EPL-2.0

Jetty :: Asynchronous HTTP Client
* Maven Artifact: org.eclipse.jetty/jetty-client/11.0.8
* License: EPL-2.0

Jetty :: Http Utility
* Maven Artifact: org.eclipse.jetty/jetty-http/11.0.8
* License: EPL-2.0

Jetty :: IO Utility
* Maven Artifact: org.eclipse.jetty/jetty-io/11.0.8
* License: EPL-2.0

Jetty :: JNDI Naming
* Maven Artifact: org.eclipse.jetty/jetty-jndi/11.0.8
* License: EPL-2.0

Jetty :: Plus
* Maven Artifact: org.eclipse.jetty/jetty-plus/11.0.8
* License: EPL-2.0

Jetty :: Security
* Maven Artifact: org.eclipse.jetty/jetty-security/11.0.8
* License: EPL-2.0

Jetty :: Server Core
* Maven Artifact: org.eclipse.jetty/jetty-server/11.0.8
* License: EPL-2.0

Jetty :: Servlet Handling
* Maven Artifact: org.eclipse.jetty/jetty-servlet/11.0.8
* License: EPL-2.0

Jetty :: Utilities
* Maven Artifact: org.eclipse.jetty/jetty-util/11.0.8
* License: EPL-2.0

Jetty :: Webapp Application Support
* Maven Artifact: org.eclipse.jetty/jetty-webapp/11.0.8
* License: EPL-2.0

Jetty :: XML utilities
* Maven Artifact: org.eclipse.jetty/jetty-xml/11.0.8
* License: EPL-2.0

aopalliance repackaged
* Maven Artifact: org.glassfish.hk2.external/aopalliance-repackaged/3.0.1
* License: EPL-2.0

HK2 API module
* Maven Artifact: org.glassfish.hk2/hk2-api/3.0.1
* License: EPL-2.0

ServiceLocator Default Implementation
* Maven Artifact: org.glassfish.hk2/hk2-locator/3.0.1
* License: EPL-2.0

HK2 Implementation Utilities
* Maven Artifact: org.glassfish.hk2/hk2-utils/3.0.1
* License: EPL-2.0

OSGi resource locator
* Source: scm:git:https://github.com/eclipse-ee4j/glassfish-hk2-extra.git
* Maven Artifact: org.glassfish.hk2/osgi-resource-locator/1.0.3
* License: CDDL-1.0

jersey-container-servlet-core
* Maven Artifact: org.glassfish.jersey.containers/jersey-container-servlet-core/3.0.4
* License: EPL-2.0

jersey-container-servlet
* Maven Artifact: org.glassfish.jersey.containers/jersey-container-servlet/3.0.4
* License: EPL-2.0

jersey-core-client
* Maven Artifact: org.glassfish.jersey.core/jersey-client/3.0.4
* License: EPL-2.0

jersey-core-common
* Maven Artifact: org.glassfish.jersey.core/jersey-common/3.0.4
* License: EPL-2.0

jersey-core-server
* Maven Artifact: org.glassfish.jersey.core/jersey-server/3.0.4
* License: EPL-2.0

jersey-ext-bean-validation
* Maven Artifact: org.glassfish.jersey.ext/jersey-bean-validation/3.0.4
* License: EPL-2.0

jersey-ext-entity-filtering
* Maven Artifact: org.glassfish.jersey.ext/jersey-entity-filtering/3.0.4
* License: EPL-2.0

jersey-inject-hk2
* Maven Artifact: org.glassfish.jersey.inject/jersey-hk2/3.0.4
* License: EPL-2.0

jersey-media-json-jackson
* Maven Artifact: org.glassfish.jersey.media/jersey-media-json-jackson/3.0.4
* License: EPL-2.0

jersey-media-multipart
* Maven Artifact: org.glassfish.jersey.media/jersey-media-multipart/3.0.4
* License: EPL-2.0

Jakarta Expression Language Implementation
* Project: https://projects.eclipse.org/projects/ee4j.el
* Source: scm:git:https://github.com/eclipse-ee4j/el-ri.git
* Maven Artifact: org.glassfish/jakarta.el/4.0.0
* License: EPL-2.0

Hamcrest Core
* Project: http://hamcrest.org/JavaHamcrest/
* Source: git@github.com:hamcrest/JavaHamcrest.git
* Maven Artifact: org.hamcrest/hamcrest-core/2.2
* License: BSD-3-Clause

Hamcrest
* Project: http://hamcrest.org/JavaHamcrest/
* Source: git@github.com:hamcrest/JavaHamcrest.git
* Maven Artifact: org.hamcrest/hamcrest/2.1
* License: BSD-3-Clause

Hamcrest
* Project: http://hamcrest.org/JavaHamcrest/
* Source: git@github.com:hamcrest/JavaHamcrest.git
* Maven Artifact: org.hamcrest/hamcrest/2.2
* License: BSD-3-Clause

HdrHistogram
* Project: http://hdrhistogram.github.io/HdrHistogram/
* Source: scm:git:git://github.com/HdrHistogram/HdrHistogram.git
* Maven Artifact: org.hdrhistogram/HdrHistogram/2.1.12
* License: BSD-2-Clause

Hibernate Validator Engine
* Maven Artifact: org.hibernate.validator/hibernate-validator/7.0.0.Final
* License: Apache-2.0

Javassist
* Project: http://www.javassist.org/
* Source: scm:git:git@github.com:jboss-javassist/javassist.git
* Maven Artifact: org.javassist/javassist/3.25.0-GA
* License: MPL-1.1

Javassist
* Project: http://www.javassist.org/
* Source: scm:git:git@github.com:jboss-javassist/javassist.git
* Maven Artifact: org.javassist/javassist/3.26.0-GA
* License: MPL-1.1

JBoss Logging 3
* Project: http://www.jboss.org
* Source: scm:git:git://github.com/jboss-logging/jboss-logging.git
* Maven Artifact: org.jboss.logging/jboss-logging/3.4.1.Final
* License: Apache-2.0

Kotlin Stdlib Common
* Project: https://kotlinlang.org/
* Source: scm:git:https://github.com/JetBrains/kotlin.git
* Maven Artifact: org.jetbrains.kotlin/kotlin-stdlib-common/1.5.31
* License: Apache-2.0

Kotlin Stdlib Common
* Project: https://kotlinlang.org/
* Source: scm:git:https://github.com/JetBrains/kotlin.git
* Maven Artifact: org.jetbrains.kotlin/kotlin-stdlib-common/1.6.20
* License: Apache-2.0

Kotlin Stdlib Jdk7
* Project: https://kotlinlang.org/
* Source: scm:git:https://github.com/JetBrains/kotlin.git
* Maven Artifact: org.jetbrains.kotlin/kotlin-stdlib-jdk7/1.5.31
* License: Apache-2.0

Kotlin Stdlib Jdk7
* Project: https://kotlinlang.org/
* Source: scm:git:https://github.com/JetBrains/kotlin.git
* Maven Artifact: org.jetbrains.kotlin/kotlin-stdlib-jdk7/1.6.10
* License: Apache-2.0

Kotlin Stdlib Jdk8
* Project: https://kotlinlang.org/
* Source: scm:git:https://github.com/JetBrains/kotlin.git
* Maven Artifact: org.jetbrains.kotlin/kotlin-stdlib-jdk8/1.5.31
* License: Apache-2.0

Kotlin Stdlib Jdk8
* Project: https://kotlinlang.org/
* Source: scm:git:https://github.com/JetBrains/kotlin.git
* Maven Artifact: org.jetbrains.kotlin/kotlin-stdlib-jdk8/1.6.10
* License: Apache-2.0

Kotlin Stdlib
* Project: https://kotlinlang.org/
* Source: scm:git:https://github.com/JetBrains/kotlin.git
* Maven Artifact: org.jetbrains.kotlin/kotlin-stdlib/1.5.31
* License: Apache-2.0

Kotlin Stdlib
* Project: https://kotlinlang.org/
* Source: scm:git:https://github.com/JetBrains/kotlin.git
* Maven Artifact: org.jetbrains.kotlin/kotlin-stdlib/1.6.10
* License: Apache-2.0

Kotlin Stdlib
* Project: https://kotlinlang.org/
* Source: scm:git:https://github.com/JetBrains/kotlin.git
* Maven Artifact: org.jetbrains.kotlin/kotlin-stdlib/1.6.20
* License: Apache-2.0

IntelliJ IDEA Annotations
* Project: http://www.jetbrains.org
* Source: scm:git:https://github.com/JetBrains/intellij-community.git
* Maven Artifact: org.jetbrains/annotations/13.0
* License: Apache-2.0

IntelliJ IDEA Annotations
* Project: http://www.jetbrains.org
* Source: scm:git:https://github.com/JetBrains/intellij-community.git
* Maven Artifact: org.jetbrains/annotations/15.0
* License: Apache-2.0

Jodd Lagarto
* Project: https://lagarto.jodd.org
* Source: scm:git:git://github.com/oblac/jodd-lagarto.git
* Maven Artifact: org.jodd/jodd-lagarto/6.0.5
* License: BSD-2-Clause

Jodd Util
* Project: https://util.jodd.org
* Source: scm:git:git://github.com/oblac/jodd-util.git
* Maven Artifact: org.jodd/jodd-util/6.0.1
* License: BSD-2-Clause

junit-pioneer
* Project: https://junit-pioneer.org/
* Maven Artifact: org.junit-pioneer/junit-pioneer/1.7.1
* License: EPL-2.0

JUnit Jupiter API
* Project: https://junit.org/junit5/
* Source: scm:git:git://github.com/junit-team/junit5.git
* Maven Artifact: org.junit.jupiter/junit-jupiter-api/5.8.2
* License: EPL-2.0

JUnit Jupiter Engine
* Project: https://junit.org/junit5/
* Source: scm:git:git://github.com/junit-team/junit5.git
* Maven Artifact: org.junit.jupiter/junit-jupiter-engine/5.8.2
* License: EPL-2.0

JUnit Jupiter Params
* Project: https://junit.org/junit5/
* Source: scm:git:git://github.com/junit-team/junit5.git
* Maven Artifact: org.junit.jupiter/junit-jupiter-params/5.8.2
* License: EPL-2.0

JUnit Platform Commons
* Project: https://junit.org/junit5/
* Source: scm:git:git://github.com/junit-team/junit5.git
* Maven Artifact: org.junit.platform/junit-platform-commons/1.8.2
* License: EPL-2.0

JUnit Platform Engine API
* Project: https://junit.org/junit5/
* Source: scm:git:git://github.com/junit-team/junit5.git
* Maven Artifact: org.junit.platform/junit-platform-engine/1.8.2
* License: EPL-2.0

JUnit Platform Launcher
* Project: https://junit.org/junit5/
* Source: scm:git:git://github.com/junit-team/junit5.git
* Maven Artifact: org.junit.platform/junit-platform-launcher/1.8.2
* License: EPL-2.0

JUnit 5 (Bill of Materials)
* Project: https://junit.org/junit5/
* Source: scm:git:git://github.com/junit-team/junit5.git
* Maven Artifact: org.junit/junit-bom/5.8.2
* License: EPL-2.0

MIME streaming extension
* Project: https://github.com/eclipse-ee4j/metro-mimepull
* Source: scm:git:ssh://git@github.com/eclipse-ee4j/metro-mimepull.git
* Maven Artifact: org.jvnet.mimepull/mimepull/1.9.13
* License: BSD-3-Clause

LatencyUtils
* Project: http://latencyutils.github.io/LatencyUtils/
* Source: scm:git:git://github.com/LatencyUtils/LatencyUtils.git
* Maven Artifact: org.latencyutils/LatencyUtils/2.0.3
* License: BSD-2-Clause

MockServer Java Client
* Project: https://www.mock-server.com
* Maven Artifact: org.mock-server/mockserver-client-java/5.14.0
* License: Apache-2.0

MockServer Core
* Project: https://www.mock-server.com
* Maven Artifact: org.mock-server/mockserver-core/5.14.0
* License: Apache-2.0

MockServer &amp; Proxy Netty
* Project: https://www.mock-server.com
* Maven Artifact: org.mock-server/mockserver-netty/5.14.0
* License: Apache-2.0

mockito-core
* Project: https://github.com/mockito/mockito
* Maven Artifact: org.mockito/mockito-core/4.2.0
* License: MIT

mockito-inline
* Project: https://github.com/mockito/mockito
* Maven Artifact: org.mockito/mockito-inline/4.2.0
* License: MIT

Mozilla Rhino
* Project: https://developer.mozilla.org/en/Rhino
* Source: scm:git:git@github.com:mozilla/rhino.git
* Maven Artifact: org.mozilla/rhino/1.7.7.2
* License: MPL-2.0

Objenesis
* Maven Artifact: org.objenesis/objenesis/3.2
* License: Apache-2.0

org.opentest4j:opentest4j
* Project: https://github.com/ota4j-team/opentest4j
* Source: scm:git:git://github.com/ota4j-team/opentest4j.git
* Maven Artifact: org.opentest4j/opentest4j/1.2.0
* License: Apache-2.0

asm-analysis
* Project: http://asm.ow2.io/
* Source: scm:git:https://gitlab.ow2.org/asm/asm/
* Maven Artifact: org.ow2.asm/asm-analysis/9.2
* License: BSD-3-Clause

asm-commons
* Project: http://asm.ow2.io/
* Source: scm:git:https://gitlab.ow2.org/asm/asm/
* Maven Artifact: org.ow2.asm/asm-commons/9.2
* License: BSD-3-Clause

asm-tree
* Project: http://asm.ow2.io/
* Source: scm:git:https://gitlab.ow2.org/asm/asm/
* Maven Artifact: org.ow2.asm/asm-tree/9.2
* License: BSD-3-Clause

ASM Core
* Maven Artifact: org.ow2.asm/asm/5.0.4
* License: BSD-2-Clause

asm
* Project: http://asm.ow2.io/
* Source: scm:git:https://gitlab.ow2.org/asm/asm/
* Maven Artifact: org.ow2.asm/asm/9.1
* License: BSD-3-Clause

asm
* Project: http://asm.ow2.io/
* Source: scm:git:https://gitlab.ow2.org/asm/asm/
* Maven Artifact: org.ow2.asm/asm/9.2
* License: BSD-3-Clause

PostgreSQL JDBC Driver
* Project: https://jdbc.postgresql.org
* Source: scm:git:https://github.com/pgjdbc/pgjdbc.git
* Maven Artifact: org.postgresql/postgresql/42.4.0
* License: BSD-2-Clause

reactive-streams
* Project: http://www.reactive-streams.org/
* Source: scm:git:git@github.com:reactive-streams/reactive-streams.git
* Maven Artifact: org.reactivestreams/reactive-streams/1.0.3
* License: CC0-1.0

Reflections
* Project: http://github.com/ronmamo/reflections
* Source: scm:git:git://github.com/ronmamo/reflections.git
* Maven Artifact: org.reflections/reflections/0.9.12
* License: MIT

scala-java8-compat
* Project: http://www.scala-lang.org/
* Source: scm:git:git://github.com/scala/scala-java8-compat.git
* Maven Artifact: org.scala-lang.modules/scala-java8-compat_2.13/1.0.0
* License: Apache-2.0

scala-parser-combinators
* Project: http://www.scala-lang.org/
* Source: scm:git:git://github.com/scala/scala-parser-combinators.git
* Maven Artifact: org.scala-lang.modules/scala-parser-combinators_2.13/2.1.0
* License: Apache-2.0

scala-swing
* Project: http://www.scala-lang.org/
* Source: scm:git:git://github.com/scala/scala-swing.git
* Maven Artifact: org.scala-lang.modules/scala-swing_2.13/3.0.0
* License: Apache-2.0

Scala Library
* Project: https://www.scala-lang.org/
* Source: scm:git:git://github.com/scala/scala.git
* Maven Artifact: org.scala-lang/scala-library/2.13.0
* License: Apache-2.0

Scala Library
* Project: https://www.scala-lang.org/
* Source: scm:git:git://github.com/scala/scala.git
* Maven Artifact: org.scala-lang/scala-library/2.13.1
* License: Apache-2.0

Scala Library
* Project: https://www.scala-lang.org/
* Source: scm:git:git://github.com/scala/scala.git
* Maven Artifact: org.scala-lang/scala-library/2.13.2
* License: Apache-2.0

Scala Library
* Project: https://www.scala-lang.org/
* Source: scm:git:git://github.com/scala/scala.git
* Maven Artifact: org.scala-lang/scala-library/2.13.3
* License: Apache-2.0

Scala Library
* Project: https://www.scala-lang.org/
* Source: scm:git:git://github.com/scala/scala.git
* Maven Artifact: org.scala-lang/scala-library/2.13.5
* License: Apache-2.0

Scala Library
* Project: https://www.scala-lang.org/
* Source: scm:git:git://github.com/scala/scala.git
* Maven Artifact: org.scala-lang/scala-library/2.13.6
* License: Apache-2.0

Scala Library
* Project: https://www.scala-lang.org/
* Source: scm:git:git://github.com/scala/scala.git
* Maven Artifact: org.scala-lang/scala-library/2.13.7
* License: Apache-2.0

Scala Library
* Project: https://www.scala-lang.org/
* Source: scm:git:git://github.com/scala/scala.git
* Maven Artifact: org.scala-lang/scala-library/2.13.8
* License: Apache-2.0

Scala Compiler
* Project: https://www.scala-lang.org/
* Source: scm:git:git://github.com/scala/scala.git
* Maven Artifact: org.scala-lang/scala-reflect/2.13.5
* License: Apache-2.0

Scala Compiler
* Project: https://www.scala-lang.org/
* Source: scm:git:git://github.com/scala/scala.git
* Maven Artifact: org.scala-lang/scala-reflect/2.13.8
* License: Apache-2.0

lightning-csv
* Project: http://github.com/arnaudroger/SimpleFlatMapper/lightning-csv
* Source: scm:git:git://github.com/arnaudroger/SimpleFlatMapper.git/lightning-csv
* Maven Artifact: org.simpleflatmapper/lightning-csv/8.2.3
* License: MIT

sfm-util
* Project: http://github.com/arnaudroger/SimpleFlatMapper/sfm-util
* Source: scm:git:git://github.com/arnaudroger/SimpleFlatMapper.git/sfm-util
* Maven Artifact: org.simpleflatmapper/sfm-util/8.2.3
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.22
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.25
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.26
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.28
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.29
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.30
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.32
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.33
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.35
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.36
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/1.7.7
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/2.0.0-alpha5
* License: MIT

SLF4J API Module
* Project: http://www.slf4j.org
* Maven Artifact: org.slf4j/slf4j-api/2.0.0-alpha7
* License: MIT

macros
* Project: https://typelevel.org/spire/
* Source: scm:git:https://github.com/typelevel/spire.git
* Maven Artifact: org.typelevel/spire-macros_2.13/0.17.0
* License: MIT

unbescape
* Project: http://www.unbescape.org
* Source: scm:git:git@github.com:unbescape/unbescape.git
* Maven Artifact: org.unbescape/unbescape/1.1.6.RELEASE
* License: Apache-2.0

XML Resolver
* Project: https://github.com/xmlresolver/xmlresolver
* Source: scm:git@github.com:xmlresolver/xmlresolver.git
* Maven Artifact: org.xmlresolver/xmlresolver/4.1.2
* License: Apache-2.0

xmlunit-core
* Project: https://www.xmlunit.org/
* Maven Artifact: org.xmlunit/xmlunit-core/2.9.0
* License: Apache-2.0

xmlunit-placeholders
* Maven Artifact: org.xmlunit/xmlunit-placeholders/2.9.0
* License: Apache-2.0

SnakeYAML
* Project: http://www.snakeyaml.org
* Source: scm:git:http://bitbucket.org/asomov/snakeyaml
* Maven Artifact: org.yaml/snakeyaml/1.27
* License: Apache-2.0

SnakeYAML
* Project: https://bitbucket.org/snakeyaml/snakeyaml
* Source: scm:git:http://bitbucket.org/snakeyaml/snakeyaml
* Maven Artifact: org.yaml/snakeyaml/1.30
* License: Apache-2.0

AWS Java SDK :: Annotations
* Maven Artifact: software.amazon.awssdk/annotations/2.16.60
* License: Apache-2.0

AWS Java SDK :: HTTP Clients :: Apache
* Maven Artifact: software.amazon.awssdk/apache-client/2.16.60
* License: Apache-2.0

AWS Java SDK :: Arns
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/arns/2.16.60
* License: Apache-2.0

AWS Java SDK :: Auth
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/auth/2.16.60
* License: Apache-2.0

AWS Java SDK :: AWS Core
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/aws-core/2.16.60
* License: Apache-2.0

AWS Java SDK :: Core :: Protocols :: AWS Query Protocol
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/aws-query-protocol/2.16.60
* License: Apache-2.0

AWS Java SDK :: Core :: Protocols :: AWS Xml Protocol
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/aws-xml-protocol/2.16.60
* License: Apache-2.0

AWS Java SDK :: HTTP Client Interface
* Maven Artifact: software.amazon.awssdk/http-client-spi/2.16.60
* License: Apache-2.0

AWS Java SDK :: Services :: AWS IAM
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/iam/2.16.60
* License: Apache-2.0

AWS Java SDK :: Metrics SPI
* Maven Artifact: software.amazon.awssdk/metrics-spi/2.16.60
* License: Apache-2.0

AWS Java SDK :: HTTP Clients :: Netty Non-Blocking I/O
* Maven Artifact: software.amazon.awssdk/netty-nio-client/2.16.60
* License: Apache-2.0

AWS Java SDK :: Profiles
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/profiles/2.16.60
* License: Apache-2.0

AWS Java SDK :: Core :: Protocols :: Protocol Core
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/protocol-core/2.16.60
* License: Apache-2.0

AWS Java SDK :: Regions
* Maven Artifact: software.amazon.awssdk/regions/2.16.60
* License: Apache-2.0

AWS Java SDK :: Services :: Amazon S3
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/s3/2.16.60
* License: Apache-2.0

AWS Java SDK :: SDK Core
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/sdk-core/2.16.60
* License: Apache-2.0

AWS Java SDK :: Services :: AWS STS
* Project: https://aws.amazon.com/sdkforjava
* Maven Artifact: software.amazon.awssdk/sts/2.16.60
* License: Apache-2.0

AWS Java SDK :: Utilities
* Maven Artifact: software.amazon.awssdk/utils/2.16.60
* License: Apache-2.0

AWS Event Stream
* Project: https://github.com/awslabs/aws-eventstream-java
* Maven Artifact: software.amazon.eventstream/eventstream/1.0.1
* License: Apache-2.0

XML Commons External Components XML APIs
* Project: http://xml.apache.org/commons/components/external/
* Source: scm:svn:http://svn.apache.org/repos/asf/xml/commons/tags/xml-commons-external-1_4_01/
* Maven Artifact: xml-apis/xml-apis/1.4.01
* License: Apache-2.0

The International Data Spaces (IDS) Information Model
* Project: https://github.com/International-Data-Spaces-Association/InformationModel
* Source: scm:git:https://github.com/International-Data-Spaces-Association/InformationModel.git
* Maven Artifact: de.fraunhofer.iais.eis.ids.infomodel/java/4.1.3
* License: Apache-2.0

The International Data Spaces (IDS) Information Model Util
* Project: https://github.com/International-Data-Spaces-Association/InformationModel
* Source: scm:git:https://github.com/International-Data-Spaces-Association/InformationModel.git
* Maven Artifact: de.fraunhofer.iais.eis.infomodel/util/4.1.3
* License: Apache-2.0

Logback Classic Module
* Maven Artifact: ch.qos.logback/logback-classic/1.2.10
* License: EPL-1.0

Logback Core Module
* Maven Artifact: ch.qos.logback/logback-core/1.2.10
* License: EPL-1.0

## Cryptography

Content may contain encryption software. The country in which you are currently may have restrictions on the import, possession, and use, and/or re-export to another country, of encryption software. BEFORE using any encryption software, please check the country's laws, regulations and policies concerning the import, possession, or use, and re-export of encryption software, to see if this is permitted.
