/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.base;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.message.MessageContext;
import org.eclipse.edc.spi.message.RemoteMessageDispatcher;
import org.eclipse.edc.spi.message.RemoteMessageDispatcherRegistry;
import org.eclipse.edc.spi.types.domain.message.RemoteMessage;
import org.jetbrains.annotations.Nullable;

public class RemoteMessageDispatcherRegistryImpl
implements RemoteMessageDispatcherRegistry {
    private final Map<String, RemoteMessageDispatcher> dispatchers = new HashMap<String, RemoteMessageDispatcher>();

    public void register(RemoteMessageDispatcher dispatcher) {
        this.dispatchers.put(dispatcher.protocol(), dispatcher);
    }

    public <T> CompletableFuture<T> send(Class<T> responseType, RemoteMessage message, MessageContext context) {
        Objects.requireNonNull(message, "Message was null");
        String protocol = message.getProtocol();
        RemoteMessageDispatcher dispatcher = this.getDispatcher(protocol);
        if (dispatcher == null) {
            return CompletableFuture.failedFuture((Throwable)new EdcException("No provider dispatcher registered for protocol: " + protocol));
        }
        return dispatcher.send(responseType, message, context);
    }

    @Nullable
    private RemoteMessageDispatcher getDispatcher(@Nullable String protocol) {
        if (protocol == null) {
            return this.dispatchers.values().stream().findFirst().orElse(null);
        }
        return this.dispatchers.get(protocol);
    }
}

