/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.transform;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edc.transform.spi.ProblemBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.jetbrains.annotations.Nullable;

public class TransformerContextImpl
implements TransformerContext {
    private final List<String> problems = new ArrayList<String>();
    private final TypeTransformerRegistry registry;

    public TransformerContextImpl(TypeTransformerRegistry registry) {
        this.registry = registry;
    }

    public boolean hasProblems() {
        return !this.problems.isEmpty();
    }

    public List<String> getProblems() {
        return this.problems;
    }

    public void reportProblem(String problem) {
        this.problems.add(problem);
    }

    public ProblemBuilder problem() {
        return new ProblemBuilder((TransformerContext)this);
    }

    @Nullable
    public <INPUT, OUTPUT> OUTPUT transform(INPUT object, Class<OUTPUT> outputType) {
        if (object == null) {
            return null;
        }
        return (OUTPUT)this.registry.transformerFor(object, outputType).transform(object, (TransformerContext)this);
    }

    public Class<?> typeAlias(String type) {
        return this.registry.typeAlias(type);
    }

    public Class<?> typeAlias(String type, Class<?> defaultType) {
        return this.registry.typeAlias(type, defaultType);
    }
}

