/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.base;

import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import java.time.temporal.ChronoUnit;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.system.ServiceExtensionContext;

public class RetryPolicyFactory {
    private static final String DEFAULT_RETRIES = "5";
    private static final String DEFAULT_MIN_BACKOFF = "500";
    private static final String DEFAULT_MAX_BACKOFF = "10000";
    private static final String DEFAULT_LOG = "false";
    @Setting(value="Maximum retries for the retry policy before a failure is propagated", defaultValue="5")
    private static final String MAX_RETRIES = "edc.core.retry.retries.max";
    @Setting(value="Minimum number of milliseconds for exponential backoff", defaultValue="500")
    private static final String BACKOFF_MIN_MILLIS = "edc.core.retry.backoff.min";
    @Setting(value="Maximum number of milliseconds for exponential backoff.", defaultValue="10000")
    private static final String BACKOFF_MAX_MILLIS = "edc.core.retry.backoff.max";
    @Setting(value="Log Failsafe onRetry events", defaultValue="false")
    static final String LOG_ON_RETRY = "edc.core.retry.log.on.retry";
    @Setting(value="Log Failsafe onRetryScheduled events", defaultValue="false")
    static final String LOG_ON_RETRY_SCHEDULED = "edc.core.retry.log.on.retry.scheduled";
    @Setting(value="Log Failsafe onRetriesExceeded events", defaultValue="false")
    static final String LOG_ON_RETRIES_EXCEEDED = "edc.core.retry.log.on.retries.exceeded";
    @Setting(value="Log Failsafe onFailedAttempt events", defaultValue="false")
    static final String LOG_ON_FAILED_ATTEMPT = "edc.core.retry.log.on.failed.attempt";
    @Setting(value="Log Failsafe onAbort events", defaultValue="false")
    static final String LOG_ON_ABORT = "edc.core.retry.log.on.abort";

    public static <T> RetryPolicy<T> create(ServiceExtensionContext context) {
        int maxRetries = context.getSetting(MAX_RETRIES, Integer.parseInt(DEFAULT_RETRIES));
        int minBackoff = context.getSetting(BACKOFF_MIN_MILLIS, Integer.parseInt(DEFAULT_MIN_BACKOFF));
        int maxBackoff = context.getSetting(BACKOFF_MAX_MILLIS, Integer.parseInt(DEFAULT_MAX_BACKOFF));
        RetryPolicyBuilder builder = RetryPolicy.builder().withMaxRetries(maxRetries).withBackoff((long)minBackoff, (long)maxBackoff, ChronoUnit.MILLIS);
        if (context.getSetting(LOG_ON_RETRY, false)) {
            builder.onRetry(event -> context.getMonitor().debug("Failsafe: execution attempted, will retry.", new Throwable[]{event.getLastException()}));
        }
        if (context.getSetting(LOG_ON_RETRY_SCHEDULED, false)) {
            builder.onRetryScheduled(event -> context.getMonitor().debug(String.format("Failsafe: execution scheduled, will retry in %s.", event.getDelay()), new Throwable[]{event.getLastException()}));
        }
        if (context.getSetting(LOG_ON_RETRIES_EXCEEDED, false)) {
            builder.onRetriesExceeded(event -> context.getMonitor().debug("Failsafe: maximum retries exceeded", new Throwable[]{event.getException()}));
        }
        if (context.getSetting(LOG_ON_FAILED_ATTEMPT, false)) {
            builder.onFailedAttempt(event -> context.getMonitor().debug("Failsafe: execution attempt failed", new Throwable[]{event.getLastException()}));
        }
        if (context.getSetting(LOG_ON_ABORT, false)) {
            builder.onAbort(event -> context.getMonitor().debug("Failsafe: execution aborted", new Throwable[]{event.getException()}));
        }
        return builder.build();
    }
}

