/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core;

import java.security.PrivateKey;
import java.time.Duration;
import java.util.function.Function;
import org.eclipse.edc.connector.core.base.CommandHandlerRegistryImpl;
import org.eclipse.edc.connector.core.base.RemoteMessageDispatcherRegistryImpl;
import org.eclipse.edc.connector.core.base.agent.ParticipantAgentServiceImpl;
import org.eclipse.edc.connector.core.event.EventExecutorServiceContainer;
import org.eclipse.edc.connector.core.event.EventRouterImpl;
import org.eclipse.edc.connector.core.health.HealthCheckServiceConfiguration;
import org.eclipse.edc.connector.core.health.HealthCheckServiceImpl;
import org.eclipse.edc.connector.core.security.DefaultPrivateKeyParseFunction;
import org.eclipse.edc.connector.core.transform.TypeTransformerRegistryImpl;
import org.eclipse.edc.connector.core.validator.JsonObjectValidatorRegistryImpl;
import org.eclipse.edc.policy.engine.PolicyEngineImpl;
import org.eclipse.edc.policy.engine.RuleBindingRegistryImpl;
import org.eclipse.edc.policy.engine.ScopeFilter;
import org.eclipse.edc.policy.engine.spi.PolicyEngine;
import org.eclipse.edc.policy.engine.spi.RuleBindingRegistry;
import org.eclipse.edc.policy.model.PolicyRegistrationTypes;
import org.eclipse.edc.runtime.metamodel.annotation.BaseExtension;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.agent.ParticipantAgentService;
import org.eclipse.edc.spi.command.CommandHandlerRegistry;
import org.eclipse.edc.spi.event.EventRouter;
import org.eclipse.edc.spi.message.RemoteMessageDispatcherRegistry;
import org.eclipse.edc.spi.security.PrivateKeyResolver;
import org.eclipse.edc.spi.system.ExecutorInstrumentation;
import org.eclipse.edc.spi.system.Hostname;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.health.HealthCheckService;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;

@BaseExtension
@Extension(value="Core Services")
public class CoreServicesExtension
implements ServiceExtension {
    @Setting
    public static final String LIVENESS_PERIOD_SECONDS_SETTING = "edc.core.system.health.check.liveness-period";
    @Setting
    public static final String STARTUP_PERIOD_SECONDS_SETTING = "edc.core.system.health.check.startup-period";
    @Setting
    public static final String READINESS_PERIOD_SECONDS_SETTING = "edc.core.system.health.check.readiness-period";
    @Setting
    public static final String THREADPOOL_SIZE_SETTING = "edc.core.system.health.check.threadpool-size";
    @Setting
    public static final String HOSTNAME_SETTING = "edc.hostname";
    @Setting
    public static final String IDENTITY_KEY = "edc.agent.identity.key";
    public static final String NAME = "Core Services";
    private static final long DEFAULT_DURATION = 60L;
    private static final int DEFAULT_TP_SIZE = 3;
    private static final String DEFAULT_HOSTNAME = "localhost";
    @Inject
    private ExecutorInstrumentation executorInstrumentation;
    @Inject
    private PrivateKeyResolver privateKeyResolver;
    @Inject
    private EventExecutorServiceContainer eventExecutorServiceContainer;
    @Inject
    private TypeManager typeManager;
    private HealthCheckServiceImpl healthCheckService;
    private RuleBindingRegistry ruleBindingRegistry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.privateKeyResolver.addParser(PrivateKey.class, (Function)new DefaultPrivateKeyParseFunction());
        HealthCheckServiceConfiguration config = this.getHealthCheckConfig(context);
        this.healthCheckService = new HealthCheckServiceImpl(config, this.executorInstrumentation);
        this.ruleBindingRegistry = new RuleBindingRegistryImpl();
    }

    public void start() {
        this.healthCheckService.start();
    }

    public void shutdown() {
        this.healthCheckService.stop();
        super.shutdown();
    }

    public void prepare() {
        PolicyRegistrationTypes.TYPES.forEach(xva$0 -> this.typeManager.registerTypes(new Class[]{xva$0}));
    }

    @Provider
    public Hostname hostname(ServiceExtensionContext context) {
        String hostname = context.getSetting(HOSTNAME_SETTING, DEFAULT_HOSTNAME);
        if (DEFAULT_HOSTNAME.equals(hostname)) {
            context.getMonitor().warning(String.format("Settings: No setting found for key '%s'. Using default value '%s'", HOSTNAME_SETTING, DEFAULT_HOSTNAME), new Throwable[0]);
        }
        return () -> hostname;
    }

    @Provider
    public RemoteMessageDispatcherRegistry remoteMessageDispatcherRegistry() {
        return new RemoteMessageDispatcherRegistryImpl();
    }

    @Provider
    public CommandHandlerRegistry commandHandlerRegistry() {
        return new CommandHandlerRegistryImpl();
    }

    @Provider
    public ParticipantAgentService participantAgentService(ServiceExtensionContext context) {
        String identityKey = context.getSetting(IDENTITY_KEY, "client_id");
        return new ParticipantAgentServiceImpl(identityKey);
    }

    @Provider
    public RuleBindingRegistry ruleBindingRegistry() {
        return this.ruleBindingRegistry;
    }

    @Provider
    public PolicyEngine policyEngine() {
        ScopeFilter scopeFilter = new ScopeFilter(this.ruleBindingRegistry);
        return new PolicyEngineImpl(scopeFilter);
    }

    @Provider
    public EventRouter eventRouter(ServiceExtensionContext context) {
        return new EventRouterImpl(context.getMonitor(), this.eventExecutorServiceContainer.getExecutorService());
    }

    @Provider
    public HealthCheckService healthCheckService() {
        return this.healthCheckService;
    }

    @Provider
    public TypeTransformerRegistry typeTransformerRegistry() {
        return new TypeTransformerRegistryImpl();
    }

    @Provider
    public JsonObjectValidatorRegistry jsonObjectValidator() {
        return new JsonObjectValidatorRegistryImpl();
    }

    private HealthCheckServiceConfiguration getHealthCheckConfig(ServiceExtensionContext context) {
        return HealthCheckServiceConfiguration.Builder.newInstance().livenessPeriod(Duration.ofSeconds(context.getSetting(LIVENESS_PERIOD_SECONDS_SETTING, 60L))).startupStatusPeriod(Duration.ofSeconds(context.getSetting(STARTUP_PERIOD_SECONDS_SETTING, 60L))).readinessPeriod(Duration.ofSeconds(context.getSetting(READINESS_PERIOD_SECONDS_SETTING, 60L))).readinessPeriod(Duration.ofSeconds(context.getSetting(READINESS_PERIOD_SECONDS_SETTING, 60L))).threadPoolSize(context.getSetting(THREADPOOL_SIZE_SETTING, 3)).build();
    }
}

