/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.health;

import java.time.Duration;

public class HealthCheckServiceConfiguration {
    public static final long DEFAULT_PERIOD_SECONDS = 60L;
    public static final int DEFAULT_THREADPOOL_SIZE = 3;
    private int threadPoolSize = 3;
    private Duration readinessPeriod = Duration.ofSeconds(60L);
    private Duration livenessPeriod = Duration.ofSeconds(60L);
    private Duration startupStatusPeriod = Duration.ofSeconds(60L);

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public Duration getReadinessPeriod() {
        return this.readinessPeriod;
    }

    public Duration getLivenessPeriod() {
        return this.livenessPeriod;
    }

    public Duration getStartupStatusPeriod() {
        return this.startupStatusPeriod;
    }

    public static final class Builder {
        private final HealthCheckServiceConfiguration config = new HealthCheckServiceConfiguration();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder readinessPeriod(Duration readinessPeriod) {
            this.config.readinessPeriod = readinessPeriod;
            return this;
        }

        public Builder livenessPeriod(Duration livenessPeriod) {
            this.config.livenessPeriod = livenessPeriod;
            return this;
        }

        public Builder startupStatusPeriod(Duration startupStatusPeriod) {
            this.config.startupStatusPeriod = startupStatusPeriod;
            return this;
        }

        public Builder threadPoolSize(int threadPoolSize) {
            this.config.threadPoolSize = threadPoolSize;
            return this;
        }

        public HealthCheckServiceConfiguration build() {
            return this.config;
        }
    }
}

