/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core;

import dev.failsafe.RetryPolicy;
import java.util.concurrent.Executors;
import okhttp3.EventListener;
import okhttp3.OkHttpClient;
import org.eclipse.edc.connector.core.base.EdcHttpClientImpl;
import org.eclipse.edc.connector.core.base.OkHttpClientFactory;
import org.eclipse.edc.connector.core.base.RetryPolicyFactory;
import org.eclipse.edc.connector.core.event.EventExecutorServiceContainer;
import org.eclipse.edc.connector.core.vault.InMemoryVault;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.spi.http.EdcHttpClient;
import org.eclipse.edc.spi.security.CertificateResolver;
import org.eclipse.edc.spi.security.PrivateKeyResolver;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.security.VaultCertificateResolver;
import org.eclipse.edc.spi.security.VaultPrivateKeyResolver;
import org.eclipse.edc.spi.system.ExecutorInstrumentation;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.datasource.spi.DefaultDataSourceRegistry;
import org.eclipse.edc.transaction.spi.NoopTransactionContext;
import org.eclipse.edc.transaction.spi.TransactionContext;

public class CoreDefaultServicesExtension
implements ServiceExtension {
    public static final String NAME = "Core Default Services";
    @Inject(required=false)
    private EventListener okHttpEventListener;
    private InMemoryVault inMemoryVault;

    public String name() {
        return NAME;
    }

    @Provider(isDefault=true)
    public TransactionContext defaultTransactionContext(ServiceExtensionContext context) {
        context.getMonitor().warning("No TransactionContext registered, a no-op implementation will be used, not suitable for production environments", new Throwable[0]);
        return new NoopTransactionContext();
    }

    @Provider(isDefault=true)
    public DataSourceRegistry dataSourceRegistry(ServiceExtensionContext context) {
        context.getMonitor().warning("No DataSourceRegistry registered, DefaultDataSourceRegistry will be used, not suitable for production environments", new Throwable[0]);
        return new DefaultDataSourceRegistry();
    }

    @Provider(isDefault=true)
    public ExecutorInstrumentation defaultInstrumentation() {
        return ExecutorInstrumentation.noop();
    }

    @Provider(isDefault=true)
    public EventExecutorServiceContainer eventExecutorServiceContainer() {
        return new EventExecutorServiceContainer(Executors.newFixedThreadPool(1));
    }

    @Provider(isDefault=true)
    public Vault vault(ServiceExtensionContext context) {
        return this.getVault(context);
    }

    @Provider(isDefault=true)
    public PrivateKeyResolver privateKeyResolver(ServiceExtensionContext context) {
        return new VaultPrivateKeyResolver(this.getVault(context));
    }

    @Provider(isDefault=true)
    public CertificateResolver certificateResolver(ServiceExtensionContext context) {
        return new VaultCertificateResolver(this.getVault(context));
    }

    @Provider
    public EdcHttpClient edcHttpClient(ServiceExtensionContext context) {
        return new EdcHttpClientImpl(this.okHttpClient(context), this.retryPolicy(context), context.getMonitor());
    }

    @Provider
    public OkHttpClient okHttpClient(ServiceExtensionContext context) {
        return OkHttpClientFactory.create(context, this.okHttpEventListener);
    }

    @Provider
    public <T> RetryPolicy<T> retryPolicy(ServiceExtensionContext context) {
        return RetryPolicyFactory.create(context);
    }

    private Vault getVault(ServiceExtensionContext context) {
        if (this.inMemoryVault == null) {
            this.inMemoryVault = new InMemoryVault(context.getMonitor());
        }
        return this.inMemoryVault;
    }
}

