/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.base;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.jetbrains.annotations.NotNull;

public class OkHttpClientFactory {
    private static final String DEFAULT_TIMEOUT = "30";
    private static final String DEFAULT_HTTPS_ENFORCE = "false";
    @Setting(value="DEPRECATED. If true, enable HTTPS call enforcement. Default value is 'false'", type="boolean")
    @Deprecated(since="0.1.3")
    public static final String EDC_HTTP_ENFORCE_HTTPS = "edc.http.enforce-https";
    @Setting(value="If true, enable HTTPS call enforcement.", defaultValue="false", type="boolean")
    public static final String EDC_HTTP_CLIENT_HTTPS_ENFORCE = "edc.http.client.https.enforce";
    @Setting(value="HTTP Client connect timeout, in seconds", defaultValue="30", type="int")
    public static final String EDC_HTTP_CLIENT_TIMEOUT_CONNECT = "edc.http.client.timeout.connect";
    @Setting(value="HTTP Client read timeout, in seconds", defaultValue="30", type="int")
    public static final String EDC_HTTP_CLIENT_TIMEOUT_READ = "edc.http.client.timeout.read";

    @NotNull
    public static OkHttpClient create(ServiceExtensionContext context, EventListener okHttpEventListener) {
        boolean enforceHttps;
        int connectTimeout = context.getSetting(EDC_HTTP_CLIENT_TIMEOUT_CONNECT, Integer.parseInt(DEFAULT_TIMEOUT));
        int readTimeout = context.getSetting(EDC_HTTP_CLIENT_TIMEOUT_READ, Integer.parseInt(DEFAULT_TIMEOUT));
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout((long)connectTimeout, TimeUnit.SECONDS).readTimeout((long)readTimeout, TimeUnit.SECONDS);
        Optional.ofNullable(okHttpEventListener).ifPresent(arg_0 -> ((OkHttpClient.Builder)builder).eventListener(arg_0));
        if (context.getSetting(EDC_HTTP_ENFORCE_HTTPS, null) != null) {
            context.getMonitor().warning(String.format("Configuration setting %s has been deprecated, please use %s instead", EDC_HTTP_ENFORCE_HTTPS, EDC_HTTP_CLIENT_HTTPS_ENFORCE), new Throwable[0]);
        }
        if (enforceHttps = context.getSetting(EDC_HTTP_CLIENT_HTTPS_ENFORCE, context.getSetting(EDC_HTTP_ENFORCE_HTTPS, Boolean.parseBoolean(DEFAULT_HTTPS_ENFORCE)))) {
            builder.addInterceptor((Interceptor)new EnforceHttps());
        } else {
            context.getMonitor().info("HTTPS enforcement it not enabled, please enable it in a production environment", new Throwable[0]);
        }
        return builder.build();
    }

    private static class EnforceHttps
    implements Interceptor {
        private EnforceHttps() {
        }

        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            if (!request.isHttps()) {
                throw new EdcException(String.format("HTTP call to %s blocked due to HTTPS enforcement enabled", request.url()));
            }
            return chain.proceed(request);
        }
    }
}

