/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.base;

import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.okhttp.FailsafeCall;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import okhttp3.Call;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.dnsoverhttps.DnsOverHttps;
import org.eclipse.edc.spi.http.EdcHttpClient;
import org.eclipse.edc.spi.http.FallbackFactory;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;

public class EdcHttpClientImpl
implements EdcHttpClient {
    private final OkHttpClient okHttpClient;
    private final RetryPolicy<Response> retryPolicy;
    private final Monitor monitor;

    public EdcHttpClientImpl(OkHttpClient okHttpClient, RetryPolicy<Response> retryPolicy, Monitor monitor) {
        this.okHttpClient = okHttpClient;
        this.retryPolicy = retryPolicy;
        this.monitor = monitor;
    }

    public Response execute(Request request) throws IOException {
        return this.execute(request, Collections.emptyList());
    }

    public Response execute(Request request, List<FallbackFactory> fallbacks) throws IOException {
        Call call = this.okHttpClient.newCall(request);
        FailsafeCall.FailsafeCallBuilder builder = FailsafeCall.with(this.retryPolicy, (Policy[])new RetryPolicy[0]);
        fallbacks.stream().map(it -> it.create(request)).forEach(arg_0 -> ((FailsafeCall.FailsafeCallBuilder)builder).compose(arg_0));
        return builder.compose(call).execute();
    }

    public <T> Result<T> execute(Request request, Function<Response, Result<T>> mappingFunction) {
        return this.execute(request, Collections.emptyList(), mappingFunction);
    }

    public <T> Result<T> execute(Request request, List<FallbackFactory> fallbacks, Function<Response, Result<T>> mappingFunction) {
        Result<T> result;
        block8: {
            Response response = this.execute(request, fallbacks);
            try {
                result = mappingFunction.apply(response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    this.monitor.severe("HTTP client exception caught for request " + request, new Throwable[]{e});
                    return Result.failure((String)e.getMessage());
                }
            }
            response.close();
        }
        return result;
    }

    public <T> CompletableFuture<T> executeAsync(Request request, Function<Response, T> mappingFunction) {
        return this.executeAsync(request, Collections.emptyList(), mappingFunction);
    }

    public <T> CompletableFuture<T> executeAsync(Request request, List<FallbackFactory> fallbacks, Function<Response, T> mappingFunction) {
        Call call = this.okHttpClient.newCall(request);
        FailsafeCall.FailsafeCallBuilder builder = FailsafeCall.with(this.retryPolicy, (Policy[])new RetryPolicy[0]);
        fallbacks.stream().map(it -> it.create(request)).forEach(arg_0 -> ((FailsafeCall.FailsafeCallBuilder)builder).compose(arg_0));
        return builder.compose(call).executeAsync().thenApply(response -> {
            try (Response response2 = response;){
                Object r = mappingFunction.apply((Response)response);
                return r;
            }
        });
    }

    public EdcHttpClient withDns(String dnsServer) {
        HttpUrl url = Objects.requireNonNull(HttpUrl.get((String)dnsServer));
        DnsOverHttps dns = new DnsOverHttps.Builder().client(this.okHttpClient).url(url).includeIPv6(false).build();
        return new EdcHttpClientImpl(this.okHttpClient.newBuilder().dns((Dns)dns).build(), this.retryPolicy, this.monitor);
    }
}

