/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.entity;

import java.time.Clock;
import java.util.Objects;
import org.eclipse.edc.spi.entity.StateEntityManager;
import org.eclipse.edc.spi.entity.StatefulEntity;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.persistence.StateEntityStore;
import org.eclipse.edc.spi.retry.ExponentialWaitStrategy;
import org.eclipse.edc.spi.retry.WaitStrategy;
import org.eclipse.edc.spi.system.ExecutorInstrumentation;
import org.eclipse.edc.spi.telemetry.Telemetry;
import org.eclipse.edc.statemachine.StateMachineManager;
import org.eclipse.edc.statemachine.retry.EntityRetryProcessConfiguration;
import org.eclipse.edc.statemachine.retry.EntityRetryProcessFactory;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractStateEntityManager<E extends StatefulEntity<E>, S extends StateEntityStore<E>>
implements StateEntityManager {
    public static final long DEFAULT_ITERATION_WAIT = 1000L;
    public static final int DEFAULT_BATCH_SIZE = 20;
    public static final int DEFAULT_SEND_RETRY_LIMIT = 7;
    public static final long DEFAULT_SEND_RETRY_BASE_DELAY = 1000L;
    protected Monitor monitor;
    protected int batchSize = 20;
    protected WaitStrategy waitStrategy = () -> 1000L;
    protected ExecutorInstrumentation executorInstrumentation = ExecutorInstrumentation.noop();
    protected Telemetry telemetry = new Telemetry();
    protected EntityRetryProcessConfiguration entityRetryProcessConfiguration = this.defaultEntityRetryProcessConfiguration();
    protected EntityRetryProcessFactory entityRetryProcessFactory;
    protected StateMachineManager stateMachineManager;
    protected Clock clock = Clock.systemUTC();
    protected S store;

    public void start() {
        this.entityRetryProcessFactory = new EntityRetryProcessFactory(this.monitor, this.clock, this.entityRetryProcessConfiguration);
        StateMachineManager.Builder stateMachineManagerBuilder = StateMachineManager.Builder.newInstance((String)this.getClass().getSimpleName(), (Monitor)this.monitor, (ExecutorInstrumentation)this.executorInstrumentation, (WaitStrategy)this.waitStrategy);
        this.stateMachineManager = this.configureStateMachineManager(stateMachineManagerBuilder).build();
        this.stateMachineManager.start();
    }

    public void stop() {
        if (this.stateMachineManager != null) {
            this.stateMachineManager.stop();
        }
    }

    protected abstract StateMachineManager.Builder configureStateMachineManager(StateMachineManager.Builder var1);

    @NotNull
    private EntityRetryProcessConfiguration defaultEntityRetryProcessConfiguration() {
        return new EntityRetryProcessConfiguration(7, () -> new ExponentialWaitStrategy(1000L));
    }

    protected void update(E entity) {
        this.store.save(entity);
        this.monitor.debug(() -> "[%s] %s %s is now in state %s".formatted(this.getClass().getSimpleName(), entity.getClass().getSimpleName(), entity.getId(), entity.stateAsString()), new Throwable[0]);
    }

    protected void breakLease(E entity) {
        this.store.save(entity);
    }

    public static abstract class Builder<E extends StatefulEntity<E>, S extends StateEntityStore<E>, M extends AbstractStateEntityManager<E, S>, B extends Builder<E, S, M, B>> {
        protected final M manager;

        protected Builder(M manager) {
            this.manager = manager;
        }

        public abstract B self();

        public B monitor(Monitor monitor) {
            ((AbstractStateEntityManager)this.manager).monitor = monitor;
            return this.self();
        }

        public B batchSize(int batchSize) {
            ((AbstractStateEntityManager)this.manager).batchSize = batchSize;
            return this.self();
        }

        public B waitStrategy(WaitStrategy waitStrategy) {
            ((AbstractStateEntityManager)this.manager).waitStrategy = waitStrategy;
            return this.self();
        }

        public B clock(Clock clock) {
            ((AbstractStateEntityManager)this.manager).clock = clock;
            return this.self();
        }

        public B telemetry(Telemetry telemetry) {
            ((AbstractStateEntityManager)this.manager).telemetry = telemetry;
            return this.self();
        }

        public B executorInstrumentation(ExecutorInstrumentation executorInstrumentation) {
            ((AbstractStateEntityManager)this.manager).executorInstrumentation = executorInstrumentation;
            return this.self();
        }

        public B entityRetryProcessConfiguration(EntityRetryProcessConfiguration entityRetryProcessConfiguration) {
            ((AbstractStateEntityManager)this.manager).entityRetryProcessConfiguration = entityRetryProcessConfiguration;
            return this.self();
        }

        public B store(S store) {
            ((AbstractStateEntityManager)this.manager).store = store;
            return this.self();
        }

        public M build() {
            Objects.requireNonNull(((AbstractStateEntityManager)this.manager).store, "store");
            Objects.requireNonNull(((AbstractStateEntityManager)this.manager).monitor, "monitor");
            ((AbstractStateEntityManager)this.manager).entityRetryProcessFactory = new EntityRetryProcessFactory(((AbstractStateEntityManager)this.manager).monitor, ((AbstractStateEntityManager)this.manager).clock, ((AbstractStateEntityManager)this.manager).entityRetryProcessConfiguration);
            return this.manager;
        }
    }
}

