/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.store;

import java.util.Comparator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.edc.connector.core.store.CriterionToPredicateConverterImpl;
import org.eclipse.edc.spi.query.CriterionToPredicateConverter;
import org.eclipse.edc.spi.query.QueryResolver;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.query.SortOrder;
import org.eclipse.edc.util.reflection.ReflectionUtil;
import org.jetbrains.annotations.NotNull;

public class ReflectionBasedQueryResolver<T>
implements QueryResolver<T> {
    private final Class<T> typeParameterClass;
    private final CriterionToPredicateConverter predicateConverter = new CriterionToPredicateConverterImpl();

    public ReflectionBasedQueryResolver(Class<T> typeParameterClass) {
        this.typeParameterClass = typeParameterClass;
    }

    public Stream<T> query(Stream<T> stream, QuerySpec spec) {
        Predicate andPredicate = spec.getFilterExpression().stream().map(arg_0 -> ((CriterionToPredicateConverter)this.predicateConverter).convert(arg_0)).reduce(x -> true, Predicate::and);
        Stream<T> filteredStream = stream.filter(andPredicate);
        String sortField = spec.getSortField();
        if (sortField != null) {
            if (ReflectionUtil.getFieldRecursive(this.typeParameterClass, (String)sortField) == null) {
                throw new IllegalArgumentException(String.format("Cannot sort by %s, the field does not exist in %s", sortField, this.typeParameterClass));
            }
            Comparator<T> comparator = this.propertyComparator(spec.getSortOrder() == SortOrder.ASC, sortField);
            filteredStream = filteredStream.sorted(comparator);
        }
        return filteredStream.skip(spec.getOffset()).limit(spec.getLimit());
    }

    @NotNull
    private Comparator<T> propertyComparator(boolean isAscending, String property) {
        return (obj1, obj2) -> {
            Object o1 = ReflectionUtil.getFieldValue((String)property, (Object)obj1);
            Object o2 = ReflectionUtil.getFieldValue((String)property, (Object)obj2);
            if (o1 == null || o2 == null) {
                return 0;
            }
            if (!(o1 instanceof Comparable)) {
                throw new IllegalArgumentException("A property '" + property + "' is not comparable!");
            }
            Comparable comp1 = (Comparable)o1;
            Comparable comp2 = (Comparable)o2;
            return isAscending ? comp1.compareTo(comp2) : comp2.compareTo(comp1);
        };
    }
}

