/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core;

import org.eclipse.edc.connector.core.security.KeyParserRegistryImpl;
import org.eclipse.edc.connector.core.security.keyparsers.JwkParser;
import org.eclipse.edc.connector.core.security.keyparsers.PemParser;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.spi.iam.PublicKeyResolver;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.security.CertificateResolver;
import org.eclipse.edc.spi.security.KeyParser;
import org.eclipse.edc.spi.security.KeyParserRegistry;
import org.eclipse.edc.spi.security.PrivateKeyResolver;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.security.VaultCertificateResolver;
import org.eclipse.edc.spi.security.VaultPrivateKeyResolver;
import org.eclipse.edc.spi.security.VaultPublicKeyResolver;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;

@Extension(value="Security Default Services Extension")
public class SecurityDefaultServicesExtension
implements ServiceExtension {
    public static final String NAME = "Security Default Services Extension";
    private KeyParserRegistry keyParserRegistry;
    @Inject
    private Vault vault;
    @Inject
    private TypeManager typeManager;
    private PrivateKeyResolver privateKeyResolver;

    @Provider(isDefault=true)
    public PrivateKeyResolver privateKeyResolver(ServiceExtensionContext context) {
        if (this.privateKeyResolver == null) {
            this.privateKeyResolver = new VaultPrivateKeyResolver(this.keyParserRegistry(context), this.vault, context.getMonitor().withPrefix("PrivateKeyResolution"), context.getConfig());
        }
        return this.privateKeyResolver;
    }

    @Provider(isDefault=true)
    public PublicKeyResolver createDefaultPublicKeyResolver(ServiceExtensionContext context) {
        return new VaultPublicKeyResolver(this.keyParserRegistry(context), context.getConfig(), context.getMonitor().withPrefix("PublicKeyResolution"), this.vault);
    }

    @Provider(isDefault=true)
    public CertificateResolver certificateResolver() {
        return new VaultCertificateResolver(this.vault);
    }

    @Provider
    public KeyParserRegistry keyParserRegistry(ServiceExtensionContext context) {
        if (this.keyParserRegistry == null) {
            this.keyParserRegistry = new KeyParserRegistryImpl();
            Monitor monitor = context.getMonitor().withPrefix("PrivateKeyResolution");
            this.keyParserRegistry.register((KeyParser)new JwkParser(this.typeManager.getMapper(), monitor));
            this.keyParserRegistry.register((KeyParser)new PemParser(monitor));
        }
        return this.keyParserRegistry;
    }
}

