/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.security.keyparsers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyConverter;
import com.nimbusds.jose.jwk.OctetKeyPair;
import java.io.IOException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.KeyParser;

public class JwkParser
implements KeyParser {
    public static final String ERROR_NO_KEY = "The provided key material was in JSON format, but did not contain any (readable) JWK key";
    protected final Monitor monitor;
    private final ObjectMapper objectMapper;

    public JwkParser(ObjectMapper objectMapper, Monitor monitor) {
        this.objectMapper = objectMapper;
        this.monitor = monitor;
    }

    public boolean canHandle(String encoded) {
        boolean bl;
        block8: {
            JsonParser parser = this.objectMapper.createParser(encoded);
            try {
                parser.nextToken();
                bl = true;
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            parser.close();
        }
        return bl;
    }

    public Result<Key> parse(String encoded) {
        try {
            JWK jwk = JWK.parse((String)encoded);
            if (jwk instanceof OctetKeyPair) {
                OctetKeyPair okp = (OctetKeyPair)jwk;
                return (Result)this.parseOctetKeyPair(okp).map(key -> key);
            }
            List list = KeyConverter.toJavaKeys(List.of(jwk));
            return list.stream().filter(k -> k instanceof PrivateKey).findFirst().or(() -> list.stream().filter(k -> k instanceof PublicKey).findFirst()).map(Result::success).orElse(Result.failure((String)ERROR_NO_KEY));
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException | ParseException e) {
            this.monitor.warning("Parser error", new Throwable[]{e});
            return Result.failure((String)("Parser error: " + e.getMessage()));
        }
    }

    private Result<? extends Key> parseOctetKeyPair(OctetKeyPair okp) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        byte[] d = okp.getDecodedD();
        byte[] x = okp.getDecodedX();
        if (d == null && x == null) {
            return Result.failure((String)ERROR_NO_KEY);
        }
        if (d != null) {
            return this.readPrivateKey(okp.getCurve(), d);
        }
        return this.readPublicKey(okp.getCurve(), x);
    }

    private Result<PrivateKey> readPrivateKey(Curve curve, byte[] decodedD) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        PrivateKeyInfo privKeyInfo;
        KeyFactory keyFactory;
        if (curve == Curve.Ed25519) {
            keyFactory = KeyFactory.getInstance(Curve.Ed25519.getName());
            privKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), (ASN1Encodable)new DEROctetString(decodedD));
        } else if (curve == Curve.X25519) {
            keyFactory = KeyFactory.getInstance(Curve.X25519.getName());
            privKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), (ASN1Encodable)new DEROctetString(decodedD));
        } else {
            return Result.failure((String)"Cannot parse an OctetKeyPair with Curve %s".formatted(curve));
        }
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privKeyInfo.getEncoded());
        PrivateKey jcaPrivateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        return Result.success((Object)jcaPrivateKey);
    }

    private Result<PublicKey> readPublicKey(Curve curve, byte[] decodedX) throws InvalidKeySpecException, IOException, NoSuchAlgorithmException {
        X509EncodedKeySpec x509KeySpec;
        KeyFactory keyFactory;
        if (curve == Curve.Ed25519) {
            keyFactory = KeyFactory.getInstance(Curve.Ed25519.getName());
            SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), decodedX);
            x509KeySpec = new X509EncodedKeySpec(publicKeyInfo.getEncoded());
        } else if (curve == Curve.X25519) {
            keyFactory = KeyFactory.getInstance(Curve.X25519.getName());
            SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), decodedX);
            x509KeySpec = new X509EncodedKeySpec(publicKeyInfo.getEncoded());
        } else {
            return Result.failure((String)"Cannot parse an OctetKeyPair with Curve %s".formatted(curve));
        }
        return Result.success((Object)keyFactory.generatePublic(x509KeySpec));
    }
}

