/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.store;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.CriterionToPredicateConverter;
import org.eclipse.edc.util.reflection.ReflectionException;
import org.eclipse.edc.util.reflection.ReflectionUtil;
import org.jetbrains.annotations.NotNull;

public class CriterionToPredicateConverterImpl
implements CriterionToPredicateConverter {
    public <T> Predicate<T> convert(Criterion criterion) {
        String operator;
        return switch (operator = criterion.getOperator().toLowerCase()) {
            case "=" -> this.equalPredicate(criterion);
            case "in" -> this.inPredicate(criterion);
            case "like" -> this.likePredicate(criterion);
            case "contains" -> this.containsPredicate(criterion);
            default -> throw new IllegalArgumentException(String.format("Operator [%s] is not supported by this converter!", criterion.getOperator()));
        };
    }

    protected Object property(String key, Object object) {
        try {
            return ReflectionUtil.getFieldValue((String)key, (Object)object);
        }
        catch (ReflectionException e) {
            return null;
        }
    }

    private <T> Predicate<T> containsPredicate(Criterion criterion) {
        return t -> {
            String operandLeft = (String)criterion.getOperandLeft();
            Object operandRight = criterion.getOperandRight();
            Object property = this.property(operandLeft, t);
            if (property == null) {
                return false;
            }
            if (property instanceof Collection) {
                Collection collection = (Collection)property;
                return collection.contains(operandRight);
            }
            return false;
        };
    }

    @NotNull
    private <T> Predicate<T> equalPredicate(Criterion criterion) {
        return t -> {
            String operandLeft = (String)criterion.getOperandLeft();
            Object property = this.property(operandLeft, t);
            if (property == null) {
                return false;
            }
            if (property.getClass().isEnum()) {
                Enum enumProperty = (Enum)property;
                if (criterion.getOperandRight() instanceof String) {
                    return Objects.equals(enumProperty.name(), criterion.getOperandRight());
                }
                if (criterion.getOperandRight() instanceof Number) {
                    return Objects.equals(enumProperty.ordinal(), criterion.getOperandRight());
                }
            }
            if (property instanceof Number) {
                Number c1 = (Number)property;
                Object patt3239$temp = criterion.getOperandRight();
                if (patt3239$temp instanceof Number) {
                    Number c2 = (Number)patt3239$temp;
                    return Double.compare(c1.doubleValue(), c2.doubleValue()) == 0;
                }
            }
            if (property instanceof List) {
                List list = (List)property;
                return list.stream().anyMatch(it -> Objects.equals(it, criterion.getOperandRight()));
            }
            return Objects.equals(property, criterion.getOperandRight());
        };
    }

    @NotNull
    private <T> Predicate<T> inPredicate(Criterion criterion) {
        return t -> {
            String operandLeft = (String)criterion.getOperandLeft();
            Object property = this.property(operandLeft, t);
            if (property == null) {
                return false;
            }
            Object patt4028$temp = criterion.getOperandRight();
            if (patt4028$temp instanceof Iterable) {
                Iterable iterable = (Iterable)patt4028$temp;
                for (Object value : iterable) {
                    if (!value.equals(property)) continue;
                    return true;
                }
                return false;
            }
            throw new IllegalArgumentException("Operator IN requires the right-hand operand to be an " + Iterable.class.getName() + " but was " + criterion.getOperandRight().getClass().getName());
        };
    }

    @NotNull
    private <T> Predicate<T> likePredicate(Criterion criterion) {
        return t -> {
            String operandLeft = (String)criterion.getOperandLeft();
            Object property = this.property(operandLeft, t);
            if (property == null) {
                return false;
            }
            Object patt4867$temp = criterion.getOperandRight();
            if (patt4867$temp instanceof String) {
                String operandRight = (String)patt4867$temp;
                Object regexPattern = Pattern.quote(operandRight).replace("%", "\\E.*\\Q").replace("_", "\\E.\\Q");
                regexPattern = "^" + (String)regexPattern + "$";
                return Pattern.compile((String)regexPattern).matcher(property.toString()).matches();
            }
            return false;
        };
    }
}

