/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.store;

import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.edc.connector.core.store.CriterionToPredicateConverterImpl;
import org.eclipse.edc.connector.core.store.ReflectionBasedQueryResolver;
import org.eclipse.edc.spi.entity.StatefulEntity;
import org.eclipse.edc.spi.persistence.Lease;
import org.eclipse.edc.spi.persistence.StateEntityStore;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.CriterionToPredicateConverter;
import org.eclipse.edc.spi.query.QueryResolver;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.StoreResult;
import org.eclipse.edc.util.concurrency.LockManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InMemoryStatefulEntityStore<T extends StatefulEntity<T>>
implements StateEntityStore<T> {
    private static final Duration DEFAULT_LEASE_TIME = Duration.ofSeconds(60L);
    private final Map<String, T> entitiesById = new ConcurrentHashMap<String, T>();
    private final QueryResolver<T> queryResolver;
    private final LockManager lockManager = new LockManager((ReadWriteLock)new ReentrantReadWriteLock());
    private final String lockId;
    private final Clock clock;
    private final Map<String, Lease> leases = new HashMap<String, Lease>();
    private final CriterionToPredicateConverter criterionConverter = new CriterionToPredicateConverterImpl();

    public InMemoryStatefulEntityStore(Class<T> clazz, String lockId, Clock clock) {
        this.queryResolver = new ReflectionBasedQueryResolver<T>(clazz);
        this.lockId = lockId;
        this.clock = clock;
    }

    @Nullable
    public T findById(String id) {
        StatefulEntity t = (StatefulEntity)this.entitiesById.get(id);
        if (t == null) {
            return null;
        }
        return (T)t.copy();
    }

    @NotNull
    public List<T> nextNotLeased(int max, Criterion ... criteria) {
        return (List)this.lockManager.writeLock(() -> {
            Predicate filterPredicate = Arrays.stream(criteria).map(arg_0 -> ((CriterionToPredicateConverter)this.criterionConverter).convert(arg_0)).reduce(x -> true, Predicate::and);
            List<StatefulEntity> entities = this.entitiesById.values().stream().filter(filterPredicate).filter(e -> !this.isLeased(e.getId())).sorted(Comparator.comparingLong(StatefulEntity::getStateTimestamp)).limit(max).toList();
            entities.forEach(i -> this.acquireLease(i.getId()));
            return entities.stream().map(StatefulEntity::copy).collect(Collectors.toList());
        });
    }

    public StoreResult<T> findByIdAndLease(String id) {
        return (StoreResult)this.lockManager.writeLock(() -> {
            StatefulEntity entity = (StatefulEntity)this.entitiesById.get(id);
            if (entity == null) {
                return StoreResult.notFound((String)String.format("Entity %s not found", id));
            }
            try {
                this.acquireLease(id);
                return StoreResult.success((Object)entity);
            }
            catch (IllegalStateException e) {
                return StoreResult.alreadyLeased((String)String.format("Entity %s is already leased: %s", id, e.getMessage()));
            }
        });
    }

    public void save(T entity) {
        this.acquireLease(entity.getId());
        this.entitiesById.put(entity.getId(), entity.copy());
        this.freeLease(entity.getId());
    }

    public void delete(String id) {
        if (this.isLeased(id)) {
            throw new IllegalStateException("Entity is leased and cannot be deleted!");
        }
        this.entitiesById.remove(id);
    }

    public Stream<T> findAll(QuerySpec querySpec) {
        return this.queryResolver.query(this.findAll(), querySpec);
    }

    public Stream<T> findAll() {
        return this.entitiesById.values().stream();
    }

    public void acquireLease(String id, String lockId, Duration leaseTime) {
        if (this.isLeased(id) && !this.isLeasedBy(id, lockId)) {
            throw new IllegalStateException("Cannot acquire lease, is already leased by someone else!");
        }
        this.leases.put(id, new Lease(lockId, this.clock.millis(), leaseTime.toMillis()));
    }

    public boolean isLeasedBy(String id, String lockId) {
        return this.isLeased(id) && this.leases.get(id).getLeasedBy().equals(lockId);
    }

    private void freeLease(String id) {
        this.leases.remove(id);
    }

    private void acquireLease(String id) {
        this.acquireLease(id, this.lockId, DEFAULT_LEASE_TIME);
    }

    private boolean isLeased(String id) {
        return this.leases.containsKey(id) && !this.leases.get(id).isExpired(this.clock.millis());
    }
}

